/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ErrorCategory;
import com.mongodb.assertions.Assertions;
import org.bson.BsonDocument;

public class WriteError {
    private final int code;
    private final String message;
    private final BsonDocument details;

    public WriteError(int n, String string, BsonDocument bsonDocument) {
        this.code = n;
        this.message = Assertions.notNull("message", string);
        this.details = Assertions.notNull("details", bsonDocument);
    }

    public WriteError(WriteError writeError) {
        this.code = writeError.code;
        this.message = writeError.message;
        this.details = writeError.details;
    }

    public ErrorCategory getCategory() {
        return ErrorCategory.fromErrorCode(this.code);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public BsonDocument getDetails() {
        return this.details;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WriteError writeError = (WriteError)object;
        if (this.code != writeError.code) {
            return false;
        }
        if (!this.details.equals(writeError.details)) {
            return false;
        }
        return this.message.equals(writeError.message);
    }

    public int hashCode() {
        int n = this.code;
        n = 31 * n + this.message.hashCode();
        n = 31 * n + this.details.hashCode();
        return n;
    }

    public String toString() {
        return "WriteError{code=" + this.code + ", message='" + this.message + '\'' + ", details=" + this.details + '}';
    }
}

