/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.assertions;

import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Assertions {
    public static <T> T notNull(String string, T t) {
        if (t == null) {
            throw new IllegalArgumentException(string + " can not be null");
        }
        return t;
    }

    public static <T> Iterable<T> notNullElements(String string, Iterable<T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(string + " can not be null");
        }
        for (T t : iterable) {
            if (t != null) continue;
            throw new IllegalArgumentException(string + " can not contain null");
        }
        return iterable;
    }

    public static void isTrue(String string, boolean bl) {
        if (!bl) {
            throw new IllegalStateException("state should be: " + string);
        }
    }

    public static void isTrueArgument(String string, boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("state should be: " + string);
        }
    }

    public static <T> T isTrueArgument(String string, Supplier<T> supplier, Function<T, Boolean> function) {
        T t = Assertions.doesNotThrow(supplier);
        if (!function.apply(t).booleanValue()) {
            throw new IllegalArgumentException(string);
        }
        return t;
    }

    public static void doesNotContainNull(String string, Collection<?> collection) {
        for (Object obj : collection) {
            if (obj != null) continue;
            throw new IllegalArgumentException(string + " can not contain a null value");
        }
    }

    @Nullable
    public static <T> T assertNull(@Nullable T t) throws AssertionError {
        if (t != null) {
            throw new AssertionError((Object)t.toString());
        }
        return null;
    }

    public static <T> T assertNotNull(@Nullable T t) throws AssertionError {
        if (t == null) {
            throw new AssertionError();
        }
        return t;
    }

    public static boolean assertTrue(boolean bl) throws AssertionError {
        if (!bl) {
            throw new AssertionError();
        }
        return true;
    }

    public static boolean assertTrue(boolean bl, String string) throws AssertionError {
        if (!bl) {
            throw new AssertionError((Object)string);
        }
        return true;
    }

    public static boolean assertFalse(boolean bl) throws AssertionError {
        if (bl) {
            throw new AssertionError();
        }
        return false;
    }

    public static AssertionError fail() throws AssertionError {
        throw new AssertionError();
    }

    public static AssertionError fail(String string) throws AssertionError {
        throw new AssertionError((Object)Assertions.assertNotNull(string));
    }

    public static <T> T doesNotThrow(Supplier<T> supplier) throws AssertionError {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            throw new AssertionError(exception.getMessage(), exception);
        }
    }

    private Assertions() {
    }
}

