/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.bulk;

import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.internal.bulk.WriteRequest;
import java.util.Collections;
import java.util.List;

public abstract class BulkWriteResult {
    public abstract boolean wasAcknowledged();

    public abstract int getInsertedCount();

    public abstract int getMatchedCount();

    public abstract int getDeletedCount();

    public abstract int getModifiedCount();

    public abstract List<BulkWriteInsert> getInserts();

    public abstract List<BulkWriteUpsert> getUpserts();

    public static BulkWriteResult acknowledged(WriteRequest.Type type, int n, Integer n2, List<BulkWriteUpsert> list, List<BulkWriteInsert> list2) {
        return BulkWriteResult.acknowledged(type == WriteRequest.Type.INSERT ? n : 0, type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE ? n : 0, type == WriteRequest.Type.DELETE ? n : 0, n2, list, list2);
    }

    public static BulkWriteResult acknowledged(final int n, final int n2, final int n3, final Integer n4, final List<BulkWriteUpsert> list, final List<BulkWriteInsert> list2) {
        return new BulkWriteResult(){

            @Override
            public boolean wasAcknowledged() {
                return true;
            }

            @Override
            public int getInsertedCount() {
                return n;
            }

            @Override
            public int getMatchedCount() {
                return n2;
            }

            @Override
            public int getDeletedCount() {
                return n3;
            }

            @Override
            public int getModifiedCount() {
                return Assertions.assertNotNull(n4);
            }

            @Override
            public List<BulkWriteInsert> getInserts() {
                return Collections.unmodifiableList(list2);
            }

            @Override
            public List<BulkWriteUpsert> getUpserts() {
                return Collections.unmodifiableList(list);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                BulkWriteResult bulkWriteResult = (BulkWriteResult)object;
                if (!bulkWriteResult.wasAcknowledged()) {
                    return false;
                }
                if (n != bulkWriteResult.getInsertedCount()) {
                    return false;
                }
                if (!n4.equals(bulkWriteResult.getModifiedCount())) {
                    return false;
                }
                if (n3 != bulkWriteResult.getDeletedCount()) {
                    return false;
                }
                if (n2 != bulkWriteResult.getMatchedCount()) {
                    return false;
                }
                if (!list.equals(bulkWriteResult.getUpserts())) {
                    return false;
                }
                return list2.equals(bulkWriteResult.getInserts());
            }

            public int hashCode() {
                int n5 = list.hashCode();
                n5 = 31 * n5 + list2.hashCode();
                n5 = 31 * n5 + n;
                n5 = 31 * n5 + n2;
                n5 = 31 * n5 + n3;
                n5 = 31 * n5 + n4.hashCode();
                return n5;
            }

            public String toString() {
                return "AcknowledgedBulkWriteResult{insertedCount=" + n + ", matchedCount=" + n2 + ", removedCount=" + n3 + ", modifiedCount=" + n4 + ", upserts=" + list + ", inserts=" + list2 + '}';
            }
        };
    }

    public static BulkWriteResult unacknowledged() {
        return new BulkWriteResult(){

            @Override
            public boolean wasAcknowledged() {
                return false;
            }

            @Override
            public int getInsertedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getMatchedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getDeletedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getModifiedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public List<BulkWriteInsert> getInserts() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public List<BulkWriteUpsert> getUpserts() {
                throw this.getUnacknowledgedWriteException();
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                BulkWriteResult bulkWriteResult = (BulkWriteResult)object;
                return !bulkWriteResult.wasAcknowledged();
            }

            public int hashCode() {
                return 0;
            }

            public String toString() {
                return "UnacknowledgedBulkWriteResult{}";
            }

            private UnsupportedOperationException getUnacknowledgedWriteException() {
                return new UnsupportedOperationException("Cannot get information about an unacknowledged write");
            }
        };
    }
}

