/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.bulk;

import com.mongodb.assertions.Assertions;
import org.bson.BsonDocument;

public class WriteConcernError {
    private final int code;
    private final String codeName;
    private final String message;
    private final BsonDocument details;

    public WriteConcernError(int n, String string, String string2, BsonDocument bsonDocument) {
        this.code = n;
        this.codeName = Assertions.notNull("codeName", string);
        this.message = Assertions.notNull("message", string2);
        this.details = Assertions.notNull("details", bsonDocument);
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getMessage() {
        return this.message;
    }

    public BsonDocument getDetails() {
        return this.details;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WriteConcernError writeConcernError = (WriteConcernError)object;
        if (this.code != writeConcernError.code) {
            return false;
        }
        if (!this.codeName.equals(writeConcernError.codeName)) {
            return false;
        }
        if (!this.details.equals(writeConcernError.details)) {
            return false;
        }
        return this.message.equals(writeConcernError.message);
    }

    public int hashCode() {
        int n = this.code;
        n = 31 * n + this.codeName.hashCode();
        n = 31 * n + this.message.hashCode();
        n = 31 * n + this.details.hashCode();
        return n;
    }

    public String toString() {
        return "WriteConcernError{code=" + this.code + ", codeName='" + this.codeName + '\'' + ", message='" + this.message + '\'' + ", details=" + this.details + '}';
    }
}

