/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client;

import com.mongodb.MongoException;
import com.mongodb.client.MongoClients;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MongoClientFactory
implements ObjectFactory {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private static final String CONNECTION_STRING = "connectionString";

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) {
        String string = null;
        if (hashtable.get(CONNECTION_STRING) instanceof String) {
            string = (String)hashtable.get(CONNECTION_STRING);
        }
        if (string == null || string.isEmpty()) {
            LOGGER.debug(String.format("No '%s' property in environment.  Casting 'obj' to java.naming.Reference to look for a javax.naming.RefAddr with type equal to '%s'", CONNECTION_STRING, CONNECTION_STRING));
            if (object instanceof Reference) {
                Enumeration<RefAddr> enumeration = ((Reference)object).getAll();
                while (enumeration.hasMoreElements()) {
                    RefAddr refAddr = enumeration.nextElement();
                    if (refAddr == null || !CONNECTION_STRING.equals(refAddr.getType()) || !(refAddr.getContent() instanceof String)) continue;
                    string = (String)refAddr.getContent();
                    break;
                }
            }
        }
        if (string == null || string.isEmpty()) {
            throw new MongoException(String.format("Could not locate '%s' in either environment or obj", CONNECTION_STRING));
        }
        return MongoClients.create(string);
    }
}

