/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoGridFSException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSDownloadStreamImpl;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.GridFSFindIterableImpl;
import com.mongodb.client.gridfs.GridFSUploadStream;
import com.mongodb.client.gridfs.GridFSUploadStreamImpl;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

final class GridFSBucketImpl
implements GridFSBucket {
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private static final String TIMEOUT_MESSAGE = "GridFS operation exceeded the timeout limit.";
    private final String bucketName;
    private final int chunkSizeBytes;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<BsonDocument> chunksCollection;
    private volatile boolean checkedIndexes;

    GridFSBucketImpl(MongoDatabase mongoDatabase) {
        this(mongoDatabase, "fs");
    }

    GridFSBucketImpl(MongoDatabase mongoDatabase, String string) {
        this(Assertions.notNull("bucketName", string), 261120, GridFSBucketImpl.getFilesCollection(Assertions.notNull("database", mongoDatabase), string), GridFSBucketImpl.getChunksCollection(mongoDatabase, string));
    }

    GridFSBucketImpl(String string, int n, MongoCollection<GridFSFile> mongoCollection, MongoCollection<BsonDocument> mongoCollection2) {
        this.bucketName = Assertions.notNull("bucketName", string);
        this.chunkSizeBytes = n;
        this.filesCollection = Assertions.notNull("filesCollection", mongoCollection);
        this.chunksCollection = Assertions.notNull("chunksCollection", mongoCollection2);
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        return this.filesCollection.getTimeout(timeUnit);
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int n) {
        return new GridFSBucketImpl(this.bucketName, n, this.filesCollection, this.chunksCollection);
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    @Override
    public GridFSBucket withTimeout(long l, TimeUnit timeUnit) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withTimeout(l, timeUnit), this.chunksCollection.withTimeout(l, timeUnit));
    }

    @Override
    public GridFSUploadStream openUploadStream(String string) {
        return this.openUploadStream(new BsonObjectId(), string);
    }

    @Override
    public GridFSUploadStream openUploadStream(String string, GridFSUploadOptions gridFSUploadOptions) {
        return this.openUploadStream(new BsonObjectId(), string, gridFSUploadOptions);
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue bsonValue, String string) {
        return this.openUploadStream(bsonValue, string, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue bsonValue, String string, GridFSUploadOptions gridFSUploadOptions) {
        return this.createGridFSUploadStream(null, bsonValue, string, gridFSUploadOptions);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String string) {
        return this.openUploadStream(clientSession, new BsonObjectId(), string);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String string, GridFSUploadOptions gridFSUploadOptions) {
        return this.openUploadStream(clientSession, new BsonObjectId(), string, gridFSUploadOptions);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, ObjectId objectId, String string) {
        return this.openUploadStream(clientSession, new BsonObjectId(objectId), string);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue bsonValue, String string) {
        return this.openUploadStream(clientSession, bsonValue, string, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue bsonValue, String string, GridFSUploadOptions gridFSUploadOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSUploadStream(clientSession, bsonValue, string, gridFSUploadOptions);
    }

    private GridFSUploadStream createGridFSUploadStream(@Nullable ClientSession clientSession, BsonValue bsonValue, String string, GridFSUploadOptions gridFSUploadOptions) {
        Timeout timeout = this.startTimeout();
        Assertions.notNull("options", gridFSUploadOptions);
        Integer n = gridFSUploadOptions.getChunkSizeBytes();
        int n2 = n == null ? this.chunkSizeBytes : n;
        this.checkCreateIndex(clientSession, timeout);
        return new GridFSUploadStreamImpl(clientSession, this.filesCollection, this.chunksCollection, bsonValue, string, n2, gridFSUploadOptions.getMetadata(), timeout);
    }

    @Override
    public ObjectId uploadFromStream(String string, InputStream inputStream) {
        return this.uploadFromStream(string, inputStream, new GridFSUploadOptions());
    }

    @Override
    public ObjectId uploadFromStream(String string, InputStream inputStream, GridFSUploadOptions gridFSUploadOptions) {
        ObjectId objectId = new ObjectId();
        this.uploadFromStream(new BsonObjectId(objectId), string, inputStream, gridFSUploadOptions);
        return objectId;
    }

    @Override
    public void uploadFromStream(BsonValue bsonValue, String string, InputStream inputStream) {
        this.uploadFromStream(bsonValue, string, inputStream, new GridFSUploadOptions());
    }

    @Override
    public void uploadFromStream(BsonValue bsonValue, String string, InputStream inputStream, GridFSUploadOptions gridFSUploadOptions) {
        this.executeUploadFromStream(null, bsonValue, string, inputStream, gridFSUploadOptions);
    }

    @Override
    public ObjectId uploadFromStream(ClientSession clientSession, String string, InputStream inputStream) {
        return this.uploadFromStream(clientSession, string, inputStream, new GridFSUploadOptions());
    }

    @Override
    public ObjectId uploadFromStream(ClientSession clientSession, String string, InputStream inputStream, GridFSUploadOptions gridFSUploadOptions) {
        ObjectId objectId = new ObjectId();
        this.uploadFromStream(clientSession, new BsonObjectId(objectId), string, inputStream, gridFSUploadOptions);
        return objectId;
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, BsonValue bsonValue, String string, InputStream inputStream) {
        this.uploadFromStream(clientSession, bsonValue, string, inputStream, new GridFSUploadOptions());
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, BsonValue bsonValue, String string, InputStream inputStream, GridFSUploadOptions gridFSUploadOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.executeUploadFromStream(clientSession, bsonValue, string, inputStream, gridFSUploadOptions);
    }

    private void executeUploadFromStream(@Nullable ClientSession clientSession, BsonValue bsonValue, String string, InputStream inputStream, GridFSUploadOptions gridFSUploadOptions) {
        GridFSUploadStream gridFSUploadStream = this.createGridFSUploadStream(clientSession, bsonValue, string, gridFSUploadOptions);
        Integer n = gridFSUploadOptions.getChunkSizeBytes();
        int n2 = n == null ? this.chunkSizeBytes : n;
        byte[] byArray = new byte[n2];
        try {
            int n3;
            while ((n3 = inputStream.read(byArray)) != -1) {
                gridFSUploadStream.write(byArray, 0, n3);
            }
            gridFSUploadStream.close();
        }
        catch (IOException iOException) {
            gridFSUploadStream.abort();
            throw new MongoGridFSException("IOException when reading from the InputStream", iOException);
        }
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ObjectId objectId) {
        return this.openDownloadStream(new BsonObjectId(objectId));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(BsonValue bsonValue) {
        Timeout timeout = this.startTimeout();
        GridFSFile gridFSFile = this.getFileInfoById(null, bsonValue, timeout);
        return this.createGridFSDownloadStream(null, gridFSFile, timeout);
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String string) {
        return this.openDownloadStream(string, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String string, GridFSDownloadOptions gridFSDownloadOptions) {
        Timeout timeout = this.startTimeout();
        GridFSFile gridFSFile = this.getFileByName(null, string, gridFSDownloadOptions, timeout);
        return this.createGridFSDownloadStream(null, gridFSFile, timeout);
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, ObjectId objectId) {
        return this.openDownloadStream(clientSession, new BsonObjectId(objectId));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, BsonValue bsonValue) {
        Assertions.notNull("clientSession", clientSession);
        Timeout timeout = this.startTimeout();
        GridFSFile gridFSFile = this.getFileInfoById(clientSession, bsonValue, timeout);
        return this.createGridFSDownloadStream(clientSession, gridFSFile, timeout);
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String string) {
        return this.openDownloadStream(clientSession, string, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String string, GridFSDownloadOptions gridFSDownloadOptions) {
        Assertions.notNull("clientSession", clientSession);
        Timeout timeout = this.startTimeout();
        GridFSFile gridFSFile = this.getFileByName(clientSession, string, gridFSDownloadOptions, timeout);
        return this.createGridFSDownloadStream(clientSession, gridFSFile, timeout);
    }

    private GridFSDownloadStream createGridFSDownloadStream(@Nullable ClientSession clientSession, GridFSFile gridFSFile, @Nullable Timeout timeout) {
        return new GridFSDownloadStreamImpl(clientSession, gridFSFile, this.chunksCollection, timeout);
    }

    @Override
    public void downloadToStream(ObjectId objectId, OutputStream outputStream) {
        this.downloadToStream(new BsonObjectId(objectId), outputStream);
    }

    @Override
    public void downloadToStream(BsonValue bsonValue, OutputStream outputStream) {
        this.downloadToStream(this.openDownloadStream(bsonValue), outputStream);
    }

    @Override
    public void downloadToStream(String string, OutputStream outputStream) {
        this.downloadToStream(string, outputStream, new GridFSDownloadOptions());
    }

    @Override
    public void downloadToStream(String string, OutputStream outputStream, GridFSDownloadOptions gridFSDownloadOptions) {
        this.downloadToStream(this.openDownloadStream(string, gridFSDownloadOptions), outputStream);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, ObjectId objectId, OutputStream outputStream) {
        this.downloadToStream(clientSession, new BsonObjectId(objectId), outputStream);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, BsonValue bsonValue, OutputStream outputStream) {
        Assertions.notNull("clientSession", clientSession);
        this.downloadToStream(this.openDownloadStream(clientSession, bsonValue), outputStream);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, String string, OutputStream outputStream) {
        this.downloadToStream(clientSession, string, outputStream, new GridFSDownloadOptions());
    }

    @Override
    public void downloadToStream(ClientSession clientSession, String string, OutputStream outputStream, GridFSDownloadOptions gridFSDownloadOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.downloadToStream(this.openDownloadStream(clientSession, string, gridFSDownloadOptions), outputStream);
    }

    @Override
    public GridFSFindIterable find() {
        return this.createGridFSFindIterable(null, null);
    }

    @Override
    public GridFSFindIterable find(Bson bson) {
        Assertions.notNull("filter", bson);
        return this.createGridFSFindIterable(null, bson);
    }

    @Override
    public GridFSFindIterable find(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSFindIterable(clientSession, null);
    }

    @Override
    public GridFSFindIterable find(ClientSession clientSession, Bson bson) {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("filter", bson);
        return this.createGridFSFindIterable(clientSession, bson);
    }

    private GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, @Nullable Bson bson) {
        return new GridFSFindIterableImpl(this.createFindIterable(clientSession, bson, this.startTimeout()));
    }

    private GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, @Nullable Bson bson, @Nullable Timeout timeout) {
        return new GridFSFindIterableImpl(this.createFindIterable(clientSession, bson, timeout));
    }

    @Override
    public void delete(ObjectId objectId) {
        this.delete(new BsonObjectId(objectId));
    }

    @Override
    public void delete(BsonValue bsonValue) {
        this.executeDelete(null, bsonValue);
    }

    @Override
    public void delete(ClientSession clientSession, ObjectId objectId) {
        this.delete(clientSession, new BsonObjectId(objectId));
    }

    @Override
    public void delete(ClientSession clientSession, BsonValue bsonValue) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDelete(clientSession, bsonValue);
    }

    private void executeDelete(@Nullable ClientSession clientSession, BsonValue bsonValue) {
        DeleteResult deleteResult;
        Timeout timeout = this.startTimeout();
        if (clientSession != null) {
            deleteResult = GridFSBucketImpl.withNullableTimeout(this.filesCollection, timeout).deleteOne(clientSession, new BsonDocument("_id", bsonValue));
            GridFSBucketImpl.withNullableTimeout(this.chunksCollection, timeout).deleteMany(clientSession, new BsonDocument("files_id", bsonValue));
        } else {
            deleteResult = GridFSBucketImpl.withNullableTimeout(this.filesCollection, timeout).deleteOne(new BsonDocument("_id", bsonValue));
            GridFSBucketImpl.withNullableTimeout(this.chunksCollection, timeout).deleteMany(new BsonDocument("files_id", bsonValue));
        }
        if (deleteResult.wasAcknowledged() && deleteResult.getDeletedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", bsonValue));
        }
    }

    @Override
    public void rename(ObjectId objectId, String string) {
        this.rename(new BsonObjectId(objectId), string);
    }

    @Override
    public void rename(BsonValue bsonValue, String string) {
        this.executeRename(null, bsonValue, string);
    }

    @Override
    public void rename(ClientSession clientSession, ObjectId objectId, String string) {
        this.rename(clientSession, new BsonObjectId(objectId), string);
    }

    @Override
    public void rename(ClientSession clientSession, BsonValue bsonValue, String string) {
        Assertions.notNull("clientSession", clientSession);
        this.executeRename(clientSession, bsonValue, string);
    }

    private void executeRename(@Nullable ClientSession clientSession, BsonValue bsonValue, String string) {
        Timeout timeout = this.startTimeout();
        UpdateResult updateResult = clientSession != null ? GridFSBucketImpl.withNullableTimeout(this.filesCollection, timeout).updateOne(clientSession, (Bson)new BsonDocument("_id", bsonValue), new BsonDocument("$set", new BsonDocument("filename", new BsonString(string)))) : GridFSBucketImpl.withNullableTimeout(this.filesCollection, timeout).updateOne((Bson)new BsonDocument("_id", bsonValue), new BsonDocument("$set", new BsonDocument("filename", new BsonString(string))));
        if (updateResult.wasAcknowledged() && updateResult.getMatchedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", bsonValue));
        }
    }

    @Override
    public void drop() {
        Timeout timeout = this.startTimeout();
        GridFSBucketImpl.withNullableTimeout(this.filesCollection, timeout).drop();
        GridFSBucketImpl.withNullableTimeout(this.chunksCollection, timeout).drop();
    }

    @Override
    public void drop(ClientSession clientSession) {
        Timeout timeout = this.startTimeout();
        Assertions.notNull("clientSession", clientSession);
        GridFSBucketImpl.withNullableTimeout(this.filesCollection, timeout).drop(clientSession);
        GridFSBucketImpl.withNullableTimeout(this.chunksCollection, timeout).drop(clientSession);
    }

    private static MongoCollection<GridFSFile> getFilesCollection(MongoDatabase mongoDatabase, String string) {
        return mongoDatabase.getCollection(string + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries(mongoDatabase.getCodecRegistry(), MongoClientSettings.getDefaultCodecRegistry()));
    }

    private static MongoCollection<BsonDocument> getChunksCollection(MongoDatabase mongoDatabase, String string) {
        return mongoDatabase.getCollection(string + ".chunks", BsonDocument.class).withCodecRegistry(MongoClientSettings.getDefaultCodecRegistry());
    }

    private void checkCreateIndex(@Nullable ClientSession clientSession, @Nullable Timeout timeout) {
        if (!this.checkedIndexes) {
            if (this.collectionIsEmpty(clientSession, this.filesCollection.withDocumentClass(Document.class).withReadPreference(ReadPreference.primary()), timeout)) {
                Document document = new Document("filename", 1).append("uploadDate", 1);
                if (!this.hasIndex(clientSession, this.filesCollection.withReadPreference(ReadPreference.primary()), document, timeout)) {
                    this.createIndex(clientSession, this.filesCollection, document, new IndexOptions(), timeout);
                }
                Document document2 = new Document("files_id", 1).append("n", 1);
                if (!this.hasIndex(clientSession, this.chunksCollection.withReadPreference(ReadPreference.primary()), document2, timeout)) {
                    this.createIndex(clientSession, this.chunksCollection, document2, new IndexOptions().unique(true), timeout);
                }
            }
            this.checkedIndexes = true;
        }
    }

    private <T> boolean collectionIsEmpty(@Nullable ClientSession clientSession, MongoCollection<T> mongoCollection, @Nullable Timeout timeout) {
        if (clientSession != null) {
            return GridFSBucketImpl.withNullableTimeout(mongoCollection, timeout).find(clientSession).projection(new Document("_id", 1)).first() == null;
        }
        return GridFSBucketImpl.withNullableTimeout(mongoCollection, timeout).find().projection(new Document("_id", 1)).first() == null;
    }

    private <T> boolean hasIndex(@Nullable ClientSession clientSession, MongoCollection<T> mongoCollection, Document document, @Nullable Timeout timeout) {
        boolean bl = false;
        ListIndexesIterable<Document> listIndexesIterable = clientSession != null ? GridFSBucketImpl.withNullableTimeout(mongoCollection, timeout).listIndexes(clientSession) : GridFSBucketImpl.withNullableTimeout(mongoCollection, timeout).listIndexes();
        ArrayList arrayList = listIndexesIterable.into(new ArrayList());
        for (Document document2 : arrayList) {
            Document document3 = document2.get((Object)"key", new Document());
            for (Map.Entry<String, Object> entry : document3.entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                entry.setValue(((Number)entry.getValue()).intValue());
            }
            if (!document3.equals(document)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private <T> void createIndex(@Nullable ClientSession clientSession, MongoCollection<T> mongoCollection, Document document, IndexOptions indexOptions, @Nullable Timeout timeout) {
        if (clientSession != null) {
            GridFSBucketImpl.withNullableTimeout(mongoCollection, timeout).createIndex(clientSession, document, indexOptions);
        } else {
            GridFSBucketImpl.withNullableTimeout(mongoCollection, timeout).createIndex(document, indexOptions);
        }
    }

    private GridFSFile getFileByName(@Nullable ClientSession clientSession, String string, GridFSDownloadOptions gridFSDownloadOptions, @Nullable Timeout timeout) {
        int n;
        int n2;
        int n3 = gridFSDownloadOptions.getRevision();
        if (n3 >= 0) {
            n2 = n3;
            n = 1;
        } else {
            n2 = -n3 - 1;
            n = -1;
        }
        GridFSFile gridFSFile = (GridFSFile)this.createGridFSFindIterable(clientSession, new Document("filename", string), timeout).skip(n2).sort(new Document("uploadDate", n)).first();
        if (gridFSFile == null) {
            throw new MongoGridFSException(String.format("No file found with the filename: %s and revision: %s", string, n3));
        }
        return gridFSFile;
    }

    private GridFSFile getFileInfoById(@Nullable ClientSession clientSession, BsonValue bsonValue, @Nullable Timeout timeout) {
        Assertions.notNull("id", bsonValue);
        GridFSFile gridFSFile = (GridFSFile)this.createFindIterable(clientSession, new Document("_id", bsonValue), timeout).first();
        if (gridFSFile == null) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", bsonValue));
        }
        return gridFSFile;
    }

    private FindIterable<GridFSFile> createFindIterable(@Nullable ClientSession clientSession, @Nullable Bson bson, @Nullable Timeout timeout) {
        FindIterable<GridFSFile> findIterable = clientSession != null ? GridFSBucketImpl.withNullableTimeout(this.filesCollection, timeout).find(clientSession) : GridFSBucketImpl.withNullableTimeout(this.filesCollection, timeout).find();
        if (bson != null) {
            findIterable = findIterable.filter(bson);
        }
        if (this.filesCollection.getTimeout(TimeUnit.MILLISECONDS) != null) {
            findIterable.timeoutMode(TimeoutMode.CURSOR_LIFETIME);
        }
        return findIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadToStream(GridFSDownloadStream gridFSDownloadStream, OutputStream outputStream) {
        block17: {
            byte[] byArray = new byte[gridFSDownloadStream.getGridFSFile().getChunkSize()];
            MongoGridFSException mongoGridFSException = null;
            try {
                int n;
                while ((n = gridFSDownloadStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (MongoOperationTimeoutException mongoOperationTimeoutException) {
                throw mongoOperationTimeoutException;
            }
            catch (IOException iOException) {
                mongoGridFSException = new MongoGridFSException("IOException when reading from the OutputStream", iOException);
            }
            catch (Exception exception) {
                mongoGridFSException = new MongoGridFSException("Unexpected Exception when reading GridFS and writing to the Stream", exception);
            }
            finally {
                try {
                    gridFSDownloadStream.close();
                }
                catch (Exception exception) {}
                if (mongoGridFSException == null) break block17;
                throw mongoGridFSException;
            }
        }
    }

    private static <T> MongoCollection<T> withNullableTimeout(MongoCollection<T> mongoCollection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(mongoCollection, TIMEOUT_MESSAGE, timeout);
    }

    @Nullable
    private Timeout startTimeout() {
        return TimeoutContext.startTimeout(this.filesCollection.getTimeout(TimeUnit.MILLISECONDS));
    }
}

