/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.internal.Locks;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;

class GridFSDownloadStreamImpl
extends GridFSDownloadStream {
    private static final String TIMEOUT_MESSAGE = "The GridFS download stream exceeded the timeout limit.";
    private final ClientSession clientSession;
    private final GridFSFile fileInfo;
    private final MongoCollection<BsonDocument> chunksCollection;
    private final BsonValue fileId;
    private final long length;
    private final int chunkSizeInBytes;
    private final int numberOfChunks;
    private MongoCursor<BsonDocument> cursor;
    private int batchSize;
    private int chunkIndex;
    private int bufferOffset;
    private long currentPosition;
    private byte[] buffer = null;
    private long markPosition;
    @Nullable
    private final Timeout timeout;
    private final ReentrantLock closeLock = new ReentrantLock();
    private final ReentrantLock cursorLock = new ReentrantLock();
    private boolean closed = false;

    GridFSDownloadStreamImpl(@Nullable ClientSession clientSession, GridFSFile gridFSFile, MongoCollection<BsonDocument> mongoCollection, @Nullable Timeout timeout) {
        this.clientSession = clientSession;
        this.fileInfo = Assertions.notNull("file information", gridFSFile);
        this.chunksCollection = Assertions.notNull("chunks collection", mongoCollection);
        this.fileId = gridFSFile.getId();
        this.length = gridFSFile.getLength();
        this.chunkSizeInBytes = gridFSFile.getChunkSize();
        this.numberOfChunks = (int)Math.ceil((double)this.length / (double)this.chunkSizeInBytes);
        this.timeout = timeout;
    }

    @Override
    public GridFSFile getGridFSFile() {
        return this.fileInfo;
    }

    @Override
    public GridFSDownloadStream batchSize(int n) {
        Assertions.isTrueArgument("batchSize cannot be negative", n >= 0);
        this.batchSize = n;
        this.discardCursor();
        return this;
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n < 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        this.checkClosed();
        this.checkTimeout();
        if (this.currentPosition == this.length) {
            return -1;
        }
        if (this.buffer == null) {
            this.buffer = this.getBuffer(this.chunkIndex);
        } else if (this.bufferOffset == this.buffer.length) {
            ++this.chunkIndex;
            this.buffer = this.getBuffer(this.chunkIndex);
            this.bufferOffset = 0;
        }
        int n3 = Math.min(n2, this.buffer.length - this.bufferOffset);
        System.arraycopy(this.buffer, this.bufferOffset, byArray, n, n3);
        this.bufferOffset += n3;
        this.currentPosition += (long)n3;
        return n3;
    }

    @Override
    public long skip(long l) {
        this.checkClosed();
        this.checkTimeout();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.currentPosition + l;
        this.bufferOffset = (int)(l2 % (long)this.chunkSizeInBytes);
        if (l2 >= this.length) {
            long l3 = this.length - this.currentPosition;
            this.chunkIndex = this.numberOfChunks - 1;
            this.currentPosition = this.length;
            this.buffer = null;
            this.discardCursor();
            return l3;
        }
        int n = (int)Math.floor((double)l2 / (double)this.chunkSizeInBytes);
        if (this.chunkIndex != n) {
            this.chunkIndex = n;
            this.buffer = null;
            this.discardCursor();
        }
        this.currentPosition += l;
        return l;
    }

    @Override
    public int available() {
        this.checkClosed();
        this.checkTimeout();
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length - this.bufferOffset;
    }

    @Override
    public void mark() {
        this.mark(Integer.MAX_VALUE);
    }

    @Override
    public void mark(int n) {
        this.markPosition = this.currentPosition;
    }

    @Override
    public void reset() {
        this.checkClosed();
        this.checkTimeout();
        if (this.currentPosition == this.markPosition) {
            return;
        }
        this.bufferOffset = (int)(this.markPosition % (long)this.chunkSizeInBytes);
        this.currentPosition = this.markPosition;
        int n = (int)Math.floor((double)this.markPosition / (double)this.chunkSizeInBytes);
        if (n != this.chunkIndex) {
            this.chunkIndex = n;
            this.buffer = null;
            this.discardCursor();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() {
        Locks.withInterruptibleLock((Lock)this.closeLock, () -> {
            if (!this.closed) {
                this.closed = true;
            }
            this.discardCursor();
        });
    }

    private void checkTimeout() {
        Timeout.onExistsAndExpired(this.timeout, () -> {
            throw TimeoutContext.createMongoTimeoutException(TIMEOUT_MESSAGE);
        });
    }

    private void checkClosed() {
        Locks.withInterruptibleLock((Lock)this.closeLock, () -> {
            if (this.closed) {
                throw new MongoGridFSException("The InputStream has been closed");
            }
        });
    }

    private void discardCursor() {
        Locks.withInterruptibleLock((Lock)this.cursorLock, () -> {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        });
    }

    @Nullable
    private BsonDocument getChunk(int n) {
        if (this.cursor == null) {
            this.cursor = this.getCursor(n);
        }
        BsonDocument bsonDocument = null;
        if (this.cursor.hasNext()) {
            bsonDocument = this.cursor.next();
            if (this.batchSize == 1) {
                this.discardCursor();
            }
            if (bsonDocument.getInt32("n").getValue() != n) {
                throw new MongoGridFSException(String.format("Could not find file chunk for file_id: %s at chunk index %s.", this.fileId, n));
            }
        }
        return bsonDocument;
    }

    private MongoCursor<BsonDocument> getCursor(int n) {
        BsonDocument bsonDocument = new BsonDocument("files_id", this.fileId).append("n", new BsonDocument("$gte", new BsonInt32(n)));
        FindIterable<BsonDocument> findIterable = this.clientSession != null ? this.withNullableTimeout(this.chunksCollection, this.timeout).find(this.clientSession, bsonDocument) : this.withNullableTimeout(this.chunksCollection, this.timeout).find(bsonDocument);
        if (this.timeout != null) {
            findIterable.timeoutMode(TimeoutMode.CURSOR_LIFETIME);
        }
        return findIterable.batchSize(this.batchSize).sort(new BsonDocument("n", new BsonInt32(1))).iterator();
    }

    private byte[] getBufferFromChunk(@Nullable BsonDocument bsonDocument, int n) {
        if (bsonDocument == null || bsonDocument.getInt32("n").getValue() != n) {
            throw new MongoGridFSException(String.format("Could not find file chunk for file_id: %s at chunk index %s.", this.fileId, n));
        }
        if (!(bsonDocument.get("data") instanceof BsonBinary)) {
            throw new MongoGridFSException("Unexpected data format for the chunk");
        }
        byte[] byArray = bsonDocument.getBinary("data").getData();
        long l = 0L;
        boolean bl = false;
        if (n + 1 > this.numberOfChunks) {
            bl = true;
        } else {
            l = n + 1 == this.numberOfChunks ? this.length - (long)n * (long)this.chunkSizeInBytes : (long)this.chunkSizeInBytes;
        }
        if (bl && (long)byArray.length > l) {
            throw new MongoGridFSException(String.format("Extra chunk data for file_id: %s. Unexpected chunk at chunk index %s.The size was %s and it should be %s bytes.", this.fileId, n, byArray.length, l));
        }
        if ((long)byArray.length != l) {
            throw new MongoGridFSException(String.format("Chunk size data length is not the expected size. The size was %s for file_id: %s chunk index %s it should be %s bytes.", byArray.length, this.fileId, n, l));
        }
        return byArray;
    }

    private byte[] getBuffer(int n) {
        return this.getBufferFromChunk(this.getChunk(n), n);
    }

    private <T> MongoCollection<T> withNullableTimeout(MongoCollection<T> mongoCollection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(mongoCollection, TIMEOUT_MESSAGE, timeout);
    }
}

