/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.gridfs.GridFSUploadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.internal.Locks;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.types.ObjectId;

final class GridFSUploadStreamImpl
extends GridFSUploadStream {
    public static final String TIMEOUT_MESSAGE = "The GridFS upload stream exceeded the timeout limit.";
    private final ClientSession clientSession;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<BsonDocument> chunksCollection;
    private final BsonValue fileId;
    private final String filename;
    private final int chunkSizeBytes;
    private final Document metadata;
    private byte[] buffer;
    private long lengthInBytes;
    private int bufferOffset;
    private int chunkIndex;
    @Nullable
    private final Timeout timeout;
    private final ReentrantLock closeLock = new ReentrantLock();
    private boolean closed = false;

    GridFSUploadStreamImpl(@Nullable ClientSession clientSession, MongoCollection<GridFSFile> mongoCollection, MongoCollection<BsonDocument> mongoCollection2, BsonValue bsonValue, String string, int n, @Nullable Document document, @Nullable Timeout timeout) {
        this.clientSession = clientSession;
        this.filesCollection = Assertions.notNull("files collection", mongoCollection);
        this.chunksCollection = Assertions.notNull("chunks collection", mongoCollection2);
        this.fileId = Assertions.notNull("File Id", bsonValue);
        this.filename = Assertions.notNull("filename", string);
        this.chunkSizeBytes = n;
        this.metadata = document;
        this.chunkIndex = 0;
        this.bufferOffset = 0;
        this.buffer = new byte[n];
        this.timeout = timeout;
    }

    @Override
    public ObjectId getObjectId() {
        if (!this.fileId.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS upload stream");
        }
        return this.fileId.asObjectId().getValue();
    }

    @Override
    public BsonValue getId() {
        return this.fileId;
    }

    @Override
    public void abort() {
        Locks.withInterruptibleLock((Lock)this.closeLock, () -> {
            this.checkClosed();
            this.closed = true;
        });
        if (this.clientSession != null) {
            GridFSUploadStreamImpl.withNullableTimeout(this.chunksCollection, this.timeout).deleteMany(this.clientSession, new Document("files_id", this.fileId));
        } else {
            GridFSUploadStreamImpl.withNullableTimeout(this.chunksCollection, this.timeout).deleteMany(new Document("files_id", this.fileId));
        }
    }

    @Override
    public void write(int n) {
        byte[] byArray = new byte[]{(byte)(0xFF & n)};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.checkClosed();
        this.checkTimeout();
        Assertions.notNull("b", byArray);
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        while (n4 > 0) {
            n5 = n4;
            if (n5 > this.chunkSizeBytes - this.bufferOffset) {
                n5 = this.chunkSizeBytes - this.bufferOffset;
            }
            System.arraycopy(byArray, n3, this.buffer, this.bufferOffset, n5);
            this.bufferOffset += n5;
            n3 += n5;
            n4 -= n5;
            this.lengthInBytes += (long)n5;
            if (this.bufferOffset != this.chunkSizeBytes) continue;
            this.writeChunk();
        }
    }

    private void checkTimeout() {
        Timeout.onExistsAndExpired(this.timeout, () -> TimeoutContext.throwMongoTimeoutException(TIMEOUT_MESSAGE));
    }

    @Override
    public void close() {
        boolean bl = Locks.withInterruptibleLock((Lock)this.closeLock, () -> {
            boolean bl = this.closed;
            this.closed = true;
            return bl;
        });
        if (bl) {
            return;
        }
        this.writeChunk();
        GridFSFile gridFSFile = new GridFSFile(this.fileId, this.filename, this.lengthInBytes, this.chunkSizeBytes, new Date(), this.metadata);
        if (this.clientSession != null) {
            GridFSUploadStreamImpl.withNullableTimeout(this.filesCollection, this.timeout).insertOne(this.clientSession, gridFSFile);
        } else {
            GridFSUploadStreamImpl.withNullableTimeout(this.filesCollection, this.timeout).insertOne(gridFSFile);
        }
        this.buffer = null;
    }

    private void writeChunk() {
        if (this.bufferOffset > 0) {
            if (this.clientSession != null) {
                GridFSUploadStreamImpl.withNullableTimeout(this.chunksCollection, this.timeout).insertOne(this.clientSession, new BsonDocument("files_id", this.fileId).append("n", new BsonInt32(this.chunkIndex)).append("data", this.getData()));
            } else {
                GridFSUploadStreamImpl.withNullableTimeout(this.chunksCollection, this.timeout).insertOne(new BsonDocument("files_id", this.fileId).append("n", new BsonInt32(this.chunkIndex)).append("data", this.getData()));
            }
            ++this.chunkIndex;
            this.bufferOffset = 0;
        }
    }

    private BsonBinary getData() {
        if (this.bufferOffset < this.chunkSizeBytes) {
            byte[] byArray = new byte[this.bufferOffset];
            System.arraycopy(this.buffer, 0, byArray, 0, this.bufferOffset);
            this.buffer = byArray;
        }
        return new BsonBinary(this.buffer);
    }

    private void checkClosed() {
        Locks.withInterruptibleLock((Lock)this.closeLock, () -> {
            if (this.closed) {
                throw new MongoGridFSException("The OutputStream has been closed");
            }
        });
    }

    private static <T> MongoCollection<T> withNullableTimeout(MongoCollection<T> mongoCollection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(mongoCollection, TIMEOUT_MESSAGE, timeout);
    }
}

