/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs.codecs;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.lang.Nullable;
import java.util.Date;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public final class GridFSFileCodec
implements Codec<GridFSFile> {
    private final Codec<Document> documentCodec;
    private final Codec<BsonDocument> bsonDocumentCodec;

    public GridFSFileCodec(CodecRegistry codecRegistry) {
        this.documentCodec = Assertions.notNull("DocumentCodec", Assertions.notNull("registry", codecRegistry).get(Document.class));
        this.bsonDocumentCodec = Assertions.notNull("BsonDocumentCodec", codecRegistry.get(BsonDocument.class));
    }

    @Override
    public GridFSFile decode(BsonReader bsonReader, DecoderContext decoderContext) {
        BsonDocument bsonDocument = (BsonDocument)this.bsonDocumentCodec.decode(bsonReader, decoderContext);
        BsonValue bsonValue = bsonDocument.get("_id");
        String string = bsonDocument.get("filename", new BsonString("")).asString().getValue();
        long l = bsonDocument.getNumber("length").longValue();
        int n = bsonDocument.getNumber("chunkSize").intValue();
        Date date = new Date(bsonDocument.getDateTime("uploadDate").getValue());
        BsonDocument bsonDocument2 = bsonDocument.getDocument("metadata", new BsonDocument());
        Document document = this.asDocumentOrNull(bsonDocument2);
        return new GridFSFile(bsonValue, string, l, n, date, document);
    }

    @Override
    public void encode(BsonWriter bsonWriter, GridFSFile gridFSFile, EncoderContext encoderContext) {
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("_id", gridFSFile.getId());
        bsonDocument.put("filename", new BsonString(gridFSFile.getFilename()));
        bsonDocument.put("length", new BsonInt64(gridFSFile.getLength()));
        bsonDocument.put("chunkSize", new BsonInt32(gridFSFile.getChunkSize()));
        bsonDocument.put("uploadDate", new BsonDateTime(gridFSFile.getUploadDate().getTime()));
        Document document = gridFSFile.getMetadata();
        if (document != null) {
            bsonDocument.put("metadata", new BsonDocumentWrapper<Document>(document, this.documentCodec));
        }
        this.bsonDocumentCodec.encode(bsonWriter, bsonDocument, encoderContext);
    }

    @Override
    public Class<GridFSFile> getEncoderClass() {
        return GridFSFile.class;
    }

    @Nullable
    private Document asDocumentOrNull(BsonDocument bsonDocument) {
        if (bsonDocument.isEmpty()) {
            return null;
        }
        BsonDocumentReader bsonDocumentReader = new BsonDocumentReader(bsonDocument);
        return (Document)this.documentCodec.decode(bsonDocumentReader, DecoderContext.builder().build());
    }
}

