/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs.model;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Date;
import java.util.Objects;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.types.ObjectId;

public final class GridFSFile {
    private final BsonValue id;
    private final String filename;
    private final long length;
    private final int chunkSize;
    private final Date uploadDate;
    private final Document metadata;

    public GridFSFile(BsonValue bsonValue, String string, long l, int n, Date date, @Nullable Document document) {
        this.id = Assertions.notNull("id", bsonValue);
        this.filename = Assertions.notNull("filename", string);
        this.length = Assertions.notNull("length", l);
        this.chunkSize = Assertions.notNull("chunkSize", n);
        this.uploadDate = Assertions.notNull("uploadDate", date);
        this.metadata = document != null && document.isEmpty() ? null : document;
    }

    public ObjectId getObjectId() {
        if (!this.id.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS file");
        }
        return this.id.asObjectId().getValue();
    }

    public BsonValue getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getLength() {
        return this.length;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    @Nullable
    public Document getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GridFSFile gridFSFile = (GridFSFile)object;
        if (!Objects.equals(this.id, gridFSFile.id)) {
            return false;
        }
        if (!this.filename.equals(gridFSFile.filename)) {
            return false;
        }
        if (this.length != gridFSFile.length) {
            return false;
        }
        if (this.chunkSize != gridFSFile.chunkSize) {
            return false;
        }
        if (!this.uploadDate.equals(gridFSFile.uploadDate)) {
            return false;
        }
        return Objects.equals(this.metadata, gridFSFile.metadata);
    }

    public int hashCode() {
        int n = this.id != null ? this.id.hashCode() : 0;
        n = 31 * n + this.filename.hashCode();
        n = 31 * n + (int)(this.length ^ this.length >>> 32);
        n = 31 * n + this.chunkSize;
        n = 31 * n + this.uploadDate.hashCode();
        n = 31 * n + (this.metadata != null ? this.metadata.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "GridFSFile{id=" + this.id + ", filename='" + this.filename + '\'' + ", length=" + this.length + ", chunkSize=" + this.chunkSize + ", uploadDate=" + this.uploadDate + ", metadata=" + this.metadata + '}';
    }
}

