/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AggregateIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements AggregateIterable<TResult> {
    private final SyncOperations<TDocument> operations;
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private BsonValue comment;
    private Bson hint;
    private String hintString;
    private Bson variables;

    AggregateIterableImpl(@Nullable ClientSession clientSession, String string, Class<TDocument> clazz, Class<TResult> clazz2, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor operationExecutor, List<? extends Bson> list, AggregationLevel aggregationLevel, boolean bl, TimeoutSettings timeoutSettings) {
        this(clientSession, new MongoNamespace(string, "ignored"), clazz, clazz2, codecRegistry, readPreference, readConcern, writeConcern, operationExecutor, list, aggregationLevel, bl, timeoutSettings);
    }

    AggregateIterableImpl(@Nullable ClientSession clientSession, MongoNamespace mongoNamespace, Class<TDocument> clazz, Class<TResult> clazz2, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor operationExecutor, List<? extends Bson> list, AggregationLevel aggregationLevel, boolean bl, TimeoutSettings timeoutSettings) {
        super(clientSession, operationExecutor, readConcern, readPreference, bl, timeoutSettings);
        this.operations = new SyncOperations<TDocument>(mongoNamespace, clazz, readPreference, codecRegistry, readConcern, writeConcern, true, bl, timeoutSettings);
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.documentClass = Assertions.notNull("documentClass", clazz);
        this.resultClass = Assertions.notNull("resultClass", clazz2);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.pipeline = Assertions.notNull("pipeline", list);
        this.aggregationLevel = Assertions.notNull("aggregationLevel", aggregationLevel);
    }

    @Override
    public void toCollection() {
        BsonDocument bsonDocument = this.getLastPipelineStage();
        if (bsonDocument == null || !bsonDocument.containsKey("$out") && !bsonDocument.containsKey("$merge")) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out or $merge");
        }
        this.getExecutor().execute(this.operations.aggregateToCollection(this.pipeline, this.getTimeoutMode(), this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.hintString, this.comment, this.variables, this.aggregationLevel), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    @Override
    public AggregateIterable<TResult> allowDiskUse(@Nullable Boolean bl) {
        this.allowDiskUse = bl;
        return this;
    }

    @Override
    public AggregateIterable<TResult> batchSize(int n) {
        super.batchSize(n);
        return this;
    }

    @Override
    public AggregateIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxAwaitTime(long l, TimeUnit timeUnit) {
        this.maxAwaitTimeMS = this.validateMaxAwaitTime(l, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    @Override
    public AggregateIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> comment(@Nullable String string) {
        this.comment = string == null ? null : new BsonString(string);
        return this;
    }

    @Override
    public AggregateIterable<TResult> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Override
    public AggregateIterable<TResult> hint(@Nullable Bson bson) {
        this.hint = bson;
        return this;
    }

    @Override
    public AggregateIterable<TResult> hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    @Override
    public AggregateIterable<TResult> let(@Nullable Bson bson) {
        this.variables = bson;
        return this;
    }

    @Override
    public Document explain() {
        return this.executeExplain(Document.class, null);
    }

    @Override
    public Document explain(ExplainVerbosity explainVerbosity) {
        return this.executeExplain(Document.class, Assertions.notNull("verbosity", explainVerbosity));
    }

    @Override
    public <E> E explain(Class<E> clazz) {
        return this.executeExplain(clazz, null);
    }

    @Override
    public <E> E explain(Class<E> clazz, ExplainVerbosity explainVerbosity) {
        return this.executeExplain(clazz, Assertions.notNull("verbosity", explainVerbosity));
    }

    private <E> E executeExplain(Class<E> clazz, @Nullable ExplainVerbosity explainVerbosity) {
        Assertions.notNull("explainDocumentClass", clazz);
        return this.getExecutor().execute(this.asAggregateOperation().asExplainableOperation(explainVerbosity, this.codecRegistry.get(clazz)), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        MongoNamespace mongoNamespace = this.getOutNamespace();
        if (mongoNamespace != null) {
            this.validateTimeoutMode();
            this.getExecutor().execute(this.operations.aggregateToCollection(this.pipeline, this.getTimeoutMode(), this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.hintString, this.comment, this.variables, this.aggregationLevel), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
            FindOptions findOptions = new FindOptions().collation(this.collation);
            Integer n = this.getBatchSize();
            if (n != null) {
                findOptions.batchSize(n);
            }
            return this.operations.find(mongoNamespace, new BsonDocument(), this.resultClass, findOptions);
        }
        return this.asAggregateOperation();
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS, this.maxAwaitTimeMS));
    }

    private ExplainableReadOperation<BatchCursor<TResult>> asAggregateOperation() {
        return this.operations.aggregate(this.pipeline, this.resultClass, this.getTimeoutMode(), this.getBatchSize(), this.collation, this.hint, this.hintString, this.comment, this.variables, this.allowDiskUse, this.aggregationLevel);
    }

    @Nullable
    private BsonDocument getLastPipelineStage() {
        if (this.pipeline.isEmpty()) {
            return null;
        }
        Bson bson = Assertions.notNull("last pipeline stage", this.pipeline.get(this.pipeline.size() - 1));
        return bson.toBsonDocument(this.documentClass, this.codecRegistry);
    }

    @Nullable
    private MongoNamespace getOutNamespace() {
        BsonDocument bsonDocument = this.getLastPipelineStage();
        if (bsonDocument == null) {
            return null;
        }
        if (bsonDocument.containsKey("$out")) {
            if (bsonDocument.get("$out").isString()) {
                return new MongoNamespace(this.namespace.getDatabaseName(), bsonDocument.getString("$out").getValue());
            }
            if (bsonDocument.get("$out").isDocument()) {
                BsonDocument bsonDocument2 = bsonDocument.getDocument("$out");
                if (!bsonDocument2.containsKey("db") || !bsonDocument2.containsKey("coll")) {
                    throw new IllegalStateException("Cannot return a cursor when the value for $out stage is not a namespace document");
                }
                return new MongoNamespace(bsonDocument2.getString("db").getValue(), bsonDocument2.getString("coll").getValue());
            }
            throw new IllegalStateException("Cannot return a cursor when the value for $out stage is not a string or namespace document");
        }
        if (bsonDocument.containsKey("$merge")) {
            if (bsonDocument.isString("$merge")) {
                return new MongoNamespace(this.namespace.getDatabaseName(), bsonDocument.getString("$merge").getValue());
            }
            if (bsonDocument.isDocument("$merge")) {
                BsonDocument bsonDocument3 = bsonDocument.getDocument("$merge");
                if (bsonDocument3.isDocument("into")) {
                    BsonDocument bsonDocument4 = bsonDocument3.getDocument("into");
                    return new MongoNamespace(bsonDocument4.getString("db", new BsonString(this.namespace.getDatabaseName())).getValue(), bsonDocument4.getString("coll").getValue());
                }
                if (bsonDocument3.isString("into")) {
                    return new MongoNamespace(this.namespace.getDatabaseName(), bsonDocument3.getString("into").getValue());
                }
            } else {
                throw new IllegalStateException("Cannot return a cursor when the value for $merge stage is not a string or a document");
            }
        }
        return null;
    }

    private void validateTimeoutMode() {
        if (this.getTimeoutMode() == TimeoutMode.ITERATION) {
            throw new IllegalArgumentException("Aggregations that output to a collection do not support the ITERATION value for the timeoutMode option.");
        }
    }
}

