/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.MongoChangeStreamCursorImpl;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class ChangeStreamIterableImpl<TResult>
extends MongoIterableImpl<ChangeStreamDocument<TResult>>
implements ChangeStreamIterable<TResult> {
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private final Codec<ChangeStreamDocument<TResult>> codec;
    private final ChangeStreamLevel changeStreamLevel;
    private final SyncOperations<TResult> operations;
    private FullDocument fullDocument = FullDocument.DEFAULT;
    private FullDocumentBeforeChange fullDocumentBeforeChange = FullDocumentBeforeChange.DEFAULT;
    private BsonDocument resumeToken;
    private BsonDocument startAfter;
    private long maxAwaitTimeMS;
    private Collation collation;
    private BsonTimestamp startAtOperationTime;
    private BsonValue comment;
    private boolean showExpandedEvents;

    public ChangeStreamIterableImpl(@Nullable ClientSession clientSession, String string, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor operationExecutor, List<? extends Bson> list, Class<TResult> clazz, ChangeStreamLevel changeStreamLevel, boolean bl, TimeoutSettings timeoutSettings) {
        this(clientSession, new MongoNamespace(string, "ignored"), codecRegistry, readPreference, readConcern, operationExecutor, list, clazz, changeStreamLevel, bl, timeoutSettings);
    }

    public ChangeStreamIterableImpl(@Nullable ClientSession clientSession, MongoNamespace mongoNamespace, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor operationExecutor, List<? extends Bson> list, Class<TResult> clazz, ChangeStreamLevel changeStreamLevel, boolean bl, TimeoutSettings timeoutSettings) {
        super(clientSession, operationExecutor, readConcern, readPreference, bl, timeoutSettings);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.pipeline = Assertions.notNull("pipeline", list);
        this.codec = ChangeStreamDocument.createCodec(Assertions.notNull("resultClass", clazz), codecRegistry);
        this.changeStreamLevel = Assertions.notNull("changeStreamLevel", changeStreamLevel);
        this.operations = new SyncOperations<TResult>(mongoNamespace, clazz, readPreference, codecRegistry, bl, timeoutSettings);
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocument(FullDocument fullDocument) {
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocumentBeforeChange(FullDocumentBeforeChange fullDocumentBeforeChange) {
        this.fullDocumentBeforeChange = Assertions.notNull("fullDocumentBeforeChange", fullDocumentBeforeChange);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> resumeAfter(BsonDocument bsonDocument) {
        this.resumeToken = Assertions.notNull("resumeAfter", bsonDocument);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> batchSize(int n) {
        super.batchSize(n);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> maxAwaitTime(long l, TimeUnit timeUnit) {
        this.maxAwaitTimeMS = this.validateMaxAwaitTime(l, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = Assertions.notNull("collation", collation);
        return this;
    }

    @Override
    public <TDocument> MongoIterable<TDocument> withDocumentClass(final Class<TDocument> clazz) {
        return new MongoIterableImpl<TDocument>(this.getClientSession(), this.getExecutor(), this.getReadConcern(), this.getReadPreference(), this.getRetryReads(), this.getTimeoutSettings()){

            @Override
            public MongoCursor<TDocument> iterator() {
                return this.cursor();
            }

            @Override
            public MongoChangeStreamCursor<TDocument> cursor() {
                return new MongoChangeStreamCursorImpl(ChangeStreamIterableImpl.this.execute(), ChangeStreamIterableImpl.this.codecRegistry.get(clazz), ChangeStreamIterableImpl.this.initialResumeToken());
            }

            @Override
            public ReadOperation<BatchCursor<TDocument>> asReadOperation() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected OperationExecutor getExecutor() {
                return ChangeStreamIterableImpl.this.getExecutor();
            }
        };
    }

    @Override
    public ChangeStreamIterable<TResult> startAtOperationTime(BsonTimestamp bsonTimestamp) {
        this.startAtOperationTime = Assertions.notNull("startAtOperationTime", bsonTimestamp);
        return this;
    }

    @Override
    public ChangeStreamIterableImpl<TResult> startAfter(BsonDocument bsonDocument) {
        this.startAfter = Assertions.notNull("startAfter", bsonDocument);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> comment(@Nullable String string) {
        this.comment = string == null ? null : new BsonString(string);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> showExpandedEvents(boolean bl) {
        this.showExpandedEvents = bl;
        return this;
    }

    @Override
    public MongoCursor<ChangeStreamDocument<TResult>> iterator() {
        return this.cursor();
    }

    @Override
    public MongoChangeStreamCursor<ChangeStreamDocument<TResult>> cursor() {
        return new MongoChangeStreamCursorImpl<ChangeStreamDocument<TResult>>(this.execute(), this.codec, this.initialResumeToken());
    }

    @Override
    @Nullable
    public ChangeStreamDocument<TResult> first() {
        try (MongoCursor mongoCursor = this.cursor();){
            if (!mongoCursor.hasNext()) {
                ChangeStreamDocument<TResult> changeStreamDocument = null;
                return changeStreamDocument;
            }
            ChangeStreamDocument changeStreamDocument = (ChangeStreamDocument)mongoCursor.next();
            return changeStreamDocument;
        }
    }

    @Override
    public ReadOperation<BatchCursor<ChangeStreamDocument<TResult>>> asReadOperation() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(0L, this.maxAwaitTimeMS));
    }

    private ReadOperation<BatchCursor<RawBsonDocument>> createChangeStreamOperation() {
        return this.operations.changeStream(this.fullDocument, this.fullDocumentBeforeChange, this.pipeline, new RawBsonDocumentCodec(), this.changeStreamLevel, this.getBatchSize(), this.collation, this.comment, this.resumeToken, this.startAtOperationTime, this.startAfter, this.showExpandedEvents);
    }

    private BatchCursor<RawBsonDocument> execute() {
        return this.getExecutor().execute(this.createChangeStreamOperation(), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    private BsonDocument initialResumeToken() {
        return this.startAfter != null ? this.startAfter : this.resumeToken;
    }
}

