/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoConfigurationException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoUpdatedEncryptedFieldsException;
import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.Crypts;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateEncryptedCollectionParams;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.Updates;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyResult;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.vault.ClientEncryption;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.internal.BsonUtil;

public class ClientEncryptionImpl
implements ClientEncryption {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;
    private final MongoCollection<BsonDocument> collection;

    public ClientEncryptionImpl(ClientEncryptionSettings clientEncryptionSettings) {
        this(MongoClients.create(clientEncryptionSettings.getKeyVaultMongoClientSettings()), clientEncryptionSettings);
    }

    public ClientEncryptionImpl(MongoClient mongoClient, ClientEncryptionSettings clientEncryptionSettings) {
        this.keyVaultClient = mongoClient;
        this.crypt = Crypts.create(mongoClient, clientEncryptionSettings);
        this.options = clientEncryptionSettings;
        MongoNamespace mongoNamespace = new MongoNamespace(clientEncryptionSettings.getKeyVaultNamespace());
        this.collection = ClientEncryptionImpl.getVaultCollection(mongoClient, clientEncryptionSettings, mongoNamespace);
    }

    private static MongoCollection<BsonDocument> getVaultCollection(MongoClient mongoClient, ClientEncryptionSettings clientEncryptionSettings, MongoNamespace mongoNamespace) {
        MongoCollection<BsonDocument> mongoCollection = mongoClient.getDatabase(mongoNamespace.getDatabaseName()).getCollection(mongoNamespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).withReadConcern(ReadConcern.MAJORITY);
        Long l = clientEncryptionSettings.getTimeout(TimeUnit.MILLISECONDS);
        if (l != null) {
            mongoCollection = mongoCollection.withTimeout(l, TimeUnit.MILLISECONDS);
        }
        return mongoCollection;
    }

    @Override
    public BsonBinary createDataKey(String string) {
        return this.createDataKey(string, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String string, DataKeyOptions dataKeyOptions) {
        Timeout timeout = this.startTimeout();
        return this.createDataKey(string, dataKeyOptions, timeout);
    }

    public BsonBinary createDataKey(String string, DataKeyOptions dataKeyOptions, @Nullable Timeout timeout) {
        BsonDocument bsonDocument = this.crypt.createDataKey(string, dataKeyOptions, timeout);
        TimeoutHelper.collectionWithTimeout(this.collection, "Data key insertion exceeded the timeout limit.", timeout).insertOne(bsonDocument);
        return bsonDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue bsonValue, EncryptOptions encryptOptions) {
        Timeout timeout = this.startTimeout();
        return this.crypt.encryptExplicitly(bsonValue, encryptOptions, timeout);
    }

    @Override
    public BsonDocument encryptExpression(Bson bson, EncryptOptions encryptOptions) {
        Timeout timeout = this.startTimeout();
        return this.crypt.encryptExpression(bson.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), encryptOptions, timeout);
    }

    @Override
    public BsonValue decrypt(BsonBinary bsonBinary) {
        Timeout timeout = this.startTimeout();
        return this.crypt.decryptExplicitly(bsonBinary, timeout);
    }

    @Override
    public DeleteResult deleteKey(BsonBinary bsonBinary) {
        return TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).deleteOne(Filters.eq("_id", bsonBinary));
    }

    @Override
    public BsonDocument getKey(BsonBinary bsonBinary) {
        return (BsonDocument)TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).find(Filters.eq("_id", bsonBinary)).first();
    }

    @Override
    public FindIterable<BsonDocument> getKeys() {
        return TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).find();
    }

    @Override
    public BsonDocument addKeyAltName(BsonBinary bsonBinary, String string) {
        return this.collection.findOneAndUpdate(Filters.eq("_id", bsonBinary), Updates.addToSet("keyAltNames", string));
    }

    @Override
    public BsonDocument removeKeyAltName(BsonBinary bsonBinary, String string) {
        BsonDocument bsonDocument = new BsonDocument().append("$set", new BsonDocument().append("keyAltNames", new BsonDocument().append("$cond", new BsonArray(Arrays.asList(new BsonDocument().append("$eq", new BsonArray(Arrays.asList(new BsonString("$keyAltNames"), new BsonArray(Collections.singletonList(new BsonString(string)))))), new BsonString("$$REMOVE"), new BsonDocument().append("$filter", new BsonDocument().append("input", new BsonString("$keyAltNames")).append("cond", new BsonDocument().append("$ne", new BsonArray(Arrays.asList(new BsonString("$$this"), new BsonString(string)))))))))));
        return this.collection.findOneAndUpdate(Filters.eq("_id", bsonBinary), Collections.singletonList(bsonDocument));
    }

    @Override
    public BsonDocument getKeyByAltName(String string) {
        return (BsonDocument)this.collection.find(Filters.eq("keyAltNames", string)).first();
    }

    @Override
    public RewrapManyDataKeyResult rewrapManyDataKey(Bson bson) {
        return this.rewrapManyDataKey(bson, new RewrapManyDataKeyOptions());
    }

    @Override
    public RewrapManyDataKeyResult rewrapManyDataKey(Bson bson, RewrapManyDataKeyOptions rewrapManyDataKeyOptions) {
        MongoCryptHelper.validateRewrapManyDataKeyOptions(rewrapManyDataKeyOptions);
        Timeout timeout = this.startTimeout();
        BsonDocument bsonDocument = this.crypt.rewrapManyDataKey(bson.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), rewrapManyDataKeyOptions, timeout);
        if (bsonDocument.isEmpty()) {
            return new RewrapManyDataKeyResult();
        }
        List list = bsonDocument.getArray("v", new BsonArray()).stream().map(bsonValue -> {
            BsonDocument bsonDocument = bsonValue.asDocument();
            return new UpdateOneModel(Filters.eq(bsonDocument.get("_id")), Updates.combine(Updates.set("masterKey", bsonDocument.get("masterKey")), Updates.set("keyMaterial", bsonDocument.get("keyMaterial")), Updates.currentDate("updateDate")));
        }).collect(Collectors.toList());
        BulkWriteResult bulkWriteResult = TimeoutHelper.collectionWithTimeout(this.collection, timeout).bulkWrite(list);
        return new RewrapManyDataKeyResult(bulkWriteResult);
    }

    @Override
    public BsonDocument createEncryptedCollection(MongoDatabase mongoDatabase, String string, CreateCollectionOptions createCollectionOptions, CreateEncryptedCollectionParams createEncryptedCollectionParams) {
        Assertions.notNull("collectionName", string);
        Assertions.notNull("createCollectionOptions", createCollectionOptions);
        Assertions.notNull("createEncryptedCollectionParams", createEncryptedCollectionParams);
        Timeout timeout = this.startTimeout();
        MongoNamespace mongoNamespace = new MongoNamespace(mongoDatabase.getName(), string);
        Bson bson = createCollectionOptions.getEncryptedFields();
        if (bson == null) {
            throw new MongoConfigurationException(String.format("`encryptedFields` is not configured for the collection %s.", mongoNamespace));
        }
        CodecRegistry codecRegistry = this.options.getKeyVaultMongoClientSettings().getCodecRegistry();
        BsonDocument bsonDocument2 = bson.toBsonDocument(BsonDocument.class, codecRegistry);
        BsonValue bsonValue = bsonDocument2.get("fields");
        if (bsonValue != null && bsonValue.isArray()) {
            String string2 = createEncryptedCollectionParams.getKmsProvider();
            DataKeyOptions dataKeyOptions = new DataKeyOptions();
            BsonDocument bsonDocument3 = createEncryptedCollectionParams.getMasterKey();
            if (bsonDocument3 != null) {
                dataKeyOptions.masterKey(bsonDocument3);
            }
            String string3 = "keyId";
            BsonDocument bsonDocument4 = BsonUtil.mutableDeepCopy(bsonDocument2);
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            try {
                bsonDocument4.get("fields").asArray().stream().filter(BsonValue::isDocument).map(BsonValue::asDocument).filter(bsonDocument -> bsonDocument.containsKey(string3)).filter(bsonDocument -> Objects.equals(bsonDocument.get(string3), BsonNull.VALUE)).forEachOrdered(bsonDocument -> {
                    atomicBoolean.set(true);
                    BsonBinary bsonBinary = this.createDataKey(string2, dataKeyOptions, timeout);
                    bsonDocument.put(string3, bsonBinary);
                });
                TimeoutHelper.databaseWithTimeout(mongoDatabase, timeout).createCollection(string, new CreateCollectionOptions(createCollectionOptions).encryptedFields(bsonDocument4));
                return bsonDocument4;
            }
            catch (Exception exception) {
                if (atomicBoolean.get()) {
                    throw new MongoUpdatedEncryptedFieldsException(bsonDocument4, String.format("Failed to create %s.", mongoNamespace), (Throwable)exception);
                }
                throw exception;
            }
        }
        TimeoutHelper.databaseWithTimeout(mongoDatabase, timeout).createCollection(string, createCollectionOptions);
        return bsonDocument2;
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }

    @Nullable
    private Timeout startTimeout() {
        return TimeoutContext.startTimeout(this.options.getTimeout(TimeUnit.MILLISECONDS));
    }
}

