/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.client.ClientSession;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.TransactionContext;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.session.ClientSessionContext;
import java.util.function.Supplier;
import org.bson.assertions.Assertions;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final OperationContext operationContext;

    public ClientSessionBinding(ClientSession clientSession, boolean bl, ClusterAwareReadWriteBinding clusterAwareReadWriteBinding) {
        this.wrapped = clusterAwareReadWriteBinding;
        clusterAwareReadWriteBinding.retain();
        this.session = Assertions.notNull("session", clientSession);
        this.ownsSession = bl;
        this.operationContext = clusterAwareReadWriteBinding.getOperationContext().withSessionContext(new SyncClientSessionContext(clientSession));
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ClientSessionBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int n = super.release();
        if (n == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return n;
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new SessionBindingConnectionSource(this.getConnectionSource(this.wrapped::getReadConnectionSource));
    }

    @Override
    public ConnectionSource getReadConnectionSource(int n, ReadPreference readPreference) {
        return new SessionBindingConnectionSource(this.getConnectionSource(() -> this.wrapped.getReadConnectionSource(n, readPreference)));
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new SessionBindingConnectionSource(this.getConnectionSource(this.wrapped::getWriteConnectionSource));
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    private ConnectionSource getConnectionSource(Supplier<ConnectionSource> supplier) {
        if (!this.session.hasActiveTransaction()) {
            return supplier.get();
        }
        if (TransactionContext.get(this.session) == null) {
            ConnectionSource connectionSource = supplier.get();
            ClusterType clusterType = connectionSource.getServerDescription().getClusterType();
            if (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED) {
                TransactionContext transactionContext = new TransactionContext(clusterType);
                this.session.setTransactionContext(connectionSource.getServerDescription().getAddress(), transactionContext);
                transactionContext.release();
            }
            return connectionSource;
        }
        return this.wrapped.getConnectionSource(Assertions.assertNotNull(this.session.getPinnedServerAddress()));
    }

    private final class SyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;

        SyncClientSessionContext(ClientSession clientSession) {
            super(clientSession);
            this.clientSession = clientSession;
        }

        @Override
        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        @Override
        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        @Override
        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        @Override
        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return Assertions.assertNotNull(this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return ClientSessionBinding.this.wrapped.getOperationContext().getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource connectionSource) {
            this.wrapped = connectionSource;
            ClientSessionBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public OperationContext getOperationContext() {
            return ClientSessionBinding.this.operationContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public Connection getConnection() {
            Connection connection = TransactionContext.get(ClientSessionBinding.this.session);
            if (connection != null && ((TransactionContext)((Object)connection)).isConnectionPinningRequired()) {
                Connection connection2 = (Connection)((TransactionContext)((Object)connection)).getPinnedConnection();
                if (connection2 == null) {
                    Connection connection3 = this.wrapped.getConnection();
                    ((TransactionContext)((Object)connection)).pinConnection((Connection)connection3, Connection::markAsPinned);
                    return connection3;
                }
                return connection2.retain();
            }
            return this.wrapped.getConnection();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int n = this.wrapped.release();
            if (n == 0) {
                ClientSessionBinding.this.release();
            }
            return n;
        }
    }
}

