/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.TransactionBody;
import com.mongodb.client.internal.ClientSessionClock;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.operation.AbortTransactionOperation;
import com.mongodb.internal.operation.CommitTransactionOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.session.BaseClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;

final class ClientSessionImpl
extends BaseClientSessionImpl
implements ClientSession {
    private static final int MAX_RETRY_TIME_LIMIT_MS = 120000;
    private final OperationExecutor operationExecutor;
    private BaseClientSessionImpl.TransactionState transactionState = BaseClientSessionImpl.TransactionState.NONE;
    private boolean messageSentInCurrentTransaction;
    private boolean commitInProgress;
    private TransactionOptions transactionOptions;

    ClientSessionImpl(ServerSessionPool serverSessionPool, Object object, ClientSessionOptions clientSessionOptions, OperationExecutor operationExecutor) {
        super(serverSessionPool, object, clientSessionOptions);
        this.operationExecutor = operationExecutor;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.transactionState == BaseClientSessionImpl.TransactionState.IN || this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED && this.commitInProgress;
    }

    @Override
    public boolean notifyMessageSent() {
        if (this.hasActiveTransaction()) {
            boolean bl = !this.messageSentInCurrentTransaction;
            this.messageSentInCurrentTransaction = true;
            return bl;
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED || this.transactionState == BaseClientSessionImpl.TransactionState.ABORTED) {
            this.cleanupTransaction(BaseClientSessionImpl.TransactionState.NONE);
        }
        return false;
    }

    @Override
    public void notifyOperationInitiated(Object object) {
        Assertions.assertTrue(object instanceof ReadOperation || object instanceof WriteOperation);
        if (!this.hasActiveTransaction() && !(object instanceof CommitTransactionOperation)) {
            Assertions.assertTrue(this.getPinnedServerAddress() == null || this.transactionState != BaseClientSessionImpl.TransactionState.ABORTED && this.transactionState != BaseClientSessionImpl.TransactionState.NONE);
            this.clearTransactionContext();
        }
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue("in transaction", this.transactionState == BaseClientSessionImpl.TransactionState.IN || this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        this.startTransaction(transactionOptions, this.createTimeoutContext(transactionOptions));
    }

    @Override
    public void commitTransaction() {
        this.commitTransaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortTransaction() {
        if (this.transactionState == BaseClientSessionImpl.TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call abortTransaction twice");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED) {
            throw new IllegalStateException("Cannot call abortTransaction after calling commitTransaction");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        try {
            if (this.messageSentInCurrentTransaction) {
                ReadConcern readConcern = this.transactionOptions.getReadConcern();
                if (readConcern == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
                }
                this.resetTimeout();
                TimeoutContext timeoutContext = this.getTimeoutContext();
                WriteConcern writeConcern = Assertions.assertNotNull(this.getWriteConcern(timeoutContext));
                this.operationExecutor.execute(new AbortTransactionOperation(writeConcern).recoveryToken(this.getRecoveryToken()), readConcern, this);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            this.clearTransactionContext();
            this.cleanupTransaction(BaseClientSessionImpl.TransactionState.ABORTED);
        }
    }

    private void startTransaction(TransactionOptions transactionOptions, TimeoutContext timeoutContext) {
        Boolean bl = this.getOptions().isSnapshot();
        if (bl != null && bl.booleanValue()) {
            throw new IllegalArgumentException("Transactions are not supported in snapshot sessions");
        }
        Assertions.notNull("transactionOptions", transactionOptions);
        if (this.transactionState == BaseClientSessionImpl.TransactionState.IN) {
            throw new IllegalStateException("Transaction already in progress");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED) {
            this.cleanupTransaction(BaseClientSessionImpl.TransactionState.IN);
        } else {
            this.transactionState = BaseClientSessionImpl.TransactionState.IN;
        }
        this.getServerSession().advanceTransactionNumber();
        this.transactionOptions = TransactionOptions.merge(transactionOptions, this.getOptions().getDefaultTransactionOptions());
        WriteConcern writeConcern = this.getWriteConcern(timeoutContext);
        if (writeConcern == null) {
            throw new MongoInternalException("Invariant violated.  Transaction options write concern can not be null");
        }
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Transactions do not support unacknowledged write concern");
        }
        this.clearTransactionContext();
        this.setTimeoutContext(timeoutContext);
    }

    @Nullable
    private WriteConcern getWriteConcern(@Nullable TimeoutContext timeoutContext) {
        WriteConcern writeConcern = this.transactionOptions.getWriteConcern();
        if (ClientSessionImpl.hasTimeoutMS(timeoutContext) && ClientSessionImpl.hasWTimeoutMS(writeConcern)) {
            return WriteConcernHelper.cloneWithoutTimeout(writeConcern);
        }
        return writeConcern;
    }

    private void commitTransaction(boolean bl) {
        if (this.transactionState == BaseClientSessionImpl.TransactionState.ABORTED) {
            throw new IllegalStateException("Cannot call commitTransaction after calling abortTransaction");
        }
        if (this.transactionState == BaseClientSessionImpl.TransactionState.NONE) {
            throw new IllegalStateException("There is no transaction started");
        }
        try {
            if (this.messageSentInCurrentTransaction) {
                ReadConcern readConcern = this.transactionOptions.getReadConcern();
                if (readConcern == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
                }
                this.commitInProgress = true;
                if (bl) {
                    this.resetTimeout();
                }
                TimeoutContext timeoutContext = this.getTimeoutContext();
                WriteConcern writeConcern = Assertions.assertNotNull(this.getWriteConcern(timeoutContext));
                this.operationExecutor.execute(new CommitTransactionOperation(writeConcern, this.transactionState == BaseClientSessionImpl.TransactionState.COMMITTED).recoveryToken(this.getRecoveryToken()), readConcern, this);
            }
        }
        catch (MongoException mongoException) {
            this.clearTransactionContextOnError(mongoException);
            throw mongoException;
        }
        finally {
            this.transactionState = BaseClientSessionImpl.TransactionState.COMMITTED;
            this.commitInProgress = false;
        }
    }

    private void clearTransactionContextOnError(MongoException mongoException) {
        if (mongoException.hasErrorLabel("TransientTransactionError") || mongoException.hasErrorLabel("UnknownTransactionCommitResult")) {
            this.clearTransactionContext();
        }
    }

    @Override
    public <T> T withTransaction(TransactionBody<T> transactionBody) {
        return this.withTransaction(transactionBody, TransactionOptions.builder().build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T withTransaction(TransactionBody<T> transactionBody, TransactionOptions transactionOptions) {
        Assertions.notNull("transactionBody", transactionBody);
        long l = ClientSessionClock.INSTANCE.now();
        TimeoutContext timeoutContext = this.createTimeoutContext(transactionOptions);
        block4: while (true) {
            T t;
            try {
                this.startTransaction(transactionOptions, timeoutContext.copyTimeoutContext());
                t = transactionBody.execute();
            }
            catch (Throwable throwable) {
                MongoException mongoException;
                if (this.transactionState == BaseClientSessionImpl.TransactionState.IN) {
                    this.abortTransaction();
                }
                if (throwable instanceof MongoException && !(throwable instanceof MongoOperationTimeoutException) && (mongoException = OperationHelper.unwrap((MongoException)throwable)).hasErrorLabel("TransientTransactionError") && ClientSessionClock.INSTANCE.now() - l < 120000L) continue;
                throw throwable;
            }
            if (this.transactionState != BaseClientSessionImpl.TransactionState.IN) return t;
            while (true) {
                try {
                    this.commitTransaction(false);
                    return t;
                }
                catch (MongoException mongoException) {
                    this.clearTransactionContextOnError(mongoException);
                    if (mongoException instanceof MongoOperationTimeoutException || ClientSessionClock.INSTANCE.now() - l >= 120000L) throw mongoException;
                    this.applyMajorityWriteConcernToTransactionOptions();
                    if (!(mongoException instanceof MongoExecutionTimeoutException) && mongoException.hasErrorLabel("UnknownTransactionCommitResult")) continue;
                    if (!mongoException.hasErrorLabel("TransientTransactionError")) throw mongoException;
                    continue block4;
                }
                break;
            }
            break;
        }
    }

    @Override
    public void close() {
        try {
            if (this.transactionState == BaseClientSessionImpl.TransactionState.IN) {
                this.abortTransaction();
            }
        }
        finally {
            this.clearTransactionContext();
            super.close();
        }
    }

    private void applyMajorityWriteConcernToTransactionOptions() {
        TimeoutContext timeoutContext;
        WriteConcern writeConcern;
        this.transactionOptions = this.transactionOptions != null ? ((writeConcern = this.getWriteConcern(timeoutContext = this.getTimeoutContext())) != null ? TransactionOptions.merge(TransactionOptions.builder().writeConcern(writeConcern.withW("majority")).build(), this.transactionOptions) : TransactionOptions.merge(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build(), this.transactionOptions)) : TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build();
    }

    private void cleanupTransaction(BaseClientSessionImpl.TransactionState transactionState) {
        this.messageSentInCurrentTransaction = false;
        this.transactionOptions = null;
        this.transactionState = transactionState;
        this.setTimeoutContext(null);
    }

    private TimeoutContext createTimeoutContext(TransactionOptions transactionOptions) {
        return new TimeoutContext(this.getTimeoutSettings(TransactionOptions.merge(transactionOptions, this.getOptions().getDefaultTransactionOptions()), this.operationExecutor.getTimeoutSettings()));
    }
}

