/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;

class CollectionInfoRetriever {
    private static final String TIMEOUT_ERROR_MESSAGE = "Collection information retrieval exceeded the timeout limit.";
    private final MongoClient client;

    CollectionInfoRetriever(MongoClient mongoClient) {
        this.client = Assertions.notNull("client", mongoClient);
    }

    public List<BsonDocument> filter(String string, BsonDocument bsonDocument, @Nullable Timeout timeout) {
        return TimeoutHelper.databaseWithTimeout(this.client.getDatabase(string), TIMEOUT_ERROR_MESSAGE, timeout).listCollections(BsonDocument.class).filter(bsonDocument).into(new ArrayList());
    }
}

