/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.crypt.capi.MongoCrypt;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Map;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;

class CommandMarker
implements Closeable {
    private static final String TIMEOUT_ERROR_MESSAGE = "Command marker exceeded the timeout limit.";
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings autoEncryptionSettings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled(mongoCrypt.getCryptSharedLibVersionString(), autoEncryptionSettings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map<String, Object> map = autoEncryptionSettings.getExtraOptions();
            boolean bl = (Boolean)map.getOrDefault("mongocryptdBypassSpawn", false);
            if (!bl) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(map);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)map.get("mongocryptdURI")));
        }
    }

    RawBsonDocument mark(String string, RawBsonDocument rawBsonDocument, @Nullable Timeout timeout) {
        if (this.client != null) {
            try {
                try {
                    return this.executeCommand(string, rawBsonDocument, timeout);
                }
                catch (MongoOperationTimeoutException mongoOperationTimeoutException) {
                    throw mongoOperationTimeoutException;
                }
                catch (MongoTimeoutException mongoTimeoutException) {
                    if (this.processBuilder == null) {
                        throw mongoTimeoutException;
                    }
                    MongoCryptHelper.startProcess(this.processBuilder);
                    return this.executeCommand(string, rawBsonDocument, timeout);
                }
            }
            catch (MongoException mongoException) {
                throw this.wrapInClientException(mongoException);
            }
        }
        return rawBsonDocument;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String string, RawBsonDocument rawBsonDocument, @Nullable Timeout timeout) {
        Assertions.assertNotNull(this.client);
        MongoDatabase mongoDatabase = this.client.getDatabase(string).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary());
        return TimeoutHelper.databaseWithTimeout(mongoDatabase, TIMEOUT_ERROR_MESSAGE, timeout).runCommand((Bson)rawBsonDocument, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException mongoException) {
        return new MongoClientException("Exception in encryption library: " + mongoException.getMessage(), mongoException);
    }
}

