/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.CollectionInfoRetriever;
import com.mongodb.client.internal.CommandMarker;
import com.mongodb.client.internal.KeyManagementService;
import com.mongodb.client.internal.KeyRetriever;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.client.vault.EncryptOptionsHelper;
import com.mongodb.internal.crypt.capi.MongoCrypt;
import com.mongodb.internal.crypt.capi.MongoCryptContext;
import com.mongodb.internal.crypt.capi.MongoDataKeyOptions;
import com.mongodb.internal.crypt.capi.MongoKeyDecryptor;
import com.mongodb.internal.crypt.capi.MongoRewrapManyDataKeyOptions;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

public class Crypt
implements Closeable {
    private static final RawBsonDocument EMPTY_RAW_BSON_DOCUMENT = RawBsonDocument.parse("{}");
    private final MongoCrypt mongoCrypt;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;
    @Nullable
    private final MongoClient collectionInfoRetrieverClient;
    @Nullable
    private final MongoClient keyVaultClient;

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> map, Map<String, Supplier<Map<String, Object>>> map2) {
        this(mongoCrypt, keyRetriever, keyManagementService, map, map2, false, null, null, null, null);
    }

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> map, Map<String, Supplier<Map<String, Object>>> map2, boolean bl, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, @Nullable MongoClient mongoClient, @Nullable MongoClient mongoClient2) {
        this.mongoCrypt = mongoCrypt;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.kmsProviders = map;
        this.kmsProviderPropertySuppliers = map2;
        this.bypassAutoEncryption = bl;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.collectionInfoRetrieverClient = mongoClient;
        this.keyVaultClient = mongoClient2;
    }

    RawBsonDocument encrypt(String string, RawBsonDocument rawBsonDocument, @Nullable Timeout timeout) {
        RawBsonDocument rawBsonDocument2;
        block9: {
            Assertions.notNull("databaseName", string);
            Assertions.notNull("command", rawBsonDocument);
            if (this.bypassAutoEncryption) {
                return rawBsonDocument;
            }
            MongoCryptContext mongoCryptContext = this.mongoCrypt.createEncryptionContext(string, (BsonDocument)rawBsonDocument);
            try {
                rawBsonDocument2 = this.executeStateMachine(mongoCryptContext, string, timeout);
                if (mongoCryptContext == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (mongoCryptContext != null) {
                        try {
                            mongoCryptContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException mongoCryptException) {
                    throw this.wrapInMongoException(mongoCryptException);
                }
            }
            mongoCryptContext.close();
        }
        return rawBsonDocument2;
    }

    RawBsonDocument decrypt(RawBsonDocument rawBsonDocument, @Nullable Timeout timeout) {
        RawBsonDocument rawBsonDocument2;
        block8: {
            Assertions.notNull("commandResponse", rawBsonDocument);
            MongoCryptContext mongoCryptContext = this.mongoCrypt.createDecryptionContext((BsonDocument)rawBsonDocument);
            try {
                rawBsonDocument2 = this.executeStateMachine(mongoCryptContext, null, timeout);
                if (mongoCryptContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (mongoCryptContext != null) {
                        try {
                            mongoCryptContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException mongoCryptException) {
                    throw this.wrapInMongoException(mongoCryptException);
                }
            }
            mongoCryptContext.close();
        }
        return rawBsonDocument2;
    }

    BsonDocument createDataKey(String string, DataKeyOptions dataKeyOptions, @Nullable Timeout timeout) {
        RawBsonDocument rawBsonDocument;
        block8: {
            Assertions.notNull("kmsProvider", string);
            Assertions.notNull("options", dataKeyOptions);
            MongoCryptContext mongoCryptContext = this.mongoCrypt.createDataKeyContext(string, MongoDataKeyOptions.builder().keyAltNames(dataKeyOptions.getKeyAltNames()).masterKey(dataKeyOptions.getMasterKey()).keyMaterial(dataKeyOptions.getKeyMaterial()).build());
            try {
                rawBsonDocument = this.executeStateMachine(mongoCryptContext, null, timeout);
                if (mongoCryptContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (mongoCryptContext != null) {
                        try {
                            mongoCryptContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException mongoCryptException) {
                    throw this.wrapInMongoException(mongoCryptException);
                }
            }
            mongoCryptContext.close();
        }
        return rawBsonDocument;
    }

    BsonBinary encryptExplicitly(BsonValue bsonValue, EncryptOptions encryptOptions, @Nullable Timeout timeout) {
        BsonBinary bsonBinary;
        block8: {
            Assertions.notNull("value", bsonValue);
            Assertions.notNull("options", encryptOptions);
            MongoCryptContext mongoCryptContext = this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", bsonValue), EncryptOptionsHelper.asMongoExplicitEncryptOptions(encryptOptions));
            try {
                bsonBinary = this.executeStateMachine(mongoCryptContext, null, timeout).getBinary("v");
                if (mongoCryptContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (mongoCryptContext != null) {
                        try {
                            mongoCryptContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException mongoCryptException) {
                    throw this.wrapInMongoException(mongoCryptException);
                }
            }
            mongoCryptContext.close();
        }
        return bsonBinary;
    }

    BsonDocument encryptExpression(BsonDocument bsonDocument, EncryptOptions encryptOptions, @Nullable Timeout timeout) {
        BsonDocument bsonDocument2;
        block8: {
            Assertions.notNull("expression", bsonDocument);
            Assertions.notNull("options", encryptOptions);
            MongoCryptContext mongoCryptContext = this.mongoCrypt.createEncryptExpressionContext(new BsonDocument("v", bsonDocument), EncryptOptionsHelper.asMongoExplicitEncryptOptions(encryptOptions));
            try {
                bsonDocument2 = this.executeStateMachine(mongoCryptContext, null, timeout).getDocument("v");
                if (mongoCryptContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (mongoCryptContext != null) {
                        try {
                            mongoCryptContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException mongoCryptException) {
                    throw this.wrapInMongoException(mongoCryptException);
                }
            }
            mongoCryptContext.close();
        }
        return bsonDocument2;
    }

    BsonValue decryptExplicitly(BsonBinary bsonBinary, @Nullable Timeout timeout) {
        BsonValue bsonValue;
        block8: {
            Assertions.notNull("value", bsonBinary);
            MongoCryptContext mongoCryptContext = this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", bsonBinary));
            try {
                bsonValue = Assertions.assertNotNull(this.executeStateMachine(mongoCryptContext, null, timeout).get("v"));
                if (mongoCryptContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (mongoCryptContext != null) {
                        try {
                            mongoCryptContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException mongoCryptException) {
                    throw this.wrapInMongoException(mongoCryptException);
                }
            }
            mongoCryptContext.close();
        }
        return bsonValue;
    }

    BsonDocument rewrapManyDataKey(BsonDocument bsonDocument, RewrapManyDataKeyOptions rewrapManyDataKeyOptions, @Nullable Timeout timeout) {
        RawBsonDocument rawBsonDocument;
        block8: {
            Assertions.notNull("filter", bsonDocument);
            MongoCryptContext mongoCryptContext = this.mongoCrypt.createRewrapManyDatakeyContext(bsonDocument, MongoRewrapManyDataKeyOptions.builder().provider(rewrapManyDataKeyOptions.getProvider()).masterKey(rewrapManyDataKeyOptions.getMasterKey()).build());
            try {
                rawBsonDocument = this.executeStateMachine(mongoCryptContext, null, timeout);
                if (mongoCryptContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (mongoCryptContext != null) {
                        try {
                            mongoCryptContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException mongoCryptException) {
                    throw this.wrapInMongoException(mongoCryptException);
                }
            }
            mongoCryptContext.close();
        }
        return rawBsonDocument;
    }

    @Override
    public void close() {
        try (MongoCrypt mongoCrypt = this.mongoCrypt;
             CommandMarker commandMarker = this.commandMarker;
             MongoClient mongoClient = this.collectionInfoRetrieverClient;){
            MongoClient mongoClient2 = this.keyVaultClient;
            if (mongoClient2 != null) {
                mongoClient2.close();
            }
        }
    }

    private RawBsonDocument executeStateMachine(MongoCryptContext mongoCryptContext, @Nullable String string, @Nullable Timeout timeout) {
        MongoCryptContext.State state;
        block9: while (true) {
            state = mongoCryptContext.getState();
            switch (state) {
                case NEED_MONGO_COLLINFO: {
                    this.collInfo(mongoCryptContext, Assertions.notNull("databaseName", string), timeout);
                    continue block9;
                }
                case NEED_MONGO_MARKINGS: {
                    this.mark(mongoCryptContext, Assertions.notNull("databaseName", string), timeout);
                    continue block9;
                }
                case NEED_KMS_CREDENTIALS: {
                    this.fetchCredentials(mongoCryptContext);
                    continue block9;
                }
                case NEED_MONGO_KEYS: {
                    this.fetchKeys(mongoCryptContext, timeout);
                    continue block9;
                }
                case NEED_KMS: {
                    this.decryptKeys(mongoCryptContext, timeout);
                    continue block9;
                }
                case READY: {
                    return mongoCryptContext.finish();
                }
                case DONE: {
                    return EMPTY_RAW_BSON_DOCUMENT;
                }
            }
            break;
        }
        throw new MongoInternalException("Unsupported encryptor state + " + state);
    }

    private void fetchCredentials(MongoCryptContext mongoCryptContext) {
        mongoCryptContext.provideKmsProviderCredentials(MongoCryptHelper.fetchCredentials(this.kmsProviders, this.kmsProviderPropertySuppliers));
    }

    private void collInfo(MongoCryptContext mongoCryptContext, String string, @Nullable Timeout timeout) {
        try {
            List<BsonDocument> list = Assertions.assertNotNull(this.collectionInfoRetriever).filter(string, mongoCryptContext.getMongoOperation(), timeout);
            for (BsonDocument bsonDocument : list) {
                mongoCryptContext.addMongoOperationResult(bsonDocument);
            }
            mongoCryptContext.completeMongoOperation();
        }
        catch (Throwable throwable) {
            throw MongoException.fromThrowableNonNull(throwable);
        }
    }

    private void mark(MongoCryptContext mongoCryptContext, String string, @Nullable Timeout timeout) {
        try {
            RawBsonDocument rawBsonDocument = Assertions.assertNotNull(this.commandMarker).mark(string, mongoCryptContext.getMongoOperation(), timeout);
            mongoCryptContext.addMongoOperationResult((BsonDocument)rawBsonDocument);
            mongoCryptContext.completeMongoOperation();
        }
        catch (Throwable throwable) {
            throw this.wrapInMongoException(throwable);
        }
    }

    private void fetchKeys(MongoCryptContext mongoCryptContext, @Nullable Timeout timeout) {
        try {
            for (BsonDocument bsonDocument : this.keyRetriever.find(mongoCryptContext.getMongoOperation(), timeout)) {
                mongoCryptContext.addMongoOperationResult(bsonDocument);
            }
            mongoCryptContext.completeMongoOperation();
        }
        catch (Throwable throwable) {
            throw MongoException.fromThrowableNonNull(throwable);
        }
    }

    private void decryptKeys(MongoCryptContext mongoCryptContext, @Nullable Timeout timeout) {
        try {
            MongoKeyDecryptor mongoKeyDecryptor = mongoCryptContext.nextKeyDecryptor();
            while (mongoKeyDecryptor != null) {
                this.decryptKey(mongoKeyDecryptor, timeout);
                mongoKeyDecryptor = mongoCryptContext.nextKeyDecryptor();
            }
            mongoCryptContext.completeKeyDecryptors();
        }
        catch (Throwable throwable) {
            throw InterruptionUtil.translateInterruptedException(throwable, "Interrupted while doing IO").orElseThrow(() -> this.wrapInMongoException(throwable));
        }
    }

    private void decryptKey(MongoKeyDecryptor mongoKeyDecryptor, @Nullable Timeout timeout) throws IOException {
        try (InputStream inputStream = this.keyManagementService.stream(mongoKeyDecryptor.getKmsProvider(), mongoKeyDecryptor.getHostName(), mongoKeyDecryptor.getMessage(), timeout);){
            int n = mongoKeyDecryptor.bytesNeeded();
            while (n > 0) {
                byte[] byArray = new byte[n];
                int n2 = inputStream.read(byArray, 0, byArray.length);
                mongoKeyDecryptor.feed(ByteBuffer.wrap(byArray, 0, n2));
                n = mongoKeyDecryptor.bytesNeeded();
            }
        }
    }

    private MongoException wrapInMongoException(Throwable throwable) {
        if (throwable instanceof MongoException) {
            return (MongoException)throwable;
        }
        return new MongoClientException("Exception in encryption library: " + throwable.getMessage(), throwable);
    }
}

