/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.CryptConnection;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;

class CryptBinding
implements ClusterAwareReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    CryptBinding(ClusterAwareReadWriteBinding clusterAwareReadWriteBinding, Crypt crypt) {
        this.crypt = crypt;
        this.wrapped = clusterAwareReadWriteBinding;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource());
    }

    @Override
    public ConnectionSource getReadConnectionSource(int n, ReadPreference readPreference) {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource(n, readPreference));
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new CryptConnectionSource(this.wrapped.getConnectionSource(serverAddress));
    }

    @Override
    public OperationContext getOperationContext() {
        return this.wrapped.getOperationContext();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public int release() {
        return this.wrapped.release();
    }

    private class CryptConnectionSource
    implements ConnectionSource {
        private final ConnectionSource wrapped;

        CryptConnectionSource(ConnectionSource connectionSource) {
            this.wrapped = connectionSource;
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public OperationContext getOperationContext() {
            return this.wrapped.getOperationContext();
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public Connection getConnection() {
            return new CryptConnection(this.wrapped.getConnection(), CryptBinding.this.crypt);
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public int release() {
            return this.wrapped.release();
        }
    }
}

