/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoClientException;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.internal.Crypt;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.MessageSequences;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.SplittablePayload;
import com.mongodb.internal.connection.SplittablePayloadBsonWriter;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.time.Timeout;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.HashMap;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBinaryWriterSettings;
import org.bson.BsonDocument;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

public final class CryptConnection
implements Connection {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final int MAX_SPLITTABLE_DOCUMENT_SIZE = 0x200000;
    private final Connection wrapped;
    private final Crypt crypt;

    CryptConnection(Connection connection, Crypt crypt) {
        this.wrapped = connection;
        this.crypt = crypt;
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public CryptConnection retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public int release() {
        return this.wrapped.release();
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    @Nullable
    public <T> T command(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext, boolean bl, MessageSequences messageSequences) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo(this.wrapped.getDescription())) {
            throw new MongoClientException("Auto-encryption requires a minimum MongoDB version of 4.2");
        }
        SplittablePayload splittablePayload = null;
        FieldNameValidator fieldNameValidator2 = null;
        if (messageSequences instanceof SplittablePayload) {
            splittablePayload = (SplittablePayload)messageSequences;
            fieldNameValidator2 = splittablePayload.getFieldNameValidator();
        } else if (!(messageSequences instanceof MessageSequences.EmptyMessageSequences)) {
            Assertions.fail(messageSequences.toString());
        }
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(this.getDescription().getMaxDocumentSize()), basicOutputBuffer, this.getFieldNameValidator(splittablePayload, fieldNameValidator, fieldNameValidator2));
        BsonWriter bsonWriter = splittablePayload == null ? bsonBinaryWriter : new SplittablePayloadBsonWriter(bsonBinaryWriter, (BsonOutput)basicOutputBuffer, this.createSplittablePayloadMessageSettings(), splittablePayload, 0x200000);
        this.getEncoder(bsonDocument).encode(bsonWriter, bsonDocument, EncoderContext.builder().build());
        Timeout timeout = operationContext.getTimeoutContext().getTimeout();
        RawBsonDocument rawBsonDocument = this.crypt.encrypt(string, new RawBsonDocument(basicOutputBuffer.getInternalBuffer(), 0, basicOutputBuffer.getSize()), timeout);
        RawBsonDocument rawBsonDocument2 = this.wrapped.command(string, rawBsonDocument, fieldNameValidator, readPreference, new RawBsonDocumentCodec(), operationContext, bl, MessageSequences.EmptyMessageSequences.INSTANCE);
        if (rawBsonDocument2 == null) {
            return null;
        }
        RawBsonDocument rawBsonDocument3 = this.crypt.decrypt(rawBsonDocument2, timeout);
        BsonBinaryReader bsonBinaryReader = new BsonBinaryReader(rawBsonDocument3.getByteBuffer().asNIO());
        return decoder.decode(bsonBinaryReader, DecoderContext.builder().build());
    }

    @Override
    @Nullable
    public <T> T command(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext) {
        return this.command(string, bsonDocument, fieldNameValidator, readPreference, decoder, operationContext, true, MessageSequences.EmptyMessageSequences.INSTANCE);
    }

    private Codec<BsonDocument> getEncoder(BsonDocument bsonDocument) {
        return REGISTRY.get(bsonDocument.getClass());
    }

    private FieldNameValidator getFieldNameValidator(@Nullable SplittablePayload splittablePayload, FieldNameValidator fieldNameValidator, @Nullable FieldNameValidator fieldNameValidator2) {
        if (splittablePayload == null) {
            return fieldNameValidator;
        }
        HashMap<String, FieldNameValidator> hashMap = new HashMap<String, FieldNameValidator>();
        hashMap.put(splittablePayload.getPayloadName(), fieldNameValidator2);
        return new MappedFieldNameValidator(fieldNameValidator, hashMap);
    }

    private MessageSettings createSplittablePayloadMessageSettings() {
        return MessageSettings.builder().maxBatchCount(this.getDescription().getMaxBatchCount()).maxMessageSize(this.getDescription().getMaxMessageSize()).maxDocumentSize(this.getDescription().getMaxDocumentSize()).build();
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }
}

