/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.internal.CollectionInfoRetriever;
import com.mongodb.client.internal.CommandMarker;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.KeyManagementService;
import com.mongodb.client.internal.KeyRetriever;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.crypt.capi.MongoCrypt;
import com.mongodb.internal.crypt.capi.MongoCryptOptions;
import com.mongodb.internal.crypt.capi.MongoCrypts;
import java.util.Map;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(MongoClientSettings mongoClientSettings, AutoEncryptionSettings autoEncryptionSettings) {
        Object object;
        MongoClient mongoClient = null;
        MongoClientSettings mongoClientSettings2 = autoEncryptionSettings.getKeyVaultMongoClientSettings();
        if (mongoClientSettings2 == null || !autoEncryptionSettings.isBypassAutoEncryption()) {
            object = MongoClientSettings.builder(mongoClientSettings).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            mongoClient = MongoClients.create((MongoClientSettings)object);
        }
        object = mongoClientSettings2 == null ? mongoClient : MongoClients.create(mongoClientSettings2);
        MongoCrypt mongoCrypt = MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(autoEncryptionSettings));
        return new Crypt(mongoCrypt, Crypts.createKeyRetriever((MongoClient)object, autoEncryptionSettings.getKeyVaultNamespace()), Crypts.createKeyManagementService(autoEncryptionSettings.getKmsProviderSslContextMap()), autoEncryptionSettings.getKmsProviders(), autoEncryptionSettings.getKmsProviderPropertySuppliers(), autoEncryptionSettings.isBypassAutoEncryption(), autoEncryptionSettings.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(mongoClient), new CommandMarker(mongoCrypt, autoEncryptionSettings), mongoClient, (MongoClient)object);
    }

    static Crypt create(MongoClient mongoClient, ClientEncryptionSettings clientEncryptionSettings) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(clientEncryptionSettings)), Crypts.createKeyRetriever(mongoClient, clientEncryptionSettings.getKeyVaultNamespace()), Crypts.createKeyManagementService(clientEncryptionSettings.getKmsProviderSslContextMap()), clientEncryptionSettings.getKmsProviders(), clientEncryptionSettings.getKmsProviderPropertySuppliers());
    }

    private static KeyRetriever createKeyRetriever(MongoClient mongoClient, String string) {
        return new KeyRetriever(mongoClient, new MongoNamespace(string));
    }

    private static KeyManagementService createKeyManagementService(Map<String, SSLContext> map) {
        return new KeyManagementService(map, 10000);
    }

    private Crypts() {
    }
}

