/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class DistinctIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements DistinctIterable<TResult> {
    private final SyncOperations<TDocument> operations;
    private final Class<TResult> resultClass;
    private final String fieldName;
    private Bson filter;
    private long maxTimeMS;
    private Collation collation;
    private BsonValue comment;
    private Bson hint;
    private String hintString;

    DistinctIterableImpl(@Nullable ClientSession clientSession, MongoNamespace mongoNamespace, Class<TDocument> clazz, Class<TResult> clazz2, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor operationExecutor, String string, Bson bson, boolean bl, TimeoutSettings timeoutSettings) {
        super(clientSession, operationExecutor, readConcern, readPreference, bl, timeoutSettings);
        this.operations = new SyncOperations<TDocument>(mongoNamespace, clazz, readPreference, codecRegistry, bl, timeoutSettings);
        this.resultClass = Assertions.notNull("resultClass", clazz2);
        this.fieldName = Assertions.notNull("mapFunction", string);
        this.filter = bson;
    }

    @Override
    public DistinctIterable<TResult> filter(@Nullable Bson bson) {
        this.filter = bson;
        return this;
    }

    @Override
    public DistinctIterable<TResult> maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    @Override
    public DistinctIterable<TResult> batchSize(int n) {
        super.batchSize(n);
        return this;
    }

    @Override
    public DistinctIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public DistinctIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public DistinctIterable<TResult> comment(@Nullable String string) {
        this.comment = string == null ? null : new BsonString(string);
        return this;
    }

    @Override
    public DistinctIterable<TResult> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Override
    public DistinctIterable<TResult> hint(@Nullable Bson bson) {
        this.hint = bson;
        return this;
    }

    @Override
    public DistinctIterable<TResult> hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.distinct(this.fieldName, this.filter, this.resultClass, this.collation, this.comment, this.hint, this.hintString);
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS));
    }
}

