/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class FindIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements FindIterable<TResult> {
    private final SyncOperations<TDocument> operations;
    private final Class<TResult> resultClass;
    private final FindOptions findOptions;
    private final CodecRegistry codecRegistry;
    private Bson filter;

    FindIterableImpl(@Nullable ClientSession clientSession, MongoNamespace mongoNamespace, Class<TDocument> clazz, Class<TResult> clazz2, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor operationExecutor, Bson bson, boolean bl, TimeoutSettings timeoutSettings) {
        super(clientSession, operationExecutor, readConcern, readPreference, bl, timeoutSettings);
        this.operations = new SyncOperations<TDocument>(mongoNamespace, clazz, readPreference, codecRegistry, bl, timeoutSettings);
        this.resultClass = Assertions.notNull("resultClass", clazz2);
        this.filter = Assertions.notNull("filter", bson);
        this.findOptions = new FindOptions();
        this.codecRegistry = codecRegistry;
    }

    @Override
    public FindIterable<TResult> filter(@Nullable Bson bson) {
        this.filter = bson;
        return this;
    }

    @Override
    public FindIterable<TResult> limit(int n) {
        this.findOptions.limit(n);
        return this;
    }

    @Override
    public FindIterable<TResult> skip(int n) {
        this.findOptions.skip(n);
        return this;
    }

    @Override
    public FindIterable<TResult> maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxTime(l, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> maxAwaitTime(long l, TimeUnit timeUnit) {
        this.validateMaxAwaitTime(l, timeUnit);
        this.findOptions.maxAwaitTime(l, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> batchSize(int n) {
        super.batchSize(n);
        this.findOptions.batchSize(n);
        return this;
    }

    @Override
    public FindIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        this.findOptions.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public FindIterable<TResult> collation(@Nullable Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    @Override
    public FindIterable<TResult> projection(@Nullable Bson bson) {
        this.findOptions.projection(bson);
        return this;
    }

    @Override
    public FindIterable<TResult> sort(@Nullable Bson bson) {
        this.findOptions.sort(bson);
        return this;
    }

    @Override
    public FindIterable<TResult> noCursorTimeout(boolean bl) {
        this.findOptions.noCursorTimeout(bl);
        return this;
    }

    @Override
    public FindIterable<TResult> partial(boolean bl) {
        this.findOptions.partial(bl);
        return this;
    }

    @Override
    public FindIterable<TResult> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public FindIterable<TResult> comment(@Nullable String string) {
        this.findOptions.comment(string);
        return this;
    }

    @Override
    public FindIterable<TResult> comment(@Nullable BsonValue bsonValue) {
        this.findOptions.comment(bsonValue);
        return this;
    }

    @Override
    public FindIterable<TResult> hint(@Nullable Bson bson) {
        this.findOptions.hint(bson);
        return this;
    }

    @Override
    public FindIterable<TResult> hintString(@Nullable String string) {
        this.findOptions.hintString(string);
        return this;
    }

    @Override
    public FindIterable<TResult> let(@Nullable Bson bson) {
        this.findOptions.let(bson);
        return this;
    }

    @Override
    public FindIterable<TResult> max(@Nullable Bson bson) {
        this.findOptions.max(bson);
        return this;
    }

    @Override
    public FindIterable<TResult> min(@Nullable Bson bson) {
        this.findOptions.min(bson);
        return this;
    }

    @Override
    public FindIterable<TResult> returnKey(boolean bl) {
        this.findOptions.returnKey(bl);
        return this;
    }

    @Override
    public FindIterable<TResult> showRecordId(boolean bl) {
        this.findOptions.showRecordId(bl);
        return this;
    }

    @Override
    public FindIterable<TResult> allowDiskUse(@Nullable Boolean bl) {
        this.findOptions.allowDiskUse(bl);
        return this;
    }

    @Override
    @Nullable
    public TResult first() {
        try (BatchCursor<TResult> batchCursor = this.getExecutor().execute(this.operations.findFirst(this.filter, this.resultClass, this.findOptions), this.getReadPreference(), this.getReadConcern(), this.getClientSession());){
            TResult TResult = batchCursor.hasNext() ? (TResult)batchCursor.next().iterator().next() : null;
            return TResult;
        }
    }

    @Override
    public Document explain() {
        return this.executeExplain(Document.class, null);
    }

    @Override
    public Document explain(ExplainVerbosity explainVerbosity) {
        return this.executeExplain(Document.class, Assertions.notNull("verbosity", explainVerbosity));
    }

    @Override
    public <E> E explain(Class<E> clazz) {
        return this.executeExplain(clazz, null);
    }

    @Override
    public <E> E explain(Class<E> clazz, ExplainVerbosity explainVerbosity) {
        return this.executeExplain(clazz, Assertions.notNull("verbosity", explainVerbosity));
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.findOptions));
    }

    private <E> E executeExplain(Class<E> clazz, @Nullable ExplainVerbosity explainVerbosity) {
        Assertions.notNull("explainDocumentClass", clazz);
        return this.getExecutor().execute(this.asReadOperation().asExplainableOperation(explainVerbosity, this.codecRegistry.get(clazz)), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    @Override
    public ExplainableReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.find(this.filter, this.resultClass, this.findOptions);
    }
}

