/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;

class KeyRetriever {
    private static final String TIMEOUT_ERROR_MESSAGE = "Key retrieval exceeded the timeout limit.";
    private final MongoClient client;
    private final MongoNamespace namespace;

    KeyRetriever(MongoClient mongoClient, MongoNamespace mongoNamespace) {
        this.client = Assertions.notNull("client", mongoClient);
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
    }

    public List<BsonDocument> find(BsonDocument bsonDocument, @Nullable Timeout timeout) {
        MongoCollection<BsonDocument> mongoCollection = this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class);
        return TimeoutHelper.collectionWithTimeout(mongoCollection, TIMEOUT_ERROR_MESSAGE, timeout).withReadConcern(ReadConcern.MAJORITY).find(bsonDocument).into(new ArrayList());
    }
}

