/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.Function;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListCollectionNamesIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.ListCollectionsIterableImpl;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

final class ListCollectionNamesIterableImpl
implements ListCollectionNamesIterable {
    private final ListCollectionsIterableImpl<BsonDocument> wrapped;
    private final MongoIterable<String> wrappedWithMapping;

    ListCollectionNamesIterableImpl(ListCollectionsIterableImpl<BsonDocument> listCollectionsIterableImpl) {
        this.wrapped = listCollectionsIterableImpl;
        this.wrappedWithMapping = listCollectionsIterableImpl.map((TResult bsonDocument) -> bsonDocument.getString("name").getValue());
    }

    @Override
    public ListCollectionNamesIterable filter(@Nullable Bson bson) {
        this.wrapped.filter(bson);
        return this;
    }

    @Override
    public ListCollectionNamesIterable maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.wrapped.maxTime(l, timeUnit);
        return this;
    }

    @Override
    public ListCollectionNamesIterable batchSize(int n) {
        this.wrapped.batchSize(n);
        return this;
    }

    @Override
    public ListCollectionNamesIterable comment(@Nullable String string) {
        this.wrapped.comment(string);
        return this;
    }

    @Override
    public ListCollectionNamesIterable comment(@Nullable BsonValue bsonValue) {
        this.wrapped.comment(bsonValue);
        return this;
    }

    @Override
    public ListCollectionNamesIterable authorizedCollections(boolean bl) {
        this.wrapped.authorizedCollections(bl);
        return this;
    }

    @Override
    public MongoCursor<String> iterator() {
        return this.wrappedWithMapping.iterator();
    }

    @Override
    public MongoCursor<String> cursor() {
        return this.wrappedWithMapping.cursor();
    }

    @Override
    @Nullable
    public String first() {
        return this.wrappedWithMapping.first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<String, U> function) {
        return this.wrappedWithMapping.map(function);
    }

    @Override
    public <A extends Collection<? super String>> A into(A a) {
        return this.wrappedWithMapping.into(a);
    }

    ListCollectionsIterableImpl<BsonDocument> getWrapped() {
        return this.wrapped;
    }
}

