/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;

class ListIndexesIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListIndexesIterable<TResult> {
    private final SyncOperations<BsonDocument> operations;
    private final Class<TResult> resultClass;
    private long maxTimeMS;
    private BsonValue comment;

    ListIndexesIterableImpl(@Nullable ClientSession clientSession, MongoNamespace mongoNamespace, Class<TResult> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor operationExecutor, boolean bl, TimeoutSettings timeoutSettings) {
        super(clientSession, operationExecutor, ReadConcern.DEFAULT, readPreference, bl, timeoutSettings);
        this.operations = new SyncOperations<BsonDocument>(mongoNamespace, BsonDocument.class, readPreference, codecRegistry, bl, timeoutSettings);
        this.resultClass = Assertions.notNull("resultClass", clazz);
    }

    @Override
    public ListIndexesIterable<TResult> maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    @Override
    public ListIndexesIterable<TResult> batchSize(int n) {
        super.batchSize(n);
        return this;
    }

    @Override
    public ListIndexesIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public ListIndexesIterable<TResult> comment(@Nullable String string) {
        this.comment = string != null ? new BsonString(string) : null;
        return this;
    }

    @Override
    public ListIndexesIterable<TResult> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.listIndexes(this.resultClass, this.getBatchSize(), this.comment, this.getTimeoutMode());
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS));
    }
}

