/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListSearchIndexesIterable;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;

final class ListSearchIndexesIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListSearchIndexesIterable<TResult> {
    private final SyncOperations<BsonDocument> operations;
    private final Class<TResult> resultClass;
    @Nullable
    private Boolean allowDiskUse;
    @Nullable
    private long maxTimeMS;
    @Nullable
    private Collation collation;
    @Nullable
    private BsonValue comment;
    @Nullable
    private String indexName;
    private final CodecRegistry codecRegistry;

    ListSearchIndexesIterableImpl(MongoNamespace mongoNamespace, OperationExecutor operationExecutor, Class<TResult> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, boolean bl, TimeoutSettings timeoutSettings) {
        super(null, operationExecutor, ReadConcern.DEFAULT, readPreference, bl, timeoutSettings);
        this.resultClass = clazz;
        this.operations = new SyncOperations<BsonDocument>(mongoNamespace, BsonDocument.class, readPreference, codecRegistry, bl, timeoutSettings);
        this.codecRegistry = codecRegistry;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.asAggregateOperation();
    }

    @Override
    public ListSearchIndexesIterable<TResult> allowDiskUse(@Nullable Boolean bl) {
        this.allowDiskUse = bl;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> batchSize(int n) {
        super.batchSize(n);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> comment(@Nullable String string) {
        this.comment = string == null ? null : new BsonString(string);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> name(String string) {
        this.indexName = Assertions.notNull("indexName", string);
        return this;
    }

    @Override
    public Document explain() {
        return this.executeExplain(Document.class, null);
    }

    @Override
    public Document explain(ExplainVerbosity explainVerbosity) {
        Assertions.notNull("verbosity", explainVerbosity);
        return this.executeExplain(Document.class, explainVerbosity);
    }

    @Override
    public <E> E explain(Class<E> clazz) {
        Assertions.notNull("explainResultClass", clazz);
        return this.executeExplain(clazz, null);
    }

    @Override
    public <E> E explain(Class<E> clazz, ExplainVerbosity explainVerbosity) {
        Assertions.notNull("explainResultClass", clazz);
        Assertions.notNull("verbosity", explainVerbosity);
        return this.executeExplain(clazz, explainVerbosity);
    }

    private <E> E executeExplain(Class<E> clazz, @Nullable ExplainVerbosity explainVerbosity) {
        return this.getExecutor().execute(this.asAggregateOperation().asExplainableOperation(explainVerbosity, this.codecRegistry.get(clazz)), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    private ExplainableReadOperation<BatchCursor<TResult>> asAggregateOperation() {
        return this.operations.listSearchIndexes(this.resultClass, this.indexName, this.getBatchSize(), this.collation, this.comment, this.allowDiskUse);
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS));
    }
}

