/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.MapReduceBatchCursor;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MapReduceIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements MapReduceIterable<TResult> {
    private final SyncOperations<TDocument> operations;
    private final MongoNamespace namespace;
    private final Class<TResult> resultClass;
    private final String mapFunction;
    private final String reduceFunction;
    private boolean inline = true;
    private String collectionName;
    private String finalizeFunction;
    private Bson scope;
    private Bson filter;
    private Bson sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private MapReduceAction action = MapReduceAction.REPLACE;
    private String databaseName;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    MapReduceIterableImpl(@Nullable ClientSession clientSession, MongoNamespace mongoNamespace, Class<TDocument> clazz, Class<TResult> clazz2, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor operationExecutor, String string, String string2, TimeoutSettings timeoutSettings) {
        super(clientSession, operationExecutor, readConcern, readPreference, false, timeoutSettings);
        this.operations = new SyncOperations<TDocument>(mongoNamespace, clazz, readPreference, codecRegistry, readConcern, writeConcern, false, false, timeoutSettings);
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.resultClass = Assertions.notNull("resultClass", clazz2);
        this.mapFunction = Assertions.notNull("mapFunction", string);
        this.reduceFunction = Assertions.notNull("reduceFunction", string2);
    }

    @Override
    public void toCollection() {
        if (this.inline) {
            throw new IllegalStateException("The options must specify a non-inline result");
        }
        this.getExecutor().execute(this.createMapReduceToCollectionOperation(), this.getReadConcern(), this.getClientSession());
    }

    @Override
    public MapReduceIterable<TResult> collectionName(String string) {
        this.collectionName = Assertions.notNull("collectionName", string);
        this.inline = false;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> finalizeFunction(@Nullable String string) {
        this.finalizeFunction = string;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> scope(@Nullable Bson bson) {
        this.scope = bson;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sort(@Nullable Bson bson) {
        this.sort = bson;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> filter(@Nullable Bson bson) {
        this.filter = bson;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> limit(int n) {
        this.limit = n;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> jsMode(boolean bl) {
        this.jsMode = bl;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> verbose(boolean bl) {
        this.verbose = bl;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> action(MapReduceAction mapReduceAction) {
        this.action = mapReduceAction;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> databaseName(@Nullable String string) {
        this.databaseName = string;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> batchSize(int n) {
        super.batchSize(n);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    ReadPreference getReadPreference() {
        if (this.inline) {
            return super.getReadPreference();
        }
        return ReadPreference.primary();
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS));
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        if (this.inline) {
            ReadOperation<MapReduceBatchCursor<TResult>> readOperation = this.operations.mapReduce(this.mapFunction, this.reduceFunction, this.finalizeFunction, this.resultClass, this.filter, this.limit, this.jsMode, this.scope, this.sort, this.verbose, this.collation);
            return new WrappedMapReduceReadOperation<TResult>(readOperation);
        }
        this.getExecutor().execute(this.createMapReduceToCollectionOperation(), this.getReadConcern(), this.getClientSession());
        String string = this.databaseName != null ? this.databaseName : this.namespace.getDatabaseName();
        FindOptions findOptions = new FindOptions().collation(this.collation);
        Integer n = this.getBatchSize();
        if (n != null) {
            findOptions.batchSize(n);
        }
        return this.operations.find(new MongoNamespace(string, this.collectionName), new BsonDocument(), this.resultClass, findOptions);
    }

    private WriteOperation<MapReduceStatistics> createMapReduceToCollectionOperation() {
        return this.operations.mapReduceToCollection(this.databaseName, this.collectionName, this.mapFunction, this.reduceFunction, this.finalizeFunction, this.filter, this.limit, this.jsMode, this.scope, this.sort, this.verbose, this.action, this.bypassDocumentValidation, this.collation);
    }

    static class WrappedMapReduceReadOperation<TResult>
    implements ReadOperation<BatchCursor<TResult>> {
        private final ReadOperation<MapReduceBatchCursor<TResult>> operation;

        ReadOperation<MapReduceBatchCursor<TResult>> getOperation() {
            return this.operation;
        }

        WrappedMapReduceReadOperation(ReadOperation<MapReduceBatchCursor<TResult>> readOperation) {
            this.operation = readOperation;
        }

        @Override
        public BatchCursor<TResult> execute(ReadBinding readBinding) {
            return this.operation.execute(readBinding);
        }
    }
}

