/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.Function;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.MongoMappingCursor;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.function.Consumer;

public class MappingIterable<U, V>
implements MongoIterable<V> {
    private final MongoIterable<U> iterable;
    private final Function<U, V> mapper;

    public MappingIterable(MongoIterable<U> mongoIterable, Function<U, V> function) {
        this.iterable = mongoIterable;
        this.mapper = function;
    }

    @Override
    public MongoCursor<V> iterator() {
        return new MongoMappingCursor<U, V>(this.iterable.iterator(), this.mapper);
    }

    @Override
    public MongoCursor<V> cursor() {
        return this.iterator();
    }

    @Override
    @Nullable
    public V first() {
        U u = this.iterable.first();
        if (u == null) {
            return null;
        }
        return this.mapper.apply(u);
    }

    @Override
    public void forEach(Consumer<? super V> consumer) {
        this.iterable.forEach((? super T object) -> consumer.accept((V)this.mapper.apply(object)));
    }

    @Override
    public <A extends Collection<? super V>> A into(A a) {
        this.forEach((Consumer<? super V>)((Consumer<Object>)object -> a.add(object)));
        return a;
    }

    public MappingIterable<U, V> batchSize(int n) {
        this.iterable.batchSize(n);
        return this;
    }

    @Override
    public <W> MongoIterable<W> map(Function<V, W> function) {
        return new MappingIterable<V, W>(this, function);
    }

    MongoIterable<U> getMapped() {
        return this.iterable;
    }
}

