/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientBulkWriteException;
import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerApi;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoCluster;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.SynchronousContextProvider;
import com.mongodb.client.internal.ChangeStreamIterableImpl;
import com.mongodb.client.internal.ClientSessionBinding;
import com.mongodb.client.internal.ClientSessionImpl;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.CryptBinding;
import com.mongodb.client.internal.ListDatabasesIterableImpl;
import com.mongodb.client.internal.MongoDatabaseImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.internal.IgnorableRequestContext;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ClusterBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class MongoClusterImpl
implements MongoCluster {
    @Nullable
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final Cluster cluster;
    private final CodecRegistry codecRegistry;
    @Nullable
    private final SynchronousContextProvider contextProvider;
    @Nullable
    private final Crypt crypt;
    private final Object originator;
    private final OperationExecutor operationExecutor;
    private final ReadConcern readConcern;
    private final ReadPreference readPreference;
    private final boolean retryReads;
    private final boolean retryWrites;
    @Nullable
    private final ServerApi serverApi;
    private final ServerSessionPool serverSessionPool;
    private final TimeoutSettings timeoutSettings;
    private final UuidRepresentation uuidRepresentation;
    private final WriteConcern writeConcern;
    private final SyncOperations<BsonDocument> operations;

    MongoClusterImpl(@Nullable AutoEncryptionSettings autoEncryptionSettings, Cluster cluster, CodecRegistry codecRegistry, @Nullable SynchronousContextProvider synchronousContextProvider, @Nullable Crypt crypt, Object object, @Nullable OperationExecutor operationExecutor, ReadConcern readConcern, ReadPreference readPreference, boolean bl, boolean bl2, @Nullable ServerApi serverApi, ServerSessionPool serverSessionPool, TimeoutSettings timeoutSettings, UuidRepresentation uuidRepresentation, WriteConcern writeConcern) {
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.cluster = cluster;
        this.codecRegistry = codecRegistry;
        this.contextProvider = synchronousContextProvider;
        this.crypt = crypt;
        this.originator = object;
        this.operationExecutor = operationExecutor != null ? operationExecutor : new OperationExecutorImpl(timeoutSettings);
        this.readConcern = readConcern;
        this.readPreference = readPreference;
        this.retryReads = bl;
        this.retryWrites = bl2;
        this.serverApi = serverApi;
        this.serverSessionPool = serverSessionPool;
        this.timeoutSettings = timeoutSettings;
        this.uuidRepresentation = uuidRepresentation;
        this.writeConcern = writeConcern;
        this.operations = new SyncOperations<BsonDocument>(null, BsonDocument.class, readPreference, codecRegistry, readConcern, writeConcern, bl2, bl, timeoutSettings);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        Long l = this.timeoutSettings.getTimeoutMS();
        return l == null ? null : Long.valueOf(timeUnit.convert(l, TimeUnit.MILLISECONDS));
    }

    @Override
    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern);
    }

    @Override
    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern);
    }

    @Override
    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, writeConcern);
    }

    @Override
    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern);
    }

    @Override
    public MongoCluster withTimeout(long l, TimeUnit timeUnit) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings.withTimeout(l, timeUnit), this.uuidRepresentation, this.writeConcern);
    }

    @Override
    public MongoDatabase getDatabase(String string) {
        return new MongoDatabaseImpl(string, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.operationExecutor);
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    @Nullable
    public Crypt getCrypt() {
        return this.crypt;
    }

    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    @Override
    public ClientSession startSession() {
        return this.startSession(ClientSessionOptions.builder().defaultTransactionOptions(TransactionOptions.builder().readConcern(this.readConcern).writeConcern(this.writeConcern).build()).build());
    }

    @Override
    public ClientSession startSession(ClientSessionOptions clientSessionOptions) {
        Assertions.notNull("options", clientSessionOptions);
        ClientSessionOptions clientSessionOptions2 = ClientSessionOptions.builder(clientSessionOptions).defaultTransactionOptions(TransactionOptions.merge(clientSessionOptions.getDefaultTransactionOptions(), TransactionOptions.builder().readConcern(this.readConcern).writeConcern(this.writeConcern).readPreference(this.readPreference).build())).build();
        return new ClientSessionImpl(this.serverSessionPool, this.originator, clientSessionOptions2, this.operationExecutor);
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> clazz) {
        return this.createListDatabasesIterable(null, clazz);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession clientSession, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabasesIterable(clientSession, clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> clazz) {
        return this.watch(Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> list) {
        return this.watch(list, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> list, Class<TResult> clazz) {
        return this.createChangeStreamIterable(null, list, clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> clazz) {
        return this.watch(clientSession, Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> list) {
        return this.watch(clientSession, list, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, list, clazz);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> list) throws ClientBulkWriteException {
        Assertions.notNull("clientWriteModels", list);
        Assertions.isTrueArgument("`clientWriteModels` must not be empty", !list.isEmpty());
        return this.executeBulkWrite(null, list, null);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> list, ClientBulkWriteOptions clientBulkWriteOptions) throws ClientBulkWriteException {
        Assertions.notNull("clientWriteModels", list);
        Assertions.isTrueArgument("`clientWriteModels` must not be empty", !list.isEmpty());
        Assertions.notNull("options", clientBulkWriteOptions);
        return this.executeBulkWrite(null, list, clientBulkWriteOptions);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> list) throws ClientBulkWriteException {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("clientWriteModels", list);
        Assertions.isTrueArgument("`clientWriteModels` must not be empty", !list.isEmpty());
        return this.executeBulkWrite(clientSession, list, null);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> list, ClientBulkWriteOptions clientBulkWriteOptions) throws ClientBulkWriteException {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("clientWriteModels", list);
        Assertions.isTrueArgument("`clientWriteModels` must not be empty", !list.isEmpty());
        Assertions.notNull("options", clientBulkWriteOptions);
        return this.executeBulkWrite(clientSession, list, clientBulkWriteOptions);
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(@Nullable ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.codecRegistry, ReadPreference.primary(), this.operationExecutor, this.retryReads, this.timeoutSettings);
    }

    private MongoIterable<String> createListDatabaseNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(bsonDocument -> bsonDocument.getString("name").getValue());
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, "admin", this.codecRegistry, this.readPreference, this.readConcern, this.operationExecutor, list, clazz, ChangeStreamLevel.CLIENT, this.retryReads, this.timeoutSettings);
    }

    private ClientBulkWriteResult executeBulkWrite(@Nullable ClientSession clientSession, List<? extends ClientNamespacedWriteModel> list, @Nullable ClientBulkWriteOptions clientBulkWriteOptions) {
        Assertions.isTrue("`autoEncryptionSettings` is null, as bulkWrite does not currently support automatic encryption", this.autoEncryptionSettings == null);
        return this.operationExecutor.execute(this.operations.clientBulkWriteOperation(list, clientBulkWriteOptions), this.readConcern, clientSession);
    }

    final class OperationExecutorImpl
    implements OperationExecutor {
        private final TimeoutSettings executorTimeoutSettings;

        OperationExecutorImpl(TimeoutSettings timeoutSettings) {
            this.executorTimeoutSettings = timeoutSettings;
        }

        @Override
        public <T> T execute(ReadOperation<T> readOperation, ReadPreference readPreference, ReadConcern readConcern) {
            return this.execute(readOperation, readPreference, readConcern, null);
        }

        @Override
        public <T> T execute(WriteOperation<T> writeOperation, ReadConcern readConcern) {
            return this.execute(writeOperation, readConcern, null);
        }

        @Override
        public <T> T execute(ReadOperation<T> readOperation, ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession clientSession) {
            if (clientSession != null) {
                clientSession.notifyOperationInitiated(readOperation);
            }
            ClientSession clientSession2 = this.getClientSession(clientSession);
            ReadBinding readBinding = this.getReadBinding(readPreference, readConcern, clientSession2, clientSession == null);
            try {
                if (clientSession2.hasActiveTransaction() && !readBinding.getReadPreference().equals(ReadPreference.primary())) {
                    throw new MongoClientException("Read preference in a transaction must be primary");
                }
                T t = readOperation.execute(readBinding);
                return t;
            }
            catch (MongoException mongoException) {
                MongoException mongoException2 = OperationHelper.unwrap(mongoException);
                this.labelException(clientSession2, mongoException2);
                this.clearTransactionContextOnTransientTransactionError(clientSession, mongoException2);
                throw mongoException;
            }
            finally {
                readBinding.release();
            }
        }

        @Override
        public <T> T execute(WriteOperation<T> writeOperation, ReadConcern readConcern, @Nullable ClientSession clientSession) {
            if (clientSession != null) {
                clientSession.notifyOperationInitiated(writeOperation);
            }
            ClientSession clientSession2 = this.getClientSession(clientSession);
            WriteBinding writeBinding = this.getWriteBinding(readConcern, clientSession2, clientSession == null);
            try {
                T t = writeOperation.execute(writeBinding);
                return t;
            }
            catch (MongoException mongoException) {
                MongoException mongoException2 = OperationHelper.unwrap(mongoException);
                this.labelException(clientSession2, mongoException2);
                this.clearTransactionContextOnTransientTransactionError(clientSession, mongoException2);
                throw mongoException;
            }
            finally {
                writeBinding.release();
            }
        }

        @Override
        public OperationExecutor withTimeoutSettings(TimeoutSettings timeoutSettings) {
            if (Objects.equals(this.executorTimeoutSettings, timeoutSettings)) {
                return this;
            }
            return new OperationExecutorImpl(timeoutSettings);
        }

        @Override
        public TimeoutSettings getTimeoutSettings() {
            return this.executorTimeoutSettings;
        }

        WriteBinding getWriteBinding(ReadConcern readConcern, ClientSession clientSession, boolean bl) {
            return this.getReadWriteBinding(ReadPreference.primary(), readConcern, clientSession, bl);
        }

        ReadBinding getReadBinding(ReadPreference readPreference, ReadConcern readConcern, ClientSession clientSession, boolean bl) {
            return this.getReadWriteBinding(readPreference, readConcern, clientSession, bl);
        }

        ReadWriteBinding getReadWriteBinding(ReadPreference readPreference, ReadConcern readConcern, ClientSession clientSession, boolean bl) {
            ClusterAwareReadWriteBinding clusterAwareReadWriteBinding = new ClusterBinding(MongoClusterImpl.this.cluster, this.getReadPreferenceForBinding(readPreference, clientSession), readConcern, this.getOperationContext(clientSession, readConcern));
            if (MongoClusterImpl.this.crypt != null) {
                clusterAwareReadWriteBinding = new CryptBinding(clusterAwareReadWriteBinding, MongoClusterImpl.this.crypt);
            }
            return new ClientSessionBinding(clientSession, bl, clusterAwareReadWriteBinding);
        }

        private OperationContext getOperationContext(ClientSession clientSession, ReadConcern readConcern) {
            return new OperationContext(this.getRequestContext(), new ReadConcernAwareNoOpSessionContext(readConcern), TimeoutContext.createTimeoutContext(clientSession, this.executorTimeoutSettings), MongoClusterImpl.this.serverApi);
        }

        private RequestContext getRequestContext() {
            RequestContext requestContext = null;
            if (MongoClusterImpl.this.contextProvider != null) {
                requestContext = MongoClusterImpl.this.contextProvider.getContext();
            }
            return requestContext == null ? IgnorableRequestContext.INSTANCE : requestContext;
        }

        private void labelException(ClientSession clientSession, MongoException mongoException) {
            if (clientSession.hasActiveTransaction() && (mongoException instanceof MongoSocketException || mongoException instanceof MongoTimeoutException || mongoException instanceof MongoQueryException && mongoException.getCode() == 91) && !mongoException.hasErrorLabel("UnknownTransactionCommitResult")) {
                mongoException.addLabel("TransientTransactionError");
            }
        }

        private void clearTransactionContextOnTransientTransactionError(@Nullable ClientSession clientSession, MongoException mongoException) {
            if (clientSession != null && mongoException.hasErrorLabel("TransientTransactionError")) {
                clientSession.clearTransactionContext();
            }
        }

        private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession clientSession) {
            if (clientSession == null) {
                return readPreference;
            }
            if (clientSession.hasActiveTransaction()) {
                ReadPreference readPreference2 = clientSession.getTransactionOptions().getReadPreference();
                if (readPreference2 == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
                }
                return readPreference2;
            }
            return readPreference;
        }

        ClientSession getClientSession(@Nullable ClientSession clientSession) {
            ClientSession clientSession2;
            if (clientSession != null) {
                Assertions.isTrue("ClientSession from same MongoClient", clientSession.getOriginator() == MongoClusterImpl.this.originator);
                clientSession2 = clientSession;
            } else {
                clientSession2 = MongoClusterImpl.this.startSession(ClientSessionOptions.builder().causallyConsistent(false).defaultTransactionOptions(TransactionOptions.builder().readConcern(ReadConcern.DEFAULT).readPreference(ReadPreference.primary()).writeConcern(WriteConcern.ACKNOWLEDGED).build()).build());
            }
            return clientSession2;
        }
    }
}

