/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.ListSearchIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.internal.AggregateIterableImpl;
import com.mongodb.client.internal.ChangeStreamIterableImpl;
import com.mongodb.client.internal.DistinctIterableImpl;
import com.mongodb.client.internal.FindIterableImpl;
import com.mongodb.client.internal.ListIndexesIterableImpl;
import com.mongodb.client.internal.ListSearchIndexesIterableImpl;
import com.mongodb.client.internal.MapReduceIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.IndexHelper;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;
    private final ReadConcern readConcern;
    private final SyncOperations<TDocument> operations;
    private final UuidRepresentation uuidRepresentation;
    @Nullable
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final TimeoutSettings timeoutSettings;
    private final OperationExecutor executor;

    MongoCollectionImpl(MongoNamespace mongoNamespace, Class<TDocument> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean bl, boolean bl2, ReadConcern readConcern, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, TimeoutSettings timeoutSettings, OperationExecutor operationExecutor) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.documentClass = Assertions.notNull("documentClass", clazz);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = bl;
        this.retryReads = bl2;
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.executor = Assertions.notNull("executor", operationExecutor);
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.timeoutSettings = timeoutSettings;
        this.operations = new SyncOperations<TDocument>(mongoNamespace, clazz, readPreference, codecRegistry, readConcern, writeConcern, bl, bl2, timeoutSettings);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.documentClass;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        Long l = this.timeoutSettings.getTimeoutMS();
        return l == null ? null : Long.valueOf(Assertions.notNull("timeUnit", timeUnit).convert(l, TimeUnit.MILLISECONDS));
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new MongoCollectionImpl<NewTDocument>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, CodecRegistries.withUuidRepresentation(codecRegistry, this.uuidRepresentation), this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withTimeout(long l, TimeUnit timeUnit) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings.withTimeout(l, timeUnit), this.executor);
    }

    @Override
    public long countDocuments() {
        return this.countDocuments(new BsonDocument());
    }

    @Override
    public long countDocuments(Bson bson) {
        return this.countDocuments(bson, new CountOptions());
    }

    @Override
    public long countDocuments(Bson bson, CountOptions countOptions) {
        return this.executeCount(null, bson, countOptions);
    }

    @Override
    public long countDocuments(ClientSession clientSession) {
        return this.countDocuments(clientSession, new BsonDocument());
    }

    @Override
    public long countDocuments(ClientSession clientSession, Bson bson) {
        return this.countDocuments(clientSession, bson, new CountOptions());
    }

    @Override
    public long countDocuments(ClientSession clientSession, Bson bson, CountOptions countOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeCount(clientSession, bson, countOptions);
    }

    @Override
    public long estimatedDocumentCount() {
        return this.estimatedDocumentCount(new EstimatedDocumentCountOptions());
    }

    @Override
    public long estimatedDocumentCount(EstimatedDocumentCountOptions estimatedDocumentCountOptions) {
        return this.getExecutor(this.operations.createTimeoutSettings(estimatedDocumentCountOptions)).execute(this.operations.estimatedDocumentCount(estimatedDocumentCountOptions), this.readPreference, this.readConcern, null);
    }

    private long executeCount(@Nullable ClientSession clientSession, Bson bson, CountOptions countOptions) {
        return this.getExecutor(this.operations.createTimeoutSettings(countOptions)).execute(this.operations.countDocuments(bson, countOptions), this.readPreference, this.readConcern, clientSession);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String string, Class<TResult> clazz) {
        return this.distinct(string, new BsonDocument(), clazz);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String string, Bson bson, Class<TResult> clazz) {
        return this.createDistinctIterable(null, string, bson, clazz);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String string, Class<TResult> clazz) {
        return this.distinct(clientSession, string, new BsonDocument(), clazz);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String string, Bson bson, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createDistinctIterable(clientSession, string, bson, clazz);
    }

    private <TResult> DistinctIterable<TResult> createDistinctIterable(@Nullable ClientSession clientSession, String string, Bson bson, Class<TResult> clazz) {
        return new DistinctIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, clazz, this.codecRegistry, this.readPreference, this.readConcern, this.executor, string, bson, this.retryReads, this.timeoutSettings);
    }

    @Override
    public FindIterable<TDocument> find() {
        return this.find(new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Class<TResult> clazz) {
        return this.find(new BsonDocument(), clazz);
    }

    @Override
    public FindIterable<TDocument> find(Bson bson) {
        return this.find(bson, this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Bson bson, Class<TResult> clazz) {
        return this.createFindIterable(null, bson, clazz);
    }

    @Override
    public FindIterable<TDocument> find(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.find(clientSession, new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.find(clientSession, new BsonDocument(), clazz);
    }

    @Override
    public FindIterable<TDocument> find(ClientSession clientSession, Bson bson) {
        Assertions.notNull("clientSession", clientSession);
        return this.find(clientSession, bson, this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Bson bson, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createFindIterable(clientSession, bson, clazz);
    }

    private <TResult> FindIterable<TResult> createFindIterable(@Nullable ClientSession clientSession, Bson bson, Class<TResult> clazz) {
        return new FindIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, clazz, this.codecRegistry, this.readPreference, this.readConcern, this.executor, bson, this.retryReads, this.timeoutSettings);
    }

    @Override
    public AggregateIterable<TDocument> aggregate(List<? extends Bson> list) {
        return this.aggregate(list, this.documentClass);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> list, Class<TResult> clazz) {
        return this.createAggregateIterable(null, list, clazz);
    }

    @Override
    public AggregateIterable<TDocument> aggregate(ClientSession clientSession, List<? extends Bson> list) {
        return this.aggregate(clientSession, list, this.documentClass);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createAggregateIterable(clientSession, list, clazz);
    }

    private <TResult> AggregateIterable<TResult> createAggregateIterable(@Nullable ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        return new AggregateIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, clazz, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, list, AggregationLevel.COLLECTION, this.retryReads, this.timeoutSettings);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> clazz) {
        return this.watch(Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(List<? extends Bson> list) {
        return this.watch(list, this.documentClass);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> list, Class<TResult> clazz) {
        return this.createChangeStreamIterable(null, list, clazz);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), this.documentClass);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> clazz) {
        return this.watch(clientSession, Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession, List<? extends Bson> list) {
        return this.watch(clientSession, list, this.documentClass);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, list, clazz);
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, this.namespace, this.codecRegistry, this.readPreference, this.readConcern, this.executor, list, clazz, ChangeStreamLevel.COLLECTION, this.retryReads, this.timeoutSettings);
    }

    @Override
    public MapReduceIterable<TDocument> mapReduce(String string, String string2) {
        return this.mapReduce(string, string2, this.documentClass);
    }

    @Override
    public <TResult> MapReduceIterable<TResult> mapReduce(String string, String string2, Class<TResult> clazz) {
        return this.createMapReduceIterable(null, string, string2, clazz);
    }

    @Override
    public MapReduceIterable<TDocument> mapReduce(ClientSession clientSession, String string, String string2) {
        return this.mapReduce(clientSession, string, string2, this.documentClass);
    }

    @Override
    public <TResult> MapReduceIterable<TResult> mapReduce(ClientSession clientSession, String string, String string2, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createMapReduceIterable(clientSession, string, string2, clazz);
    }

    private <TResult> MapReduceIterable<TResult> createMapReduceIterable(@Nullable ClientSession clientSession, String string, String string2, Class<TResult> clazz) {
        return new MapReduceIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, clazz, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, string, string2, this.timeoutSettings);
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> list) {
        return this.bulkWrite(list, new BulkWriteOptions());
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> list, BulkWriteOptions bulkWriteOptions) {
        return this.executeBulkWrite(null, list, bulkWriteOptions);
    }

    @Override
    public BulkWriteResult bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> list) {
        return this.bulkWrite(clientSession, list, new BulkWriteOptions());
    }

    @Override
    public BulkWriteResult bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> list, BulkWriteOptions bulkWriteOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeBulkWrite(clientSession, list, bulkWriteOptions);
    }

    private BulkWriteResult executeBulkWrite(@Nullable ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> list, BulkWriteOptions bulkWriteOptions) {
        Assertions.notNull("requests", list);
        return this.getExecutor(this.timeoutSettings).execute(this.operations.bulkWrite(list, bulkWriteOptions), this.readConcern, clientSession);
    }

    @Override
    public InsertOneResult insertOne(TDocument TDocument) {
        return this.insertOne(TDocument, new InsertOneOptions());
    }

    @Override
    public InsertOneResult insertOne(TDocument TDocument, InsertOneOptions insertOneOptions) {
        Assertions.notNull("document", TDocument);
        return this.executeInsertOne(null, TDocument, insertOneOptions);
    }

    @Override
    public InsertOneResult insertOne(ClientSession clientSession, TDocument TDocument) {
        return this.insertOne(clientSession, TDocument, new InsertOneOptions());
    }

    @Override
    public InsertOneResult insertOne(ClientSession clientSession, TDocument TDocument, InsertOneOptions insertOneOptions) {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("document", TDocument);
        return this.executeInsertOne(clientSession, TDocument, insertOneOptions);
    }

    private InsertOneResult executeInsertOne(@Nullable ClientSession clientSession, TDocument TDocument, InsertOneOptions insertOneOptions) {
        return this.toInsertOneResult(this.executeSingleWriteRequest(clientSession, this.operations.insertOne(TDocument, insertOneOptions), WriteRequest.Type.INSERT));
    }

    @Override
    public InsertManyResult insertMany(List<? extends TDocument> list) {
        return this.insertMany(list, new InsertManyOptions());
    }

    @Override
    public InsertManyResult insertMany(List<? extends TDocument> list, InsertManyOptions insertManyOptions) {
        return this.executeInsertMany(null, list, insertManyOptions);
    }

    @Override
    public InsertManyResult insertMany(ClientSession clientSession, List<? extends TDocument> list) {
        return this.insertMany(clientSession, list, new InsertManyOptions());
    }

    @Override
    public InsertManyResult insertMany(ClientSession clientSession, List<? extends TDocument> list, InsertManyOptions insertManyOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeInsertMany(clientSession, list, insertManyOptions);
    }

    private InsertManyResult executeInsertMany(@Nullable ClientSession clientSession, List<? extends TDocument> list, InsertManyOptions insertManyOptions) {
        return this.toInsertManyResult(this.getExecutor(this.timeoutSettings).execute(this.operations.insertMany(list, insertManyOptions), this.readConcern, clientSession));
    }

    @Override
    public DeleteResult deleteOne(Bson bson) {
        return this.deleteOne(bson, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteOne(Bson bson, DeleteOptions deleteOptions) {
        return this.executeDelete(null, bson, deleteOptions, false);
    }

    @Override
    public DeleteResult deleteOne(ClientSession clientSession, Bson bson) {
        return this.deleteOne(clientSession, bson, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteOne(ClientSession clientSession, Bson bson, DeleteOptions deleteOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeDelete(clientSession, bson, deleteOptions, false);
    }

    @Override
    public DeleteResult deleteMany(Bson bson) {
        return this.deleteMany(bson, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteMany(Bson bson, DeleteOptions deleteOptions) {
        return this.executeDelete(null, bson, deleteOptions, true);
    }

    @Override
    public DeleteResult deleteMany(ClientSession clientSession, Bson bson) {
        return this.deleteMany(clientSession, bson, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteMany(ClientSession clientSession, Bson bson, DeleteOptions deleteOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeDelete(clientSession, bson, deleteOptions, true);
    }

    @Override
    public UpdateResult replaceOne(Bson bson, TDocument TDocument) {
        return this.replaceOne(bson, TDocument, new ReplaceOptions());
    }

    @Override
    public UpdateResult replaceOne(Bson bson, TDocument TDocument, ReplaceOptions replaceOptions) {
        return this.executeReplaceOne(null, bson, TDocument, replaceOptions);
    }

    @Override
    public UpdateResult replaceOne(ClientSession clientSession, Bson bson, TDocument TDocument) {
        return this.replaceOne(clientSession, bson, TDocument, new ReplaceOptions());
    }

    @Override
    public UpdateResult replaceOne(ClientSession clientSession, Bson bson, TDocument TDocument, ReplaceOptions replaceOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeReplaceOne(clientSession, bson, TDocument, replaceOptions);
    }

    private UpdateResult executeReplaceOne(@Nullable ClientSession clientSession, Bson bson, TDocument TDocument, ReplaceOptions replaceOptions) {
        return this.toUpdateResult(this.executeSingleWriteRequest(clientSession, this.operations.replaceOne(bson, TDocument, replaceOptions), WriteRequest.Type.REPLACE));
    }

    @Override
    public UpdateResult updateOne(Bson bson, Bson bson2) {
        return this.updateOne(bson, bson2, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(Bson bson, Bson bson2, UpdateOptions updateOptions) {
        return this.executeUpdate(null, bson, bson2, updateOptions, false);
    }

    @Override
    public UpdateResult updateOne(ClientSession clientSession, Bson bson, Bson bson2) {
        return this.updateOne(clientSession, bson, bson2, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(ClientSession clientSession, Bson bson, Bson bson2, UpdateOptions updateOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeUpdate(clientSession, bson, bson2, updateOptions, false);
    }

    @Override
    public UpdateResult updateOne(Bson bson, List<? extends Bson> list) {
        return this.updateOne(bson, list, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        return this.executeUpdate(null, bson, list, updateOptions, false);
    }

    @Override
    public UpdateResult updateOne(ClientSession clientSession, Bson bson, List<? extends Bson> list) {
        return this.updateOne(clientSession, bson, list, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(ClientSession clientSession, Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeUpdate(clientSession, bson, list, updateOptions, false);
    }

    @Override
    public UpdateResult updateMany(Bson bson, Bson bson2) {
        return this.updateMany(bson, bson2, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(Bson bson, Bson bson2, UpdateOptions updateOptions) {
        return this.executeUpdate(null, bson, bson2, updateOptions, true);
    }

    @Override
    public UpdateResult updateMany(ClientSession clientSession, Bson bson, Bson bson2) {
        return this.updateMany(clientSession, bson, bson2, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(ClientSession clientSession, Bson bson, Bson bson2, UpdateOptions updateOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeUpdate(clientSession, bson, bson2, updateOptions, true);
    }

    @Override
    public UpdateResult updateMany(Bson bson, List<? extends Bson> list) {
        return this.updateMany(bson, list, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        return this.executeUpdate(null, bson, list, updateOptions, true);
    }

    @Override
    public UpdateResult updateMany(ClientSession clientSession, Bson bson, List<? extends Bson> list) {
        return this.updateMany(clientSession, bson, list, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(ClientSession clientSession, Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeUpdate(clientSession, bson, list, updateOptions, true);
    }

    @Override
    @Nullable
    public TDocument findOneAndDelete(Bson bson) {
        return this.findOneAndDelete(bson, new FindOneAndDeleteOptions());
    }

    @Override
    @Nullable
    public TDocument findOneAndDelete(Bson bson, FindOneAndDeleteOptions findOneAndDeleteOptions) {
        return this.executeFindOneAndDelete(null, bson, findOneAndDeleteOptions);
    }

    @Override
    @Nullable
    public TDocument findOneAndDelete(ClientSession clientSession, Bson bson) {
        return this.findOneAndDelete(clientSession, bson, new FindOneAndDeleteOptions());
    }

    @Override
    @Nullable
    public TDocument findOneAndDelete(ClientSession clientSession, Bson bson, FindOneAndDeleteOptions findOneAndDeleteOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeFindOneAndDelete(clientSession, bson, findOneAndDeleteOptions);
    }

    @Nullable
    private TDocument executeFindOneAndDelete(@Nullable ClientSession clientSession, Bson bson, FindOneAndDeleteOptions findOneAndDeleteOptions) {
        return this.getExecutor(this.operations.createTimeoutSettings(findOneAndDeleteOptions)).execute(this.operations.findOneAndDelete(bson, findOneAndDeleteOptions), this.readConcern, clientSession);
    }

    @Override
    @Nullable
    public TDocument findOneAndReplace(Bson bson, TDocument TDocument) {
        return this.findOneAndReplace(bson, TDocument, new FindOneAndReplaceOptions());
    }

    @Override
    @Nullable
    public TDocument findOneAndReplace(Bson bson, TDocument TDocument, FindOneAndReplaceOptions findOneAndReplaceOptions) {
        return this.executeFindOneAndReplace(null, bson, TDocument, findOneAndReplaceOptions);
    }

    @Override
    @Nullable
    public TDocument findOneAndReplace(ClientSession clientSession, Bson bson, TDocument TDocument) {
        return this.findOneAndReplace(clientSession, bson, TDocument, new FindOneAndReplaceOptions());
    }

    @Override
    @Nullable
    public TDocument findOneAndReplace(ClientSession clientSession, Bson bson, TDocument TDocument, FindOneAndReplaceOptions findOneAndReplaceOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeFindOneAndReplace(clientSession, bson, TDocument, findOneAndReplaceOptions);
    }

    @Nullable
    private TDocument executeFindOneAndReplace(@Nullable ClientSession clientSession, Bson bson, TDocument TDocument, FindOneAndReplaceOptions findOneAndReplaceOptions) {
        return this.getExecutor(this.operations.createTimeoutSettings(findOneAndReplaceOptions)).execute(this.operations.findOneAndReplace(bson, TDocument, findOneAndReplaceOptions), this.readConcern, clientSession);
    }

    @Override
    @Nullable
    public TDocument findOneAndUpdate(Bson bson, Bson bson2) {
        return this.findOneAndUpdate(bson, bson2, new FindOneAndUpdateOptions());
    }

    @Override
    @Nullable
    public TDocument findOneAndUpdate(Bson bson, Bson bson2, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return this.executeFindOneAndUpdate(null, bson, bson2, findOneAndUpdateOptions);
    }

    @Override
    @Nullable
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson bson, Bson bson2) {
        return this.findOneAndUpdate(clientSession, bson, bson2, new FindOneAndUpdateOptions());
    }

    @Override
    @Nullable
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson bson, Bson bson2, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeFindOneAndUpdate(clientSession, bson, bson2, findOneAndUpdateOptions);
    }

    @Nullable
    private TDocument executeFindOneAndUpdate(@Nullable ClientSession clientSession, Bson bson, Bson bson2, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return this.getExecutor(this.operations.createTimeoutSettings(findOneAndUpdateOptions)).execute(this.operations.findOneAndUpdate(bson, bson2, findOneAndUpdateOptions), this.readConcern, clientSession);
    }

    @Override
    @Nullable
    public TDocument findOneAndUpdate(Bson bson, List<? extends Bson> list) {
        return this.findOneAndUpdate(bson, list, new FindOneAndUpdateOptions());
    }

    @Override
    @Nullable
    public TDocument findOneAndUpdate(Bson bson, List<? extends Bson> list, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return this.executeFindOneAndUpdate(null, bson, list, findOneAndUpdateOptions);
    }

    @Override
    @Nullable
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson bson, List<? extends Bson> list) {
        return this.findOneAndUpdate(clientSession, bson, list, new FindOneAndUpdateOptions());
    }

    @Override
    @Nullable
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson bson, List<? extends Bson> list, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeFindOneAndUpdate(clientSession, bson, list, findOneAndUpdateOptions);
    }

    @Nullable
    private TDocument executeFindOneAndUpdate(@Nullable ClientSession clientSession, Bson bson, List<? extends Bson> list, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return this.getExecutor(this.operations.createTimeoutSettings(findOneAndUpdateOptions)).execute(this.operations.findOneAndUpdate(bson, list, findOneAndUpdateOptions), this.readConcern, clientSession);
    }

    @Override
    public void drop() {
        this.executeDrop(null, new DropCollectionOptions());
    }

    @Override
    public void drop(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDrop(clientSession, new DropCollectionOptions());
    }

    @Override
    public void drop(DropCollectionOptions dropCollectionOptions) {
        this.executeDrop(null, dropCollectionOptions);
    }

    @Override
    public void drop(ClientSession clientSession, DropCollectionOptions dropCollectionOptions) {
        this.executeDrop(clientSession, dropCollectionOptions);
    }

    @Override
    public String createSearchIndex(String string, Bson bson) {
        Assertions.notNull("indexName", string);
        Assertions.notNull("definition", bson);
        return this.executeCreateSearchIndexes(Collections.singletonList(new SearchIndexModel(string, bson))).get(0);
    }

    @Override
    public String createSearchIndex(Bson bson) {
        Assertions.notNull("definition", bson);
        return this.executeCreateSearchIndexes(Collections.singletonList(new SearchIndexModel(bson))).get(0);
    }

    @Override
    public List<String> createSearchIndexes(List<SearchIndexModel> list) {
        Assertions.notNullElements("searchIndexModels", list);
        return this.executeCreateSearchIndexes(list);
    }

    @Override
    public void updateSearchIndex(String string, Bson bson) {
        Assertions.notNull("indexName", string);
        Assertions.notNull("definition", bson);
        this.getExecutor(this.timeoutSettings).execute(this.operations.updateSearchIndex(string, bson), this.readConcern, null);
    }

    @Override
    public void dropSearchIndex(String string) {
        Assertions.notNull("indexName", string);
        this.getExecutor(this.timeoutSettings).execute(this.operations.dropSearchIndex(string), this.readConcern, null);
    }

    @Override
    public ListSearchIndexesIterable<Document> listSearchIndexes() {
        return this.createListSearchIndexesIterable(Document.class);
    }

    @Override
    public <TResult> ListSearchIndexesIterable<TResult> listSearchIndexes(Class<TResult> clazz) {
        Assertions.notNull("resultClass", clazz);
        return this.createListSearchIndexesIterable(clazz);
    }

    private void executeDrop(@Nullable ClientSession clientSession, DropCollectionOptions dropCollectionOptions) {
        this.getExecutor(this.timeoutSettings).execute(this.operations.dropCollection(dropCollectionOptions, this.autoEncryptionSettings), this.readConcern, clientSession);
    }

    @Override
    public String createIndex(Bson bson) {
        return this.createIndex(bson, new IndexOptions());
    }

    @Override
    public String createIndex(Bson bson, IndexOptions indexOptions) {
        return this.createIndexes(Collections.singletonList(new IndexModel(bson, indexOptions))).get(0);
    }

    @Override
    public String createIndex(ClientSession clientSession, Bson bson) {
        return this.createIndex(clientSession, bson, new IndexOptions());
    }

    @Override
    public String createIndex(ClientSession clientSession, Bson bson, IndexOptions indexOptions) {
        return this.createIndexes(clientSession, Collections.singletonList(new IndexModel(bson, indexOptions))).get(0);
    }

    @Override
    public List<String> createIndexes(List<IndexModel> list) {
        return this.createIndexes(list, new CreateIndexOptions());
    }

    @Override
    public List<String> createIndexes(List<IndexModel> list, CreateIndexOptions createIndexOptions) {
        return this.executeCreateIndexes(null, list, createIndexOptions);
    }

    @Override
    public List<String> createIndexes(ClientSession clientSession, List<IndexModel> list) {
        return this.createIndexes(clientSession, list, new CreateIndexOptions());
    }

    @Override
    public List<String> createIndexes(ClientSession clientSession, List<IndexModel> list, CreateIndexOptions createIndexOptions) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeCreateIndexes(clientSession, list, createIndexOptions);
    }

    private List<String> executeCreateIndexes(@Nullable ClientSession clientSession, List<IndexModel> list, CreateIndexOptions createIndexOptions) {
        this.getExecutor(this.operations.createTimeoutSettings(createIndexOptions)).execute(this.operations.createIndexes(list, createIndexOptions), this.readConcern, clientSession);
        return IndexHelper.getIndexNames(list, this.codecRegistry);
    }

    private List<String> executeCreateSearchIndexes(List<SearchIndexModel> list) {
        this.getExecutor(this.timeoutSettings).execute(this.operations.createSearchIndexes(list), this.readConcern, null);
        return IndexHelper.getSearchIndexNames(list);
    }

    @Override
    public ListIndexesIterable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> clazz) {
        return this.createListIndexesIterable(null, clazz);
    }

    @Override
    public ListIndexesIterable<Document> listIndexes(ClientSession clientSession) {
        return this.listIndexes(clientSession, Document.class);
    }

    @Override
    public <TResult> ListIndexesIterable<TResult> listIndexes(ClientSession clientSession, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListIndexesIterable(clientSession, clazz);
    }

    private <TResult> ListIndexesIterable<TResult> createListIndexesIterable(@Nullable ClientSession clientSession, Class<TResult> clazz) {
        return new ListIndexesIterableImpl<TResult>(clientSession, this.getNamespace(), clazz, this.codecRegistry, ReadPreference.primary(), this.executor, this.retryReads, this.timeoutSettings);
    }

    private <TResult> ListSearchIndexesIterable<TResult> createListSearchIndexesIterable(Class<TResult> clazz) {
        return new ListSearchIndexesIterableImpl<TResult>(this.getNamespace(), this.executor, clazz, this.codecRegistry, this.readPreference, this.retryReads, this.timeoutSettings);
    }

    @Override
    public void dropIndex(String string) {
        this.dropIndex(string, new DropIndexOptions());
    }

    @Override
    public void dropIndex(String string, DropIndexOptions dropIndexOptions) {
        this.executeDropIndex(null, string, dropIndexOptions);
    }

    @Override
    public void dropIndex(Bson bson) {
        this.dropIndex(bson, new DropIndexOptions());
    }

    @Override
    public void dropIndex(Bson bson, DropIndexOptions dropIndexOptions) {
        this.executeDropIndex(null, bson, dropIndexOptions);
    }

    @Override
    public void dropIndex(ClientSession clientSession, String string) {
        this.dropIndex(clientSession, string, new DropIndexOptions());
    }

    @Override
    public void dropIndex(ClientSession clientSession, Bson bson) {
        this.dropIndex(clientSession, bson, new DropIndexOptions());
    }

    @Override
    public void dropIndex(ClientSession clientSession, String string, DropIndexOptions dropIndexOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDropIndex(clientSession, string, dropIndexOptions);
    }

    @Override
    public void dropIndex(ClientSession clientSession, Bson bson, DropIndexOptions dropIndexOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDropIndex(clientSession, bson, dropIndexOptions);
    }

    @Override
    public void dropIndexes() {
        this.dropIndex("*");
    }

    @Override
    public void dropIndexes(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDropIndex(clientSession, "*", new DropIndexOptions());
    }

    @Override
    public void dropIndexes(DropIndexOptions dropIndexOptions) {
        this.dropIndex("*", dropIndexOptions);
    }

    @Override
    public void dropIndexes(ClientSession clientSession, DropIndexOptions dropIndexOptions) {
        this.dropIndex(clientSession, "*", dropIndexOptions);
    }

    private void executeDropIndex(@Nullable ClientSession clientSession, String string, DropIndexOptions dropIndexOptions) {
        Assertions.notNull("options", dropIndexOptions);
        this.getExecutor(this.operations.createTimeoutSettings(dropIndexOptions)).execute(this.operations.dropIndex(string, dropIndexOptions), this.readConcern, clientSession);
    }

    private void executeDropIndex(@Nullable ClientSession clientSession, Bson bson, DropIndexOptions dropIndexOptions) {
        Assertions.notNull("options", dropIndexOptions);
        this.getExecutor(this.operations.createTimeoutSettings(dropIndexOptions)).execute(this.operations.dropIndex(bson, dropIndexOptions), this.readConcern, clientSession);
    }

    @Override
    public void renameCollection(MongoNamespace mongoNamespace) {
        this.renameCollection(mongoNamespace, new RenameCollectionOptions());
    }

    @Override
    public void renameCollection(MongoNamespace mongoNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.executeRenameCollection(null, mongoNamespace, renameCollectionOptions);
    }

    @Override
    public void renameCollection(ClientSession clientSession, MongoNamespace mongoNamespace) {
        this.renameCollection(clientSession, mongoNamespace, new RenameCollectionOptions());
    }

    @Override
    public void renameCollection(ClientSession clientSession, MongoNamespace mongoNamespace, RenameCollectionOptions renameCollectionOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.executeRenameCollection(clientSession, mongoNamespace, renameCollectionOptions);
    }

    private void executeRenameCollection(@Nullable ClientSession clientSession, MongoNamespace mongoNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.getExecutor(this.timeoutSettings).execute(this.operations.renameCollection(mongoNamespace, renameCollectionOptions), this.readConcern, clientSession);
    }

    private DeleteResult executeDelete(@Nullable ClientSession clientSession, Bson bson, DeleteOptions deleteOptions, boolean bl) {
        BulkWriteResult bulkWriteResult = this.executeSingleWriteRequest(clientSession, bl ? this.operations.deleteMany(bson, deleteOptions) : this.operations.deleteOne(bson, deleteOptions), WriteRequest.Type.DELETE);
        if (bulkWriteResult.wasAcknowledged()) {
            return DeleteResult.acknowledged(bulkWriteResult.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    }

    private UpdateResult executeUpdate(@Nullable ClientSession clientSession, Bson bson, Bson bson2, UpdateOptions updateOptions, boolean bl) {
        return this.toUpdateResult(this.executeSingleWriteRequest(clientSession, bl ? this.operations.updateMany(bson, bson2, updateOptions) : this.operations.updateOne(bson, bson2, updateOptions), WriteRequest.Type.UPDATE));
    }

    private UpdateResult executeUpdate(@Nullable ClientSession clientSession, Bson bson, List<? extends Bson> list, UpdateOptions updateOptions, boolean bl) {
        return this.toUpdateResult(this.executeSingleWriteRequest(clientSession, bl ? this.operations.updateMany(bson, list, updateOptions) : this.operations.updateOne(bson, list, updateOptions), WriteRequest.Type.UPDATE));
    }

    private BulkWriteResult executeSingleWriteRequest(@Nullable ClientSession clientSession, WriteOperation<BulkWriteResult> writeOperation, WriteRequest.Type type) {
        try {
            return this.getExecutor(this.timeoutSettings).execute(writeOperation, this.readConcern, clientSession);
        }
        catch (MongoBulkWriteException mongoBulkWriteException) {
            if (mongoBulkWriteException.getWriteErrors().isEmpty()) {
                throw new MongoWriteConcernException(mongoBulkWriteException.getWriteConcernError(), this.translateBulkWriteResult(type, mongoBulkWriteException.getWriteResult()), mongoBulkWriteException.getServerAddress(), mongoBulkWriteException.getErrorLabels());
            }
            throw new MongoWriteException(new WriteError(mongoBulkWriteException.getWriteErrors().get(0)), mongoBulkWriteException.getServerAddress(), mongoBulkWriteException.getErrorLabels());
        }
    }

    private WriteConcernResult translateBulkWriteResult(WriteRequest.Type type, BulkWriteResult bulkWriteResult) {
        switch (type) {
            case INSERT: {
                return WriteConcernResult.acknowledged(bulkWriteResult.getInsertedCount(), false, null);
            }
            case DELETE: {
                return WriteConcernResult.acknowledged(bulkWriteResult.getDeletedCount(), false, null);
            }
            case UPDATE: 
            case REPLACE: {
                return WriteConcernResult.acknowledged(bulkWriteResult.getMatchedCount() + bulkWriteResult.getUpserts().size(), bulkWriteResult.getMatchedCount() > 0, bulkWriteResult.getUpserts().isEmpty() ? null : bulkWriteResult.getUpserts().get(0).getId());
            }
        }
        throw new MongoInternalException("Unhandled write request type: " + (Object)((Object)type));
    }

    private InsertOneResult toInsertOneResult(BulkWriteResult bulkWriteResult) {
        if (bulkWriteResult.wasAcknowledged()) {
            BsonValue bsonValue = bulkWriteResult.getInserts().isEmpty() ? null : bulkWriteResult.getInserts().get(0).getId();
            return InsertOneResult.acknowledged(bsonValue);
        }
        return InsertOneResult.unacknowledged();
    }

    private InsertManyResult toInsertManyResult(BulkWriteResult bulkWriteResult) {
        if (bulkWriteResult.wasAcknowledged()) {
            return InsertManyResult.acknowledged(bulkWriteResult.getInserts().stream().collect(HashMap::new, (hashMap, bulkWriteInsert) -> hashMap.put(bulkWriteInsert.getIndex(), bulkWriteInsert.getId()), HashMap::putAll));
        }
        return InsertManyResult.unacknowledged();
    }

    private UpdateResult toUpdateResult(BulkWriteResult bulkWriteResult) {
        if (bulkWriteResult.wasAcknowledged()) {
            BsonValue bsonValue = bulkWriteResult.getUpserts().isEmpty() ? null : bulkWriteResult.getUpserts().get(0).getId();
            return UpdateResult.acknowledged(bulkWriteResult.getMatchedCount(), Long.valueOf(bulkWriteResult.getModifiedCount()), bsonValue);
        }
        return UpdateResult.unacknowledged();
    }

    private OperationExecutor getExecutor(TimeoutSettings timeoutSettings) {
        return this.executor.withTimeoutSettings(timeoutSettings);
    }
}

