/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListCollectionNamesIterable;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.internal.AggregateIterableImpl;
import com.mongodb.client.internal.ChangeStreamIterableImpl;
import com.mongodb.client.internal.ListCollectionNamesIterableImpl;
import com.mongodb.client.internal.ListCollectionsIterableImpl;
import com.mongodb.client.internal.MongoCollectionImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class MongoDatabaseImpl
implements MongoDatabase {
    private final String name;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;
    private final ReadConcern readConcern;
    private final UuidRepresentation uuidRepresentation;
    @Nullable
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final TimeoutSettings timeoutSettings;
    private final OperationExecutor executor;
    private final SyncOperations<BsonDocument> operations;

    public MongoDatabaseImpl(String string, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean bl, boolean bl2, ReadConcern readConcern, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, TimeoutSettings timeoutSettings, OperationExecutor operationExecutor) {
        MongoNamespace.checkDatabaseNameValidity(string);
        this.name = Assertions.notNull("name", string);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = bl;
        this.retryReads = bl2;
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.timeoutSettings = timeoutSettings;
        this.executor = Assertions.notNull("executor", operationExecutor);
        this.operations = new SyncOperations<BsonDocument>(new MongoNamespace(string, "$cmd"), BsonDocument.class, readPreference, codecRegistry, readConcern, writeConcern, bl, bl2, timeoutSettings);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        Long l = this.timeoutSettings.getTimeoutMS();
        return l == null ? null : Long.valueOf(Assertions.notNull("timeUnit", timeUnit).convert(l, TimeUnit.MILLISECONDS));
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.name, CodecRegistries.withUuidRepresentation(codecRegistry, this.uuidRepresentation), this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoDatabase withTimeout(long l, TimeUnit timeUnit) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings.withTimeout(l, timeUnit), this.executor);
    }

    @Override
    public MongoCollection<Document> getCollection(String string) {
        return this.getCollection(string, Document.class);
    }

    @Override
    public <TDocument> MongoCollection<TDocument> getCollection(String string, Class<TDocument> clazz) {
        return new MongoCollectionImpl<TDocument>(new MongoNamespace(this.name, string), clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public Document runCommand(Bson bson) {
        return this.runCommand(bson, Document.class);
    }

    @Override
    public Document runCommand(Bson bson, ReadPreference readPreference) {
        return this.runCommand(bson, readPreference, Document.class);
    }

    @Override
    public <TResult> TResult runCommand(Bson bson, Class<TResult> clazz) {
        return this.runCommand(bson, ReadPreference.primary(), clazz);
    }

    @Override
    public <TResult> TResult runCommand(Bson bson, ReadPreference readPreference, Class<TResult> clazz) {
        return this.executeCommand(null, bson, readPreference, clazz);
    }

    @Override
    public Document runCommand(ClientSession clientSession, Bson bson) {
        return this.runCommand(clientSession, bson, ReadPreference.primary(), Document.class);
    }

    @Override
    public Document runCommand(ClientSession clientSession, Bson bson, ReadPreference readPreference) {
        return this.runCommand(clientSession, bson, readPreference, Document.class);
    }

    @Override
    public <TResult> TResult runCommand(ClientSession clientSession, Bson bson, Class<TResult> clazz) {
        return this.runCommand(clientSession, bson, ReadPreference.primary(), clazz);
    }

    @Override
    public <TResult> TResult runCommand(ClientSession clientSession, Bson bson, ReadPreference readPreference, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeCommand(clientSession, bson, readPreference, clazz);
    }

    private <TResult> TResult executeCommand(@Nullable ClientSession clientSession, Bson bson, ReadPreference readPreference, Class<TResult> clazz) {
        Assertions.notNull("readPreference", readPreference);
        if (clientSession != null && clientSession.hasActiveTransaction() && !readPreference.equals(ReadPreference.primary())) {
            throw new MongoClientException("Read preference in a transaction must be primary");
        }
        return this.getExecutor().execute(this.operations.commandRead(bson, clazz), readPreference, this.readConcern, clientSession);
    }

    @Override
    public void drop() {
        this.executeDrop(null);
    }

    @Override
    public void drop(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDrop(clientSession);
    }

    private void executeDrop(@Nullable ClientSession clientSession) {
        this.getExecutor().execute(this.operations.dropDatabase(), this.readConcern, clientSession);
    }

    @Override
    public ListCollectionNamesIterable listCollectionNames() {
        return this.createListCollectionNamesIterable(null);
    }

    @Override
    public ListCollectionNamesIterable listCollectionNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListCollectionNamesIterable(clientSession);
    }

    private ListCollectionNamesIterable createListCollectionNamesIterable(@Nullable ClientSession clientSession) {
        return new ListCollectionNamesIterableImpl(this.createListCollectionsIterable(clientSession, BsonDocument.class, true));
    }

    @Override
    public ListCollectionsIterable<Document> listCollections() {
        return this.listCollections(Document.class);
    }

    @Override
    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> clazz) {
        return this.createListCollectionsIterable(null, clazz, false);
    }

    @Override
    public ListCollectionsIterable<Document> listCollections(ClientSession clientSession) {
        return this.listCollections(clientSession, Document.class);
    }

    @Override
    public <TResult> ListCollectionsIterable<TResult> listCollections(ClientSession clientSession, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListCollectionsIterable(clientSession, clazz, false);
    }

    private <TResult> ListCollectionsIterableImpl<TResult> createListCollectionsIterable(@Nullable ClientSession clientSession, Class<TResult> clazz, boolean bl) {
        return new ListCollectionsIterableImpl<TResult>(clientSession, this.name, bl, clazz, this.codecRegistry, ReadPreference.primary(), this.executor, this.retryReads, this.timeoutSettings);
    }

    @Override
    public void createCollection(String string) {
        this.createCollection(string, new CreateCollectionOptions());
    }

    @Override
    public void createCollection(String string, CreateCollectionOptions createCollectionOptions) {
        this.executeCreateCollection(null, string, createCollectionOptions);
    }

    @Override
    public void createCollection(ClientSession clientSession, String string) {
        this.createCollection(clientSession, string, new CreateCollectionOptions());
    }

    @Override
    public void createCollection(ClientSession clientSession, String string, CreateCollectionOptions createCollectionOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCreateCollection(clientSession, string, createCollectionOptions);
    }

    private void executeCreateCollection(@Nullable ClientSession clientSession, String string, CreateCollectionOptions createCollectionOptions) {
        this.getExecutor().execute(this.operations.createCollection(string, createCollectionOptions, this.autoEncryptionSettings), this.readConcern, clientSession);
    }

    @Override
    public void createView(String string, String string2, List<? extends Bson> list) {
        this.createView(string, string2, list, new CreateViewOptions());
    }

    @Override
    public void createView(String string, String string2, List<? extends Bson> list, CreateViewOptions createViewOptions) {
        this.executeCreateView(null, string, string2, list, createViewOptions);
    }

    @Override
    public void createView(ClientSession clientSession, String string, String string2, List<? extends Bson> list) {
        this.createView(clientSession, string, string2, list, new CreateViewOptions());
    }

    @Override
    public void createView(ClientSession clientSession, String string, String string2, List<? extends Bson> list, CreateViewOptions createViewOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCreateView(clientSession, string, string2, list, createViewOptions);
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> clazz) {
        return this.watch(Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> list) {
        return this.watch(list, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> list, Class<TResult> clazz) {
        return this.createChangeStreamIterable(null, list, clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> clazz) {
        return this.watch(clientSession, Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> list) {
        return this.watch(clientSession, list, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, list, clazz);
    }

    @Override
    public AggregateIterable<Document> aggregate(List<? extends Bson> list) {
        return this.aggregate(list, Document.class);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> list, Class<TResult> clazz) {
        return this.createAggregateIterable(null, list, clazz);
    }

    @Override
    public AggregateIterable<Document> aggregate(ClientSession clientSession, List<? extends Bson> list) {
        return this.aggregate(clientSession, list, Document.class);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createAggregateIterable(clientSession, list, clazz);
    }

    private <TResult> AggregateIterable<TResult> createAggregateIterable(@Nullable ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        return new AggregateIterableImpl<Document, TResult>(clientSession, this.name, Document.class, clazz, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, list, AggregationLevel.DATABASE, this.retryReads, this.timeoutSettings);
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> list, Class<TResult> clazz) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, this.name, this.codecRegistry, this.readPreference, this.readConcern, this.executor, list, clazz, ChangeStreamLevel.DATABASE, this.retryReads, this.timeoutSettings);
    }

    private void executeCreateView(@Nullable ClientSession clientSession, String string, String string2, List<? extends Bson> list, CreateViewOptions createViewOptions) {
        Assertions.notNull("createViewOptions", createViewOptions);
        this.getExecutor().execute(this.operations.createView(string, string2, list, createViewOptions), this.readConcern, clientSession);
    }

    private OperationExecutor getExecutor() {
        return this.executor.withTimeoutSettings(this.timeoutSettings);
    }
}

