/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.Function;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.internal.MappingIterable;
import com.mongodb.client.internal.MongoBatchCursorAdapter;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class MongoIterableImpl<TResult>
implements MongoIterable<TResult> {
    private final ClientSession clientSession;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;
    private final ReadPreference readPreference;
    private final boolean retryReads;
    private final TimeoutSettings timeoutSettings;
    private Integer batchSize;
    private TimeoutMode timeoutMode;

    public MongoIterableImpl(@Nullable ClientSession clientSession, OperationExecutor operationExecutor, ReadConcern readConcern, ReadPreference readPreference, boolean bl, TimeoutSettings timeoutSettings) {
        this.clientSession = clientSession;
        this.executor = Assertions.notNull("executor", operationExecutor);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.retryReads = bl;
        this.timeoutSettings = timeoutSettings;
    }

    public abstract ReadOperation<BatchCursor<TResult>> asReadOperation();

    @Nullable
    ClientSession getClientSession() {
        return this.clientSession;
    }

    protected abstract OperationExecutor getExecutor();

    OperationExecutor getExecutor(TimeoutSettings timeoutSettings) {
        return this.executor.withTimeoutSettings(timeoutSettings);
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    protected ReadConcern getReadConcern() {
        return this.readConcern;
    }

    protected boolean getRetryReads() {
        return this.retryReads;
    }

    protected TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public MongoIterable<TResult> batchSize(int n) {
        this.batchSize = n;
        return this;
    }

    @Nullable
    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    public MongoIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        if (this.timeoutSettings.getTimeoutMS() == null) {
            throw new IllegalArgumentException("TimeoutMode requires timeoutMS to be set.");
        }
        this.timeoutMode = timeoutMode;
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return new MongoBatchCursorAdapter<TResult>(this.execute());
    }

    @Override
    public MongoCursor<TResult> cursor() {
        return this.iterator();
    }

    @Override
    @Nullable
    public TResult first() {
        try (Iterator iterator = this.iterator();){
            if (!iterator.hasNext()) {
                TResult TResult = null;
                return TResult;
            }
            Object TResult = iterator.next();
            return TResult;
        }
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> function) {
        return new MappingIterable<TResult, U>(this, function);
    }

    @Override
    public void forEach(Consumer<? super TResult> consumer) {
        try (Iterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                consumer.accept(iterator.next());
            }
        }
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A a) {
        this.forEach((Consumer<? super TResult>)((Consumer<Object>)a::add));
        return a;
    }

    private BatchCursor<TResult> execute() {
        return this.getExecutor().execute(this.asReadOperation(), this.readPreference, this.readConcern, this.clientSession);
    }

    protected long validateMaxAwaitTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Long l2 = this.timeoutSettings.getTimeoutMS();
        long l3 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        Assertions.isTrueArgument("maxAwaitTimeMS must be less than timeoutMS", l2 == null || l2 == 0L || l2 > l3);
        return l3;
    }
}

