/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class TimeoutHelper {
    private static final String DEFAULT_TIMEOUT_MESSAGE = "Operation exceeded the timeout limit.";

    private TimeoutHelper() {
    }

    public static <T> MongoCollection<T> collectionWithTimeout(MongoCollection<T> mongoCollection, String string, @Nullable Timeout timeout) {
        if (timeout != null) {
            return timeout.call(TimeUnit.MILLISECONDS, () -> mongoCollection.withTimeout(0L, TimeUnit.MILLISECONDS), l -> mongoCollection.withTimeout(l, TimeUnit.MILLISECONDS), () -> (MongoCollection)TimeoutContext.throwMongoTimeoutException(string));
        }
        return mongoCollection;
    }

    public static <T> MongoCollection<T> collectionWithTimeout(MongoCollection<T> mongoCollection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(mongoCollection, DEFAULT_TIMEOUT_MESSAGE, timeout);
    }

    public static MongoDatabase databaseWithTimeout(MongoDatabase mongoDatabase, String string, @Nullable Timeout timeout) {
        if (timeout != null) {
            return timeout.call(TimeUnit.MILLISECONDS, () -> mongoDatabase.withTimeout(0L, TimeUnit.MILLISECONDS), l -> mongoDatabase.withTimeout(l, TimeUnit.MILLISECONDS), () -> (MongoDatabase)TimeoutContext.throwMongoTimeoutException(string));
        }
        return mongoDatabase;
    }

    public static MongoDatabase databaseWithTimeout(MongoDatabase mongoDatabase, @Nullable Timeout timeout) {
        return TimeoutHelper.databaseWithTimeout(mongoDatabase, DEFAULT_TIMEOUT_MESSAGE, timeout);
    }
}

