/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.QuantileMethod;
import com.mongodb.client.model.SimpleExpression;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.Document;
import org.bson.assertions.Assertions;
import org.bson.conversions.Bson;

public final class Accumulators {
    public static <TExpression> BsonField sum(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$sum", string, TExpression);
    }

    public static <TExpression> BsonField avg(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$avg", string, TExpression);
    }

    public static <InExpression, PExpression> BsonField percentile(String string, InExpression InExpression, PExpression PExpression, QuantileMethod quantileMethod) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("inExpression", InExpression);
        Assertions.notNull("pExpression", InExpression);
        Assertions.notNull("method", quantileMethod);
        return Accumulators.quantileAccumulator("$percentile", string, InExpression, PExpression, quantileMethod);
    }

    public static <InExpression> BsonField median(String string, InExpression InExpression, QuantileMethod quantileMethod) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("inExpression", InExpression);
        Assertions.notNull("method", quantileMethod);
        return Accumulators.quantileAccumulator("$median", string, InExpression, null, quantileMethod);
    }

    public static <TExpression> BsonField first(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$first", string, TExpression);
    }

    public static <InExpression, NExpression> BsonField firstN(String string, InExpression InExpression, NExpression NExpression) {
        return Accumulators.pickNAccumulator(Assertions.notNull("fieldName", string), "$firstN", Assertions.notNull("inExpression", InExpression), Assertions.notNull("nExpression", NExpression));
    }

    public static <OutExpression> BsonField top(String string, Bson bson, OutExpression OutExpression) {
        return Accumulators.sortingPickAccumulator(Assertions.notNull("fieldName", string), "$top", Assertions.notNull("sortBy", bson), Assertions.notNull("outExpression", OutExpression));
    }

    public static <OutExpression, NExpression> BsonField topN(String string, Bson bson, OutExpression OutExpression, NExpression NExpression) {
        return Accumulators.sortingPickNAccumulator(Assertions.notNull("fieldName", string), "$topN", Assertions.notNull("sortBy", bson), Assertions.notNull("outExpression", OutExpression), Assertions.notNull("nExpression", NExpression));
    }

    public static <TExpression> BsonField last(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$last", string, TExpression);
    }

    public static <InExpression, NExpression> BsonField lastN(String string, InExpression InExpression, NExpression NExpression) {
        return Accumulators.pickNAccumulator(Assertions.notNull("fieldName", string), "$lastN", Assertions.notNull("inExpression", InExpression), Assertions.notNull("nExpression", NExpression));
    }

    public static <OutExpression> BsonField bottom(String string, Bson bson, OutExpression OutExpression) {
        return Accumulators.sortingPickAccumulator(Assertions.notNull("fieldName", string), "$bottom", Assertions.notNull("sortBy", bson), Assertions.notNull("outExpression", OutExpression));
    }

    public static <OutExpression, NExpression> BsonField bottomN(String string, Bson bson, OutExpression OutExpression, NExpression NExpression) {
        return Accumulators.sortingPickNAccumulator(Assertions.notNull("fieldName", string), "$bottomN", Assertions.notNull("sortBy", bson), Assertions.notNull("outExpression", OutExpression), Assertions.notNull("nExpression", NExpression));
    }

    public static <TExpression> BsonField max(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$max", string, TExpression);
    }

    public static <InExpression, NExpression> BsonField maxN(String string, InExpression InExpression, NExpression NExpression) {
        return Accumulators.pickNAccumulator(Assertions.notNull("fieldName", string), "$maxN", Assertions.notNull("inExpression", InExpression), Assertions.notNull("nExpression", NExpression));
    }

    public static <TExpression> BsonField min(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$min", string, TExpression);
    }

    public static <InExpression, NExpression> BsonField minN(String string, InExpression InExpression, NExpression NExpression) {
        return Accumulators.pickNAccumulator(Assertions.notNull("fieldName", string), "$minN", Assertions.notNull("inExpression", InExpression), Assertions.notNull("nExpression", NExpression));
    }

    public static <TExpression> BsonField push(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$push", string, TExpression);
    }

    public static <TExpression> BsonField addToSet(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$addToSet", string, TExpression);
    }

    public static <TExpression> BsonField mergeObjects(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$mergeObjects", string, TExpression);
    }

    public static <TExpression> BsonField stdDevPop(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$stdDevPop", string, TExpression);
    }

    public static <TExpression> BsonField stdDevSamp(String string, TExpression TExpression) {
        return Accumulators.accumulatorOperator("$stdDevSamp", string, TExpression);
    }

    public static BsonField accumulator(String string, String string2, String string3, String string4) {
        return Accumulators.accumulator(string, string2, null, string3, null, string4, null, "js");
    }

    public static BsonField accumulator(String string, String string2, String string3, String string4, @Nullable String string5) {
        return Accumulators.accumulator(string, string2, null, string3, null, string4, string5, "js");
    }

    public static BsonField accumulator(String string, String string2, @Nullable List<String> list, String string3, @Nullable List<String> list2, String string4, @Nullable String string5) {
        return Accumulators.accumulator(string, string2, list, string3, list2, string4, string5, "js");
    }

    public static BsonField accumulator(String string, String string2, String string3, String string4, @Nullable String string5, String string6) {
        return Accumulators.accumulator(string, string2, null, string3, null, string4, string5, string6);
    }

    public static BsonField accumulator(String string2, String string3, @Nullable List<String> list, String string4, @Nullable List<String> list2, String string5, @Nullable String string6, String string7) {
        BsonDocument bsonDocument = new BsonDocument("init", new BsonString(string3)).append("initArgs", list != null ? new BsonArray(list.stream().map(string -> new BsonString((String)string)).collect(Collectors.toList())) : new BsonArray()).append("accumulate", new BsonString(string4)).append("accumulateArgs", list2 != null ? new BsonArray(list2.stream().map(string -> new BsonString((String)string)).collect(Collectors.toList())) : new BsonArray()).append("merge", new BsonString(string5)).append("lang", new BsonString(string7));
        if (string6 != null) {
            bsonDocument.append("finalize", new BsonString(string6));
        }
        return Accumulators.accumulatorOperator("$accumulator", string2, bsonDocument);
    }

    private static <TExpression> BsonField accumulatorOperator(String string, String string2, TExpression TExpression) {
        return new BsonField(string2, new SimpleExpression<TExpression>(string, TExpression));
    }

    private static <InExpression, NExpression> BsonField pickNAccumulator(String string, String string2, InExpression InExpression, NExpression NExpression) {
        return new BsonField(string, new Document(string2, new Document("input", InExpression).append("n", NExpression)));
    }

    private static <OutExpression> BsonField sortingPickAccumulator(String string, String string2, Bson bson, OutExpression OutExpression) {
        return new BsonField(string, new Document(string2, new Document("sortBy", bson).append("output", OutExpression)));
    }

    private static <OutExpression, NExpression> BsonField sortingPickNAccumulator(String string, String string2, Bson bson, OutExpression OutExpression, NExpression NExpression) {
        return new BsonField(string, new Document(string2, new Document("sortBy", bson).append("output", OutExpression).append("n", NExpression)));
    }

    private static <InExpression, PExpression> BsonField quantileAccumulator(String string, String string2, InExpression InExpression, @Nullable PExpression PExpression, QuantileMethod quantileMethod) {
        Document document = new Document("input", InExpression).append("method", quantileMethod.toBsonValue());
        if (PExpression != null) {
            document.append("p", PExpression);
        }
        return Accumulators.accumulatorOperator(string, string2, document);
    }

    private Accumulators() {
    }
}

