/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BucketAutoOptions;
import com.mongodb.client.model.BucketGranularity;
import com.mongodb.client.model.BucketOptions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.Facet;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.GeoNearOptions;
import com.mongodb.client.model.GraphLookupOptions;
import com.mongodb.client.model.MergeOptions;
import com.mongodb.client.model.UnwindOptions;
import com.mongodb.client.model.Variable;
import com.mongodb.client.model.WindowOutputField;
import com.mongodb.client.model.densify.DensifyOptions;
import com.mongodb.client.model.densify.DensifyRange;
import com.mongodb.client.model.fill.FillOptions;
import com.mongodb.client.model.fill.FillOutputField;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.SearchCollector;
import com.mongodb.client.model.search.SearchOperator;
import com.mongodb.client.model.search.SearchOptions;
import com.mongodb.client.model.search.VectorSearchOptions;
import com.mongodb.internal.Iterables;
import com.mongodb.internal.client.model.Util;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.BinaryVector;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Aggregates {
    public static Bson addFields(Field<?> ... fieldArray) {
        return Aggregates.addFields(Arrays.asList(fieldArray));
    }

    public static Bson addFields(List<Field<?>> list) {
        return new FieldsStage("$addFields", list);
    }

    public static Bson set(Field<?> ... fieldArray) {
        return Aggregates.set(Arrays.asList(fieldArray));
    }

    public static Bson set(List<Field<?>> list) {
        return new FieldsStage("$set", list);
    }

    public static <TExpression, Boundary> Bson bucket(TExpression TExpression, List<Boundary> list) {
        return Aggregates.bucket(TExpression, list, new BucketOptions());
    }

    public static <TExpression, TBoundary> Bson bucket(TExpression TExpression, List<TBoundary> list, BucketOptions bucketOptions) {
        return new BucketStage<TExpression, TBoundary>(TExpression, list, bucketOptions);
    }

    public static <TExpression> Bson bucketAuto(TExpression TExpression, int n) {
        return Aggregates.bucketAuto(TExpression, n, new BucketAutoOptions());
    }

    public static <TExpression> Bson bucketAuto(TExpression TExpression, int n, BucketAutoOptions bucketAutoOptions) {
        return new BucketAutoStage<TExpression>(TExpression, n, bucketAutoOptions);
    }

    public static Bson count() {
        return Aggregates.count("count");
    }

    public static Bson count(String string) {
        return new BsonDocument("$count", new BsonString(string));
    }

    public static Bson match(Bson bson) {
        return new SimplePipelineStage("$match", bson);
    }

    public static Bson project(Bson bson) {
        return new SimplePipelineStage("$project", bson);
    }

    public static Bson sort(Bson bson) {
        return new SimplePipelineStage("$sort", bson);
    }

    public static <TExpression> Bson sortByCount(TExpression TExpression) {
        return new SortByCountStage<TExpression>(TExpression);
    }

    public static Bson skip(int n) {
        return new BsonDocument("$skip", new BsonInt32(n));
    }

    public static Bson limit(int n) {
        return new BsonDocument("$limit", new BsonInt32(n));
    }

    public static Bson lookup(String string, String string2, String string3, String string4) {
        return new BsonDocument("$lookup", new BsonDocument("from", new BsonString(string)).append("localField", new BsonString(string2)).append("foreignField", new BsonString(string3)).append("as", new BsonString(string4)));
    }

    public static Bson lookup(@Nullable String string, List<? extends Bson> list, String string2) {
        return Aggregates.lookup(string, null, list, string2);
    }

    public static <TExpression> Bson lookup(@Nullable String string, @Nullable List<Variable<TExpression>> list, List<? extends Bson> list2, String string2) {
        return new LookupStage(string, list, list2, string2);
    }

    public static Bson facet(List<Facet> list) {
        return new FacetStage(list);
    }

    public static Bson facet(Facet ... facetArray) {
        return new FacetStage(Arrays.asList(facetArray));
    }

    public static <TExpression> Bson graphLookup(String string, TExpression TExpression, String string2, String string3, String string4) {
        return Aggregates.graphLookup(string, TExpression, string2, string3, string4, new GraphLookupOptions());
    }

    public static <TExpression> Bson graphLookup(String string, TExpression TExpression, String string2, String string3, String string4, GraphLookupOptions graphLookupOptions) {
        Assertions.notNull("options", graphLookupOptions);
        return new GraphLookupStage(string, TExpression, string2, string3, string4, graphLookupOptions);
    }

    public static <TExpression> Bson group(@Nullable TExpression TExpression, BsonField ... bsonFieldArray) {
        return Aggregates.group(TExpression, Arrays.asList(bsonFieldArray));
    }

    public static <TExpression> Bson group(@Nullable TExpression TExpression, List<BsonField> list) {
        return new GroupStage<TExpression>(TExpression, list);
    }

    public static Bson unionWith(String string, List<? extends Bson> list) {
        return new UnionWithStage(string, list);
    }

    public static Bson unwind(String string) {
        return new BsonDocument("$unwind", new BsonString(string));
    }

    public static Bson unwind(String string, UnwindOptions unwindOptions) {
        String string2;
        Assertions.notNull("unwindOptions", unwindOptions);
        BsonDocument bsonDocument = new BsonDocument("path", new BsonString(string));
        Boolean bl = unwindOptions.isPreserveNullAndEmptyArrays();
        if (bl != null) {
            bsonDocument.append("preserveNullAndEmptyArrays", BsonBoolean.valueOf(bl));
        }
        if ((string2 = unwindOptions.getIncludeArrayIndex()) != null) {
            bsonDocument.append("includeArrayIndex", new BsonString(string2));
        }
        return new BsonDocument("$unwind", bsonDocument);
    }

    public static Bson out(String string) {
        return new BsonDocument("$out", new BsonString(string));
    }

    public static Bson out(String string, String string2) {
        return new BsonDocument("$out", new BsonDocument("db", new BsonString(string)).append("coll", new BsonString(string2)));
    }

    public static Bson out(Bson bson) {
        return new SimplePipelineStage("$out", bson);
    }

    public static Bson merge(String string) {
        return Aggregates.merge(string, new MergeOptions());
    }

    public static Bson merge(MongoNamespace mongoNamespace) {
        return Aggregates.merge(mongoNamespace, new MergeOptions());
    }

    public static Bson merge(String string, MergeOptions mergeOptions) {
        return new MergeStage(new BsonString(string), mergeOptions);
    }

    public static Bson merge(MongoNamespace mongoNamespace, MergeOptions mergeOptions) {
        return new MergeStage(new BsonDocument("db", new BsonString(mongoNamespace.getDatabaseName())).append("coll", new BsonString(mongoNamespace.getCollectionName())), mergeOptions);
    }

    public static <TExpression> Bson replaceRoot(TExpression TExpression) {
        return new ReplaceStage<TExpression>(TExpression);
    }

    public static <TExpression> Bson replaceWith(TExpression TExpression) {
        return new ReplaceStage<TExpression>(TExpression, true);
    }

    public static Bson sample(int n) {
        return new BsonDocument("$sample", new BsonDocument("size", new BsonInt32(n)));
    }

    public static <TExpression> Bson setWindowFields(@Nullable TExpression TExpression, @Nullable Bson bson, WindowOutputField windowOutputField, WindowOutputField ... windowOutputFieldArray) {
        return Aggregates.setWindowFields(TExpression, bson, Iterables.concat(Assertions.notNull("output", windowOutputField), windowOutputFieldArray));
    }

    public static <TExpression> Bson setWindowFields(@Nullable TExpression TExpression, @Nullable Bson bson, Iterable<? extends WindowOutputField> iterable) {
        Assertions.notNull("output", iterable);
        return new SetWindowFieldsStage<TExpression>(TExpression, bson, iterable);
    }

    public static Bson densify(String string, DensifyRange densifyRange) {
        return Aggregates.densify(Assertions.notNull("field", string), Assertions.notNull("range", densifyRange), DensifyOptions.densifyOptions());
    }

    public static Bson densify(final String string, final DensifyRange densifyRange, final DensifyOptions densifyOptions) {
        Assertions.notNull("field", string);
        Assertions.notNull("range", densifyRange);
        Assertions.notNull("options", densifyOptions);
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = new BsonDocument("field", new BsonString(string));
                bsonDocument.append("range", densifyRange.toBsonDocument(clazz, codecRegistry));
                bsonDocument.putAll(densifyOptions.toBsonDocument(clazz, codecRegistry));
                return new BsonDocument("$densify", bsonDocument);
            }

            public String toString() {
                return "Stage{name='$densify', field=" + string + ", range=" + densifyRange + ", options=" + densifyOptions + '}';
            }
        };
    }

    public static Bson fill(FillOptions fillOptions, FillOutputField fillOutputField, FillOutputField ... fillOutputFieldArray) {
        return Aggregates.fill(fillOptions, Iterables.concat(Assertions.notNull("output", fillOutputField), fillOutputFieldArray));
    }

    public static Bson fill(final FillOptions fillOptions, final Iterable<? extends FillOutputField> iterable) {
        Assertions.notNull("options", fillOptions);
        Assertions.notNull("output", iterable);
        Assertions.isTrueArgument("output must not be empty", Util.sizeAtLeast(iterable, 1));
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = new BsonDocument();
                bsonDocument.putAll(fillOptions.toBsonDocument(clazz, codecRegistry));
                BsonDocument bsonDocument2 = new BsonDocument();
                for (FillOutputField fillOutputField : iterable) {
                    BsonDocument bsonDocument3 = fillOutputField.toBsonDocument(clazz, codecRegistry);
                    Assertions.assertTrue(bsonDocument3.size() == 1);
                    bsonDocument2.putAll(bsonDocument3);
                }
                bsonDocument.append("output", bsonDocument2);
                return new BsonDocument("$fill", bsonDocument);
            }

            public String toString() {
                return "Stage{name='$fill', options=" + fillOptions + ", output=" + iterable + '}';
            }
        };
    }

    public static Bson search(SearchOperator searchOperator) {
        return Aggregates.search(searchOperator, SearchOptions.searchOptions());
    }

    public static Bson search(SearchOperator searchOperator, SearchOptions searchOptions) {
        return new SearchStage("$search", Assertions.notNull("operator", searchOperator), Assertions.notNull("options", searchOptions));
    }

    public static Bson search(SearchCollector searchCollector) {
        return Aggregates.search(searchCollector, SearchOptions.searchOptions());
    }

    public static Bson search(SearchCollector searchCollector, SearchOptions searchOptions) {
        return new SearchStage("$search", Assertions.notNull("collector", searchCollector), Assertions.notNull("options", searchOptions));
    }

    public static Bson searchMeta(SearchOperator searchOperator) {
        return Aggregates.searchMeta(searchOperator, SearchOptions.searchOptions());
    }

    public static Bson searchMeta(SearchOperator searchOperator, SearchOptions searchOptions) {
        return new SearchStage("$searchMeta", Assertions.notNull("operator", searchOperator), Assertions.notNull("options", searchOptions));
    }

    public static Bson searchMeta(SearchCollector searchCollector) {
        return Aggregates.searchMeta(searchCollector, SearchOptions.searchOptions());
    }

    public static Bson searchMeta(SearchCollector searchCollector, SearchOptions searchOptions) {
        return new SearchStage("$searchMeta", Assertions.notNull("collector", searchCollector), Assertions.notNull("options", searchOptions));
    }

    public static Bson vectorSearch(FieldSearchPath fieldSearchPath, Iterable<Double> iterable, String string, long l, VectorSearchOptions vectorSearchOptions) {
        Assertions.notNull("path", fieldSearchPath);
        Assertions.notNull("queryVector", iterable);
        Assertions.notNull("index", string);
        Assertions.notNull("options", vectorSearchOptions);
        return new VectorSearchBson(fieldSearchPath, iterable, string, l, vectorSearchOptions);
    }

    public static Bson vectorSearch(FieldSearchPath fieldSearchPath, BinaryVector binaryVector, String string, long l, VectorSearchOptions vectorSearchOptions) {
        Assertions.notNull("path", fieldSearchPath);
        Assertions.notNull("queryVector", binaryVector);
        Assertions.notNull("index", string);
        Assertions.notNull("options", vectorSearchOptions);
        return new VectorSearchBson(fieldSearchPath, binaryVector, string, l, vectorSearchOptions);
    }

    public static Bson unset(String ... stringArray) {
        return Aggregates.unset(Arrays.asList(stringArray));
    }

    public static Bson unset(List<String> list) {
        if (list.size() == 1) {
            return new BsonDocument("$unset", new BsonString(list.get(0)));
        }
        BsonArray bsonArray = new BsonArray();
        list.stream().map(BsonString::new).forEach(bsonArray::add);
        return new BsonDocument().append("$unset", bsonArray);
    }

    public static Bson geoNear(final Point point, final String string, final GeoNearOptions geoNearOptions) {
        Assertions.notNull("near", point);
        Assertions.notNull("distanceField", string);
        Assertions.notNull("options", geoNearOptions);
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
                BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
                bsonDocumentWriter.writeStartDocument();
                bsonDocumentWriter.writeStartDocument("$geoNear");
                bsonDocumentWriter.writeName("near");
                BuildersHelper.encodeValue(bsonDocumentWriter, point, codecRegistry);
                bsonDocumentWriter.writeName("distanceField");
                BuildersHelper.encodeValue(bsonDocumentWriter, string, codecRegistry);
                geoNearOptions.toBsonDocument(clazz, codecRegistry).forEach((string, bsonValue) -> {
                    bsonDocumentWriter.writeName((String)string);
                    BuildersHelper.encodeValue(bsonDocumentWriter, bsonValue, codecRegistry);
                });
                bsonDocumentWriter.writeEndDocument();
                bsonDocumentWriter.writeEndDocument();
                return bsonDocumentWriter.getDocument();
            }

            public String toString() {
                return "Stage{name='$geoNear', near=" + point + ", distanceField=" + string + ", options=" + geoNearOptions + '}';
            }
        };
    }

    public static Bson geoNear(Point point, String string) {
        return Aggregates.geoNear(point, string, GeoNearOptions.geoNearOptions());
    }

    public static Bson documents(final List<? extends Bson> list) {
        Assertions.notNull("documents", list);
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
                BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
                bsonDocumentWriter.writeStartDocument();
                bsonDocumentWriter.writeStartArray("$documents");
                for (Bson bson : list) {
                    BuildersHelper.encodeValue(bsonDocumentWriter, bson, codecRegistry);
                }
                bsonDocumentWriter.writeEndArray();
                bsonDocumentWriter.writeEndDocument();
                return bsonDocumentWriter.getDocument();
            }
        };
    }

    static void writeBucketOutput(CodecRegistry codecRegistry, BsonDocumentWriter bsonDocumentWriter, @Nullable List<BsonField> list) {
        if (list != null) {
            bsonDocumentWriter.writeName("output");
            bsonDocumentWriter.writeStartDocument();
            for (BsonField bsonField : list) {
                bsonDocumentWriter.writeName(bsonField.getName());
                BuildersHelper.encodeValue(bsonDocumentWriter, bsonField.getValue(), codecRegistry);
            }
            bsonDocumentWriter.writeEndDocument();
        }
    }

    private Aggregates() {
    }

    private static class FieldsStage
    implements Bson {
        private final List<Field<?>> fields;
        private final String stageName;

        FieldsStage(String string, List<Field<?>> list) {
            this.stageName = string;
            this.fields = Assertions.notNull("fields", list);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.stageName);
            bsonDocumentWriter.writeStartDocument();
            for (Field<?> field : this.fields) {
                bsonDocumentWriter.writeName(field.getName());
                BuildersHelper.encodeValue(bsonDocumentWriter, field.getValue(), codecRegistry);
            }
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FieldsStage fieldsStage = (FieldsStage)object;
            if (!this.fields.equals(fieldsStage.fields)) {
                return false;
            }
            return this.stageName.equals(fieldsStage.stageName);
        }

        public int hashCode() {
            int n = this.fields.hashCode();
            n = 31 * n + this.stageName.hashCode();
            return n;
        }

        public String toString() {
            return "Stage{name='" + this.stageName + "', fields=" + this.fields + '}';
        }
    }

    private static final class BucketStage<TExpression, TBoundary>
    implements Bson {
        private final TExpression groupBy;
        private final List<TBoundary> boundaries;
        private final BucketOptions options;

        BucketStage(TExpression TExpression, List<TBoundary> list, BucketOptions bucketOptions) {
            Assertions.notNull("options", bucketOptions);
            this.groupBy = TExpression;
            this.boundaries = list;
            this.options = bucketOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument("$bucket");
            bsonDocumentWriter.writeName("groupBy");
            BuildersHelper.encodeValue(bsonDocumentWriter, this.groupBy, codecRegistry);
            bsonDocumentWriter.writeStartArray("boundaries");
            for (TBoundary TBoundary : this.boundaries) {
                BuildersHelper.encodeValue(bsonDocumentWriter, TBoundary, codecRegistry);
            }
            bsonDocumentWriter.writeEndArray();
            Object object = this.options.getDefaultBucket();
            if (object != null) {
                bsonDocumentWriter.writeName("default");
                BuildersHelper.encodeValue(bsonDocumentWriter, object, codecRegistry);
            }
            Aggregates.writeBucketOutput(codecRegistry, bsonDocumentWriter, this.options.getOutput());
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BucketStage bucketStage = (BucketStage)object;
            if (!Objects.equals(this.groupBy, bucketStage.groupBy)) {
                return false;
            }
            if (!Objects.equals(this.boundaries, bucketStage.boundaries)) {
                return false;
            }
            return this.options.equals(bucketStage.options);
        }

        public int hashCode() {
            int n = this.groupBy != null ? this.groupBy.hashCode() : 0;
            n = 31 * n + (this.boundaries != null ? this.boundaries.hashCode() : 0);
            n = 31 * n + this.options.hashCode();
            return n;
        }

        public String toString() {
            return "Stage{name='$bucket', boundaries=" + this.boundaries + ", groupBy=" + this.groupBy + ", options=" + this.options + '}';
        }
    }

    private static final class BucketAutoStage<TExpression>
    implements Bson {
        private final TExpression groupBy;
        private final int buckets;
        private final BucketAutoOptions options;

        BucketAutoStage(TExpression TExpression, int n, BucketAutoOptions bucketAutoOptions) {
            Assertions.notNull("options", bucketAutoOptions);
            this.groupBy = TExpression;
            this.buckets = n;
            this.options = bucketAutoOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument("$bucketAuto");
            bsonDocumentWriter.writeName("groupBy");
            BuildersHelper.encodeValue(bsonDocumentWriter, this.groupBy, codecRegistry);
            bsonDocumentWriter.writeInt32("buckets", this.buckets);
            Aggregates.writeBucketOutput(codecRegistry, bsonDocumentWriter, this.options.getOutput());
            BucketGranularity bucketGranularity = this.options.getGranularity();
            if (bucketGranularity != null) {
                bsonDocumentWriter.writeString("granularity", bucketGranularity.getValue());
            }
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BucketAutoStage bucketAutoStage = (BucketAutoStage)object;
            if (this.buckets != bucketAutoStage.buckets) {
                return false;
            }
            if (!Objects.equals(this.groupBy, bucketAutoStage.groupBy)) {
                return false;
            }
            return this.options.equals(bucketAutoStage.options);
        }

        public int hashCode() {
            int n = this.groupBy != null ? this.groupBy.hashCode() : 0;
            n = 31 * n + this.buckets;
            n = 31 * n + this.options.hashCode();
            return n;
        }

        public String toString() {
            return "Stage{name='$bucketAuto', buckets=" + this.buckets + ", groupBy=" + this.groupBy + ", options=" + this.options + '}';
        }
    }

    private static class SimplePipelineStage
    implements Bson {
        private final String name;
        private final Bson value;

        SimplePipelineStage(String string, Bson bson) {
            this.name = string;
            this.value = bson;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            return new BsonDocument(this.name, this.value.toBsonDocument(clazz, codecRegistry));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimplePipelineStage simplePipelineStage = (SimplePipelineStage)object;
            if (!Objects.equals(this.name, simplePipelineStage.name)) {
                return false;
            }
            return Objects.equals(this.value, simplePipelineStage.value);
        }

        public int hashCode() {
            int n = this.name != null ? this.name.hashCode() : 0;
            n = 31 * n + (this.value != null ? this.value.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Stage{name='" + this.name + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class SortByCountStage<TExpression>
    implements Bson {
        private final TExpression filter;

        SortByCountStage(TExpression TExpression) {
            this.filter = TExpression;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName("$sortByCount");
            BuildersHelper.encodeValue(bsonDocumentWriter, this.filter, codecRegistry);
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SortByCountStage sortByCountStage = (SortByCountStage)object;
            return Objects.equals(this.filter, sortByCountStage.filter);
        }

        public int hashCode() {
            return this.filter != null ? this.filter.hashCode() : 0;
        }

        public String toString() {
            return "Stage{name='$sortByCount', id=" + this.filter + '}';
        }
    }

    private static final class LookupStage<TExpression>
    implements Bson {
        private final String from;
        private final List<Variable<TExpression>> let;
        private final List<? extends Bson> pipeline;
        private final String as;

        private LookupStage(@Nullable String string, @Nullable List<Variable<TExpression>> list, List<? extends Bson> list2, String string2) {
            this.from = string;
            this.let = list;
            this.pipeline = list2;
            this.as = string2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument("$lookup");
            if (this.from != null) {
                bsonDocumentWriter.writeString("from", this.from);
            }
            if (this.let != null) {
                bsonDocumentWriter.writeStartDocument("let");
                for (Variable object : this.let) {
                    bsonDocumentWriter.writeName(object.getName());
                    BuildersHelper.encodeValue(bsonDocumentWriter, object.getValue(), codecRegistry);
                }
                bsonDocumentWriter.writeEndDocument();
            }
            bsonDocumentWriter.writeName("pipeline");
            bsonDocumentWriter.writeStartArray();
            for (Bson bson : this.pipeline) {
                BuildersHelper.encodeValue(bsonDocumentWriter, bson, codecRegistry);
            }
            bsonDocumentWriter.writeEndArray();
            bsonDocumentWriter.writeString("as", this.as);
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LookupStage lookupStage = (LookupStage)object;
            if (!Objects.equals(this.from, lookupStage.from)) {
                return false;
            }
            if (!Objects.equals(this.let, lookupStage.let)) {
                return false;
            }
            if (!Objects.equals(this.pipeline, lookupStage.pipeline)) {
                return false;
            }
            return Objects.equals(this.as, lookupStage.as);
        }

        public int hashCode() {
            int n = this.from != null ? this.from.hashCode() : 0;
            n = 31 * n + (this.let != null ? this.let.hashCode() : 0);
            n = 31 * n + (this.pipeline != null ? this.pipeline.hashCode() : 0);
            n = 31 * n + (this.as != null ? this.as.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Stage{name='$lookup', from='" + this.from + '\'' + ", let=" + this.let + ", pipeline=" + this.pipeline + ", as='" + this.as + '\'' + '}';
        }
    }

    private static class FacetStage
    implements Bson {
        private final List<Facet> facets;

        FacetStage(List<Facet> list) {
            this.facets = list;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName("$facet");
            bsonDocumentWriter.writeStartDocument();
            for (Facet facet : this.facets) {
                bsonDocumentWriter.writeName(facet.getName());
                bsonDocumentWriter.writeStartArray();
                for (Bson bson : facet.getPipeline()) {
                    BuildersHelper.encodeValue(bsonDocumentWriter, bson, codecRegistry);
                }
                bsonDocumentWriter.writeEndArray();
            }
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FacetStage facetStage = (FacetStage)object;
            return Objects.equals(this.facets, facetStage.facets);
        }

        public int hashCode() {
            return this.facets != null ? this.facets.hashCode() : 0;
        }

        public String toString() {
            return "Stage{name='$facet', facets=" + this.facets + '}';
        }
    }

    private static final class GraphLookupStage<TExpression>
    implements Bson {
        private final String from;
        private final TExpression startWith;
        private final String connectFromField;
        private final String connectToField;
        private final String as;
        private final GraphLookupOptions options;

        private GraphLookupStage(String string, TExpression TExpression, String string2, String string3, String string4, GraphLookupOptions graphLookupOptions) {
            this.from = string;
            this.startWith = TExpression;
            this.connectFromField = string2;
            this.connectToField = string3;
            this.as = string4;
            this.options = graphLookupOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            Bson bson;
            String string;
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument("$graphLookup");
            bsonDocumentWriter.writeString("from", this.from);
            bsonDocumentWriter.writeName("startWith");
            BuildersHelper.encodeValue(bsonDocumentWriter, this.startWith, codecRegistry);
            bsonDocumentWriter.writeString("connectFromField", this.connectFromField);
            bsonDocumentWriter.writeString("connectToField", this.connectToField);
            bsonDocumentWriter.writeString("as", this.as);
            Integer n = this.options.getMaxDepth();
            if (n != null) {
                bsonDocumentWriter.writeInt32("maxDepth", n);
            }
            if ((string = this.options.getDepthField()) != null) {
                bsonDocumentWriter.writeString("depthField", string);
            }
            if ((bson = this.options.getRestrictSearchWithMatch()) != null) {
                bsonDocumentWriter.writeName("restrictSearchWithMatch");
                BuildersHelper.encodeValue(bsonDocumentWriter, bson, codecRegistry);
            }
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GraphLookupStage graphLookupStage = (GraphLookupStage)object;
            if (!Objects.equals(this.from, graphLookupStage.from)) {
                return false;
            }
            if (!Objects.equals(this.startWith, graphLookupStage.startWith)) {
                return false;
            }
            if (!Objects.equals(this.connectFromField, graphLookupStage.connectFromField)) {
                return false;
            }
            if (!Objects.equals(this.connectToField, graphLookupStage.connectToField)) {
                return false;
            }
            if (!Objects.equals(this.as, graphLookupStage.as)) {
                return false;
            }
            return Objects.equals(this.options, graphLookupStage.options);
        }

        public int hashCode() {
            int n = this.from != null ? this.from.hashCode() : 0;
            n = 31 * n + (this.startWith != null ? this.startWith.hashCode() : 0);
            n = 31 * n + (this.connectFromField != null ? this.connectFromField.hashCode() : 0);
            n = 31 * n + (this.connectToField != null ? this.connectToField.hashCode() : 0);
            n = 31 * n + (this.as != null ? this.as.hashCode() : 0);
            n = 31 * n + (this.options != null ? this.options.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Stage{name='$graphLookup', as='" + this.as + '\'' + ", connectFromField='" + this.connectFromField + '\'' + ", connectToField='" + this.connectToField + '\'' + ", from='" + this.from + '\'' + ", options=" + this.options + ", startWith=" + this.startWith + '}';
        }
    }

    private static class GroupStage<TExpression>
    implements Bson {
        private final TExpression id;
        private final List<BsonField> fieldAccumulators;

        GroupStage(TExpression TExpression, List<BsonField> list) {
            this.id = TExpression;
            this.fieldAccumulators = list;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument("$group");
            bsonDocumentWriter.writeName("_id");
            BuildersHelper.encodeValue(bsonDocumentWriter, this.id, codecRegistry);
            for (BsonField bsonField : this.fieldAccumulators) {
                bsonDocumentWriter.writeName(bsonField.getName());
                BuildersHelper.encodeValue(bsonDocumentWriter, bsonField.getValue(), codecRegistry);
            }
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GroupStage groupStage = (GroupStage)object;
            if (!Objects.equals(this.id, groupStage.id)) {
                return false;
            }
            return Objects.equals(this.fieldAccumulators, groupStage.fieldAccumulators);
        }

        public int hashCode() {
            int n = this.id != null ? this.id.hashCode() : 0;
            n = 31 * n + (this.fieldAccumulators != null ? this.fieldAccumulators.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Stage{name='$group', id=" + this.id + ", fieldAccumulators=" + this.fieldAccumulators + '}';
        }
    }

    private static final class UnionWithStage
    implements Bson {
        private final String collection;
        private final List<? extends Bson> pipeline;

        private UnionWithStage(String string, List<? extends Bson> list) {
            this.collection = string;
            this.pipeline = list;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument("$unionWith");
            bsonDocumentWriter.writeString("coll", this.collection);
            bsonDocumentWriter.writeName("pipeline");
            bsonDocumentWriter.writeStartArray();
            for (Bson bson : this.pipeline) {
                BuildersHelper.encodeValue(bsonDocumentWriter, bson, codecRegistry);
            }
            bsonDocumentWriter.writeEndArray();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            UnionWithStage unionWithStage = (UnionWithStage)object;
            if (!this.collection.equals(unionWithStage.collection)) {
                return false;
            }
            return !Objects.equals(this.pipeline, unionWithStage.pipeline);
        }

        public int hashCode() {
            int n = this.collection.hashCode();
            n = 31 * n + (this.pipeline != null ? this.pipeline.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Stage{name='$unionWith', collection='" + this.collection + '\'' + ", pipeline=" + this.pipeline + '}';
        }
    }

    private static class MergeStage
    implements Bson {
        private final BsonValue intoValue;
        private final MergeOptions options;

        MergeStage(BsonValue bsonValue, MergeOptions mergeOptions) {
            this.intoValue = bsonValue;
            this.options = mergeOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument("$merge");
            bsonDocumentWriter.writeName("into");
            if (this.intoValue.isString()) {
                bsonDocumentWriter.writeString(this.intoValue.asString().getValue());
            } else {
                bsonDocumentWriter.writeStartDocument();
                bsonDocumentWriter.writeString("db", this.intoValue.asDocument().getString("db").getValue());
                bsonDocumentWriter.writeString("coll", this.intoValue.asDocument().getString("coll").getValue());
                bsonDocumentWriter.writeEndDocument();
            }
            if (this.options.getUniqueIdentifier() != null) {
                if (this.options.getUniqueIdentifier().size() == 1) {
                    bsonDocumentWriter.writeString("on", this.options.getUniqueIdentifier().get(0));
                } else {
                    bsonDocumentWriter.writeStartArray("on");
                    for (String object : this.options.getUniqueIdentifier()) {
                        bsonDocumentWriter.writeString(object);
                    }
                    bsonDocumentWriter.writeEndArray();
                }
            }
            if (this.options.getVariables() != null) {
                bsonDocumentWriter.writeStartDocument("let");
                for (Variable variable : this.options.getVariables()) {
                    bsonDocumentWriter.writeName(variable.getName());
                    BuildersHelper.encodeValue(bsonDocumentWriter, variable.getValue(), codecRegistry);
                }
                bsonDocumentWriter.writeEndDocument();
            }
            if (this.options.getWhenMatched() != null) {
                bsonDocumentWriter.writeName("whenMatched");
                switch (this.options.getWhenMatched()) {
                    case REPLACE: {
                        bsonDocumentWriter.writeString("replace");
                        break;
                    }
                    case KEEP_EXISTING: {
                        bsonDocumentWriter.writeString("keepExisting");
                        break;
                    }
                    case MERGE: {
                        bsonDocumentWriter.writeString("merge");
                        break;
                    }
                    case PIPELINE: {
                        bsonDocumentWriter.writeStartArray();
                        for (Bson bson : this.options.getWhenMatchedPipeline()) {
                            BuildersHelper.encodeValue(bsonDocumentWriter, bson, codecRegistry);
                        }
                        bsonDocumentWriter.writeEndArray();
                        break;
                    }
                    case FAIL: {
                        bsonDocumentWriter.writeString("fail");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected value: " + (Object)((Object)this.options.getWhenMatched()));
                    }
                }
            }
            if (this.options.getWhenNotMatched() != null) {
                bsonDocumentWriter.writeName("whenNotMatched");
                switch (this.options.getWhenNotMatched()) {
                    case INSERT: {
                        bsonDocumentWriter.writeString("insert");
                        break;
                    }
                    case DISCARD: {
                        bsonDocumentWriter.writeString("discard");
                        break;
                    }
                    case FAIL: {
                        bsonDocumentWriter.writeString("fail");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected value: " + (Object)((Object)this.options.getWhenNotMatched()));
                    }
                }
            }
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MergeStage mergeStage = (MergeStage)object;
            if (!this.intoValue.equals(mergeStage.intoValue)) {
                return false;
            }
            return this.options.equals(mergeStage.options);
        }

        public int hashCode() {
            int n = this.intoValue.hashCode();
            n = 31 * n + this.options.hashCode();
            return n;
        }

        public String toString() {
            return "Stage{name='$merge', , into=" + this.intoValue + ", options=" + this.options + '}';
        }
    }

    private static class ReplaceStage<TExpression>
    implements Bson {
        private final TExpression value;
        private final boolean replaceWith;

        ReplaceStage(TExpression TExpression) {
            this(TExpression, false);
        }

        ReplaceStage(TExpression TExpression, boolean bl) {
            this.value = TExpression;
            this.replaceWith = bl;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            if (this.replaceWith) {
                bsonDocumentWriter.writeName("$replaceWith");
                BuildersHelper.encodeValue(bsonDocumentWriter, this.value, codecRegistry);
            } else {
                bsonDocumentWriter.writeName("$replaceRoot");
                bsonDocumentWriter.writeStartDocument();
                bsonDocumentWriter.writeName("newRoot");
                BuildersHelper.encodeValue(bsonDocumentWriter, this.value, codecRegistry);
                bsonDocumentWriter.writeEndDocument();
            }
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ReplaceStage replaceStage = (ReplaceStage)object;
            return Objects.equals(this.value, replaceStage.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "Stage{name='$replaceRoot', value=" + this.value + '}';
        }
    }

    private static final class SetWindowFieldsStage<TExpression>
    implements Bson {
        @Nullable
        private final TExpression partitionBy;
        @Nullable
        private final Bson sortBy;
        private final Iterable<? extends WindowOutputField> output;

        SetWindowFieldsStage(@Nullable TExpression TExpression, @Nullable Bson bson, Iterable<? extends WindowOutputField> iterable) {
            this.partitionBy = TExpression;
            this.sortBy = bson;
            this.output = iterable;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument("$setWindowFields");
            if (this.partitionBy != null) {
                bsonDocumentWriter.writeName("partitionBy");
                BuildersHelper.encodeValue(bsonDocumentWriter, this.partitionBy, codecRegistry);
            }
            if (this.sortBy != null) {
                bsonDocumentWriter.writeName("sortBy");
                BuildersHelper.encodeValue(bsonDocumentWriter, this.sortBy, codecRegistry);
            }
            bsonDocumentWriter.writeStartDocument("output");
            for (WindowOutputField windowOutputField : this.output) {
                BsonField bsonField = windowOutputField.toBsonField();
                bsonDocumentWriter.writeName(bsonField.getName());
                BuildersHelper.encodeValue(bsonDocumentWriter, bsonField.getValue(), codecRegistry);
            }
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SetWindowFieldsStage setWindowFieldsStage = (SetWindowFieldsStage)object;
            return Objects.equals(this.partitionBy, setWindowFieldsStage.partitionBy) && Objects.equals(this.sortBy, setWindowFieldsStage.sortBy) && this.output.equals(setWindowFieldsStage.output);
        }

        public int hashCode() {
            return Objects.hash(this.partitionBy, this.sortBy, this.output);
        }

        public String toString() {
            return "Stage{name='$setWindowFields', partitionBy=" + this.partitionBy + ", sortBy=" + this.sortBy + ", output=" + this.output + '}';
        }
    }

    private static final class SearchStage
    implements Bson {
        private final String name;
        private final Bson operatorOrCollector;
        @Nullable
        private final SearchOptions options;

        SearchStage(String string, Bson bson, @Nullable SearchOptions searchOptions) {
            this.name = string;
            this.operatorOrCollector = bson;
            this.options = searchOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartDocument(this.name);
            BsonDocument bsonDocument = this.operatorOrCollector.toBsonDocument(clazz, codecRegistry);
            Assertions.assertTrue(bsonDocument.size() == 1);
            Map.Entry<String, BsonValue> entry = bsonDocument.entrySet().iterator().next();
            bsonDocumentWriter.writeName(entry.getKey());
            BuildersHelper.encodeValue(bsonDocumentWriter, entry.getValue(), codecRegistry);
            if (this.options != null) {
                this.options.toBsonDocument(clazz, codecRegistry).forEach((string, bsonValue) -> {
                    bsonDocumentWriter.writeName((String)string);
                    BuildersHelper.encodeValue(bsonDocumentWriter, bsonValue, codecRegistry);
                });
            }
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SearchStage searchStage = (SearchStage)object;
            return this.name.equals(searchStage.name) && this.operatorOrCollector.equals(searchStage.operatorOrCollector) && Objects.equals(this.options, searchStage.options);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.operatorOrCollector, this.options);
        }

        public String toString() {
            return "Stage{name='" + this.name + "', operatorOrCollector=" + this.operatorOrCollector + ", options=" + this.options + '}';
        }
    }

    private static class VectorSearchBson
    implements Bson {
        private final FieldSearchPath path;
        private final Object queryVector;
        private final String index;
        private final long limit;
        private final VectorSearchOptions options;

        VectorSearchBson(FieldSearchPath fieldSearchPath, Object object, String string, long l, VectorSearchOptions vectorSearchOptions) {
            this.path = fieldSearchPath;
            this.queryVector = object;
            this.index = string;
            this.limit = l;
            this.options = vectorSearchOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            Document document = new Document("path", this.path.toValue()).append("queryVector", this.queryVector).append("index", this.index).append("limit", this.limit);
            document.putAll(this.options.toBsonDocument(clazz, codecRegistry));
            return new Document("$vectorSearch", document).toBsonDocument(clazz, codecRegistry);
        }

        public String toString() {
            return "Stage{name=$vectorSearch, path=" + this.path + ", queryVector=" + this.queryVector + ", index=" + this.index + ", limit=" + this.limit + ", options=" + this.options + '}';
        }
    }
}

