/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import org.bson.conversions.Bson;

public final class BsonField {
    private final String name;
    private final Bson value;

    public BsonField(String string, Bson bson) {
        this.name = Assertions.notNull("name", string);
        this.value = Assertions.notNull("value", bson);
    }

    public String getName() {
        return this.name;
    }

    public Bson getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonField bsonField = (BsonField)object;
        if (!this.name.equals(bsonField.name)) {
            return false;
        }
        return this.value.equals(bsonField.value);
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = 31 * n + this.value.hashCode();
        return n;
    }

    public String toString() {
        return "BsonField{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

