/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BucketGranularity;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class BucketAutoOptions {
    private List<BsonField> output;
    private BucketGranularity granularity;

    @Nullable
    public BucketGranularity getGranularity() {
        return this.granularity;
    }

    @Nullable
    public List<BsonField> getOutput() {
        return this.output == null ? null : new ArrayList<BsonField>(this.output);
    }

    public BucketAutoOptions granularity(@Nullable BucketGranularity bucketGranularity) {
        this.granularity = bucketGranularity;
        return this;
    }

    public BucketAutoOptions output(BsonField ... bsonFieldArray) {
        this.output = Arrays.asList(bsonFieldArray);
        return this;
    }

    public BucketAutoOptions output(@Nullable List<BsonField> list) {
        this.output = list;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BucketAutoOptions bucketAutoOptions = (BucketAutoOptions)object;
        if (!Objects.equals(this.output, bucketAutoOptions.output)) {
            return false;
        }
        return this.granularity == bucketAutoOptions.granularity;
    }

    public int hashCode() {
        int n = this.output != null ? this.output.hashCode() : 0;
        n = 31 * n + (this.granularity != null ? this.granularity.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "BucketAutoOptions{output=" + this.output + ", granularity=" + (Object)((Object)this.granularity) + '}';
    }
}

