/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.lang.Nullable;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public final class BulkWriteOptions {
    private boolean ordered = true;
    private Boolean bypassDocumentValidation;
    private BsonValue comment;
    private Bson variables;

    public boolean isOrdered() {
        return this.ordered;
    }

    public BulkWriteOptions ordered(boolean bl) {
        this.ordered = bl;
        return this;
    }

    @Nullable
    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public BulkWriteOptions bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public BulkWriteOptions comment(@Nullable String string) {
        this.comment = string != null ? new BsonString(string) : null;
        return this;
    }

    public BulkWriteOptions comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Nullable
    public Bson getLet() {
        return this.variables;
    }

    public BulkWriteOptions let(@Nullable Bson bson) {
        this.variables = bson;
        return this;
    }

    public String toString() {
        return "BulkWriteOptions{ordered=" + this.ordered + ", bypassDocumentValidation=" + this.bypassDocumentValidation + ", comment=" + this.comment + ", let=" + this.variables + '}';
    }
}

