/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.lang.Nullable;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

public final class Collation {
    private final String locale;
    private final Boolean caseLevel;
    private final CollationCaseFirst caseFirst;
    private final CollationStrength strength;
    private final Boolean numericOrdering;
    private final CollationAlternate alternate;
    private final CollationMaxVariable maxVariable;
    private final Boolean normalization;
    private final Boolean backwards;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Collation collation) {
        return new Builder(collation);
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    @Nullable
    public Boolean getCaseLevel() {
        return this.caseLevel;
    }

    @Nullable
    public CollationCaseFirst getCaseFirst() {
        return this.caseFirst;
    }

    @Nullable
    public CollationStrength getStrength() {
        return this.strength;
    }

    @Nullable
    public Boolean getNumericOrdering() {
        return this.numericOrdering;
    }

    @Nullable
    public CollationAlternate getAlternate() {
        return this.alternate;
    }

    @Nullable
    public CollationMaxVariable getMaxVariable() {
        return this.maxVariable;
    }

    @Nullable
    public Boolean getNormalization() {
        return this.normalization;
    }

    @Nullable
    public Boolean getBackwards() {
        return this.backwards;
    }

    public BsonDocument asDocument() {
        BsonDocument bsonDocument = new BsonDocument();
        if (this.locale != null) {
            bsonDocument.put("locale", new BsonString(this.locale));
        }
        if (this.caseLevel != null) {
            bsonDocument.put("caseLevel", new BsonBoolean(this.caseLevel));
        }
        if (this.caseFirst != null) {
            bsonDocument.put("caseFirst", new BsonString(this.caseFirst.getValue()));
        }
        if (this.strength != null) {
            bsonDocument.put("strength", new BsonInt32(this.strength.getIntRepresentation()));
        }
        if (this.numericOrdering != null) {
            bsonDocument.put("numericOrdering", new BsonBoolean(this.numericOrdering));
        }
        if (this.alternate != null) {
            bsonDocument.put("alternate", new BsonString(this.alternate.getValue()));
        }
        if (this.maxVariable != null) {
            bsonDocument.put("maxVariable", new BsonString(this.maxVariable.getValue()));
        }
        if (this.normalization != null) {
            bsonDocument.put("normalization", new BsonBoolean(this.normalization));
        }
        if (this.backwards != null) {
            bsonDocument.put("backwards", new BsonBoolean(this.backwards));
        }
        return bsonDocument;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Collation collation = (Collation)object;
        if (this.locale != null ? !this.locale.equals(collation.getLocale()) : collation.getLocale() != null) {
            return false;
        }
        if (this.caseLevel != null ? !this.caseLevel.equals(collation.getCaseLevel()) : collation.getCaseLevel() != null) {
            return false;
        }
        if (this.getCaseFirst() != collation.getCaseFirst()) {
            return false;
        }
        if (this.getStrength() != collation.getStrength()) {
            return false;
        }
        if (this.numericOrdering != null ? !this.numericOrdering.equals(collation.getNumericOrdering()) : collation.getNumericOrdering() != null) {
            return false;
        }
        if (this.getAlternate() != collation.getAlternate()) {
            return false;
        }
        if (this.getMaxVariable() != collation.getMaxVariable()) {
            return false;
        }
        if (this.normalization != null ? !this.normalization.equals(collation.getNormalization()) : collation.getNormalization() != null) {
            return false;
        }
        return !(this.backwards != null ? !this.backwards.equals(collation.getBackwards()) : collation.getBackwards() != null);
    }

    public int hashCode() {
        int n = this.locale != null ? this.locale.hashCode() : 0;
        n = 31 * n + (this.caseLevel != null ? this.caseLevel.hashCode() : 0);
        n = 31 * n + (this.caseFirst != null ? this.caseFirst.hashCode() : 0);
        n = 31 * n + (this.strength != null ? this.strength.hashCode() : 0);
        n = 31 * n + (this.numericOrdering != null ? this.numericOrdering.hashCode() : 0);
        n = 31 * n + (this.alternate != null ? this.alternate.hashCode() : 0);
        n = 31 * n + (this.maxVariable != null ? this.maxVariable.hashCode() : 0);
        n = 31 * n + (this.normalization != null ? this.normalization.hashCode() : 0);
        n = 31 * n + (this.backwards != null ? this.backwards.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Collation{locale='" + this.locale + "', caseLevel=" + this.caseLevel + ", caseFirst=" + (Object)((Object)this.caseFirst) + ", strength=" + (Object)((Object)this.strength) + ", numericOrdering=" + this.numericOrdering + ", alternate=" + (Object)((Object)this.alternate) + ", maxVariable=" + (Object)((Object)this.maxVariable) + ", normalization=" + this.normalization + ", backwards=" + this.backwards + "}";
    }

    private Collation(Builder builder) {
        this.locale = builder.locale;
        this.caseLevel = builder.caseLevel;
        this.caseFirst = builder.caseFirst;
        this.strength = builder.strength;
        this.numericOrdering = builder.numericOrdering;
        this.alternate = builder.alternate;
        this.maxVariable = builder.maxVariable;
        this.normalization = builder.normalization;
        this.backwards = builder.backwards;
    }

    @NotThreadSafe
    public static final class Builder {
        private String locale;
        private Boolean caseLevel;
        private CollationCaseFirst caseFirst;
        private CollationStrength strength;
        private Boolean numericOrdering;
        private CollationAlternate alternate;
        private CollationMaxVariable maxVariable;
        private Boolean normalization;
        private Boolean backwards;

        private Builder() {
        }

        private Builder(Collation collation) {
            this.locale = collation.getLocale();
            this.caseLevel = collation.getCaseLevel();
            this.caseFirst = collation.getCaseFirst();
            this.strength = collation.getStrength();
            this.numericOrdering = collation.getNumericOrdering();
            this.alternate = collation.getAlternate();
            this.maxVariable = collation.getMaxVariable();
            this.normalization = collation.getNormalization();
            this.backwards = collation.getBackwards();
        }

        public Builder locale(@Nullable String string) {
            this.locale = string;
            return this;
        }

        public Builder caseLevel(@Nullable Boolean bl) {
            this.caseLevel = bl;
            return this;
        }

        public Builder collationCaseFirst(@Nullable CollationCaseFirst collationCaseFirst) {
            this.caseFirst = collationCaseFirst;
            return this;
        }

        public Builder collationStrength(@Nullable CollationStrength collationStrength) {
            this.strength = collationStrength;
            return this;
        }

        public Builder numericOrdering(@Nullable Boolean bl) {
            this.numericOrdering = bl;
            return this;
        }

        public Builder collationAlternate(@Nullable CollationAlternate collationAlternate) {
            this.alternate = collationAlternate;
            return this;
        }

        public Builder collationMaxVariable(@Nullable CollationMaxVariable collationMaxVariable) {
            this.maxVariable = collationMaxVariable;
            return this;
        }

        public Builder normalization(@Nullable Boolean bl) {
            this.normalization = bl;
            return this;
        }

        public Builder backwards(@Nullable Boolean bl) {
            this.backwards = bl;
            return this;
        }

        public Collation build() {
            return new Collation(this);
        }
    }
}

