/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

public enum CollationStrength {
    PRIMARY(1),
    SECONDARY(2),
    TERTIARY(3),
    QUATERNARY(4),
    IDENTICAL(5);

    private final int intRepresentation;

    private CollationStrength(int n2) {
        this.intRepresentation = n2;
    }

    public int getIntRepresentation() {
        return this.intRepresentation;
    }

    public static CollationStrength fromInt(int n) {
        switch (n) {
            case 1: {
                return PRIMARY;
            }
            case 2: {
                return SECONDARY;
            }
            case 3: {
                return TERTIARY;
            }
            case 4: {
                return QUATERNARY;
            }
            case 5: {
                return IDENTICAL;
            }
        }
        throw new IllegalArgumentException(n + " is not a valid collation strength");
    }
}

