/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;

public class EstimatedDocumentCountOptions {
    private long maxTimeMS;
    private BsonValue comment;

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public EstimatedDocumentCountOptions maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public EstimatedDocumentCountOptions comment(@Nullable String string) {
        this.comment = string == null ? null : new BsonString(string);
        return this;
    }

    public EstimatedDocumentCountOptions comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    public String toString() {
        return "EstimatedCountOptions{, maxTimeMS=" + this.maxTimeMS + ", comment=" + this.comment + '}';
    }
}

