/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bson.conversions.Bson;

public class Facet {
    private final String name;
    private final List<? extends Bson> pipeline;

    public Facet(String string, List<? extends Bson> list) {
        this.name = string;
        this.pipeline = list;
    }

    public Facet(String string, Bson ... bsonArray) {
        this(string, Arrays.asList(bsonArray));
    }

    public String getName() {
        return this.name;
    }

    public List<? extends Bson> getPipeline() {
        return this.pipeline;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Facet facet = (Facet)object;
        if (!Objects.equals(this.name, facet.name)) {
            return false;
        }
        return Objects.equals(this.pipeline, facet.pipeline);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 31 * n + (this.pipeline != null ? this.pipeline.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Facet{name='" + this.name + '\'' + ", pipeline=" + this.pipeline + '}';
    }
}

