/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.TextSearchOptions;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Filters {
    private Filters() {
    }

    public static <TItem> Bson eq(@Nullable TItem TItem) {
        return Filters.eq("_id", TItem);
    }

    public static <TItem> Bson eq(String string, @Nullable TItem TItem) {
        return new SimpleEncodingFilter<TItem>(string, TItem);
    }

    public static <TItem> Bson ne(String string, @Nullable TItem TItem) {
        return new OperatorFilter<TItem>("$ne", string, TItem);
    }

    public static <TItem> Bson gt(String string, TItem TItem) {
        return new OperatorFilter<TItem>("$gt", string, TItem);
    }

    public static <TItem> Bson lt(String string, TItem TItem) {
        return new OperatorFilter<TItem>("$lt", string, TItem);
    }

    public static <TItem> Bson gte(String string, TItem TItem) {
        return new OperatorFilter<TItem>("$gte", string, TItem);
    }

    public static <TItem> Bson lte(String string, TItem TItem) {
        return new OperatorFilter<TItem>("$lte", string, TItem);
    }

    @SafeVarargs
    public static <TItem> Bson in(String string, TItem ... TItemArray) {
        return Filters.in(string, Arrays.asList(TItemArray));
    }

    public static <TItem> Bson in(String string, Iterable<TItem> iterable) {
        return new IterableOperatorFilter<TItem>(string, "$in", iterable);
    }

    @SafeVarargs
    public static <TItem> Bson nin(String string, TItem ... TItemArray) {
        return Filters.nin(string, Arrays.asList(TItemArray));
    }

    public static <TItem> Bson nin(String string, Iterable<TItem> iterable) {
        return new IterableOperatorFilter<TItem>(string, "$nin", iterable);
    }

    public static Bson and(Iterable<Bson> iterable) {
        return new AndFilter(iterable);
    }

    public static Bson and(Bson ... bsonArray) {
        return Filters.and(Arrays.asList(bsonArray));
    }

    public static Bson or(Iterable<Bson> iterable) {
        return new OrNorFilter(OrNorFilter.Operator.OR, iterable);
    }

    public static Bson or(Bson ... bsonArray) {
        return Filters.or(Arrays.asList(bsonArray));
    }

    public static Bson not(Bson bson) {
        return new NotFilter(bson);
    }

    public static Bson nor(Bson ... bsonArray) {
        return Filters.nor(Arrays.asList(bsonArray));
    }

    public static Bson nor(Iterable<Bson> iterable) {
        return new OrNorFilter(OrNorFilter.Operator.NOR, iterable);
    }

    public static Bson exists(String string) {
        return Filters.exists(string, true);
    }

    public static Bson exists(String string, boolean bl) {
        return new OperatorFilter<BsonBoolean>("$exists", string, BsonBoolean.valueOf(bl));
    }

    public static Bson type(String string, BsonType bsonType) {
        return new OperatorFilter<BsonInt32>("$type", string, new BsonInt32(bsonType.getValue()));
    }

    public static Bson type(String string, String string2) {
        return new OperatorFilter<BsonString>("$type", string, new BsonString(string2));
    }

    public static Bson mod(String string, long l, long l2) {
        return new OperatorFilter<BsonArray>("$mod", string, new BsonArray(Arrays.asList(new BsonInt64(l), new BsonInt64(l2))));
    }

    public static Bson regex(String string, String string2) {
        return Filters.regex(string, string2, null);
    }

    public static Bson regex(String string, String string2, @Nullable String string3) {
        Assertions.notNull("pattern", string2);
        return new SimpleFilter(string, new BsonRegularExpression(string2, string3));
    }

    public static Bson regex(String string, Pattern pattern) {
        Assertions.notNull("pattern", pattern);
        return new SimpleEncodingFilter<Pattern>(string, pattern);
    }

    public static Bson text(String string) {
        Assertions.notNull("search", string);
        return Filters.text(string, new TextSearchOptions());
    }

    public static Bson text(String string, TextSearchOptions textSearchOptions) {
        Assertions.notNull("search", string);
        Assertions.notNull("textSearchOptions", textSearchOptions);
        return new TextFilter(string, textSearchOptions);
    }

    public static Bson where(String string) {
        Assertions.notNull("javaScriptExpression", string);
        return new BsonDocument("$where", new BsonString(string));
    }

    public static <TExpression> Bson expr(TExpression TExpression) {
        return new SimpleEncodingFilter<TExpression>("$expr", TExpression);
    }

    @SafeVarargs
    public static <TItem> Bson all(String string, TItem ... TItemArray) {
        return Filters.all(string, Arrays.asList(TItemArray));
    }

    public static <TItem> Bson all(String string, Iterable<TItem> iterable) {
        return new IterableOperatorFilter<TItem>(string, "$all", iterable);
    }

    public static Bson elemMatch(final String string, final Bson bson) {
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
                return new BsonDocument(string, new BsonDocument("$elemMatch", bson.toBsonDocument(clazz, codecRegistry)));
            }
        };
    }

    public static Bson size(String string, int n) {
        return new OperatorFilter<Integer>("$size", string, n);
    }

    public static Bson bitsAllClear(String string, long l) {
        return new OperatorFilter<Long>("$bitsAllClear", string, l);
    }

    public static Bson bitsAllSet(String string, long l) {
        return new OperatorFilter<Long>("$bitsAllSet", string, l);
    }

    public static Bson bitsAnyClear(String string, long l) {
        return new OperatorFilter<Long>("$bitsAnyClear", string, l);
    }

    public static Bson bitsAnySet(String string, long l) {
        return new OperatorFilter<Long>("$bitsAnySet", string, l);
    }

    public static Bson geoWithin(String string, Geometry geometry) {
        return new GeometryOperatorFilter<Geometry>("$geoWithin", string, geometry);
    }

    public static Bson geoWithin(String string, Bson bson) {
        return new GeometryOperatorFilter<Bson>("$geoWithin", string, bson);
    }

    public static Bson geoWithinBox(String string, double d, double d2, double d3, double d4) {
        BsonDocument bsonDocument = new BsonDocument("$box", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(d), new BsonDouble(d2))), new BsonArray(Arrays.asList(new BsonDouble(d3), new BsonDouble(d4))))));
        return new OperatorFilter<BsonDocument>("$geoWithin", string, bsonDocument);
    }

    public static Bson geoWithinPolygon(String string, List<List<Double>> list) {
        BsonArray bsonArray = new BsonArray(list.size());
        for (List<Double> list2 : list) {
            bsonArray.add(new BsonArray(Arrays.asList(new BsonDouble(list2.get(0)), new BsonDouble(list2.get(1)))));
        }
        BsonDocument bsonDocument = new BsonDocument("$polygon", bsonArray);
        return new OperatorFilter<Object>("$geoWithin", string, bsonDocument);
    }

    public static Bson geoWithinCenter(String string, double d, double d2, double d3) {
        BsonDocument bsonDocument = new BsonDocument("$center", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(d), new BsonDouble(d2))), new BsonDouble(d3))));
        return new OperatorFilter<BsonDocument>("$geoWithin", string, bsonDocument);
    }

    public static Bson geoWithinCenterSphere(String string, double d, double d2, double d3) {
        BsonDocument bsonDocument = new BsonDocument("$centerSphere", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(d), new BsonDouble(d2))), new BsonDouble(d3))));
        return new OperatorFilter<BsonDocument>("$geoWithin", string, bsonDocument);
    }

    public static Bson geoIntersects(String string, Bson bson) {
        return new GeometryOperatorFilter<Bson>("$geoIntersects", string, bson);
    }

    public static Bson geoIntersects(String string, Geometry geometry) {
        return new GeometryOperatorFilter<Geometry>("$geoIntersects", string, geometry);
    }

    public static Bson near(String string, Point point, @Nullable Double d, @Nullable Double d2) {
        return new GeometryOperatorFilter<Point>("$near", string, point, d, d2);
    }

    public static Bson near(String string, Bson bson, @Nullable Double d, @Nullable Double d2) {
        return new GeometryOperatorFilter<Bson>("$near", string, bson, d, d2);
    }

    public static Bson near(String string, double d, double d2, @Nullable Double d3, @Nullable Double d4) {
        return Filters.createNearFilterDocument(string, d, d2, d3, d4, "$near");
    }

    public static Bson nearSphere(String string, Point point, @Nullable Double d, @Nullable Double d2) {
        return new GeometryOperatorFilter<Point>("$nearSphere", string, point, d, d2);
    }

    public static Bson nearSphere(String string, Bson bson, @Nullable Double d, @Nullable Double d2) {
        return new GeometryOperatorFilter<Bson>("$nearSphere", string, bson, d, d2);
    }

    public static Bson nearSphere(String string, double d, double d2, @Nullable Double d3, @Nullable Double d4) {
        return Filters.createNearFilterDocument(string, d, d2, d3, d4, "$nearSphere");
    }

    public static Bson jsonSchema(Bson bson) {
        return new SimpleEncodingFilter<Bson>("$jsonSchema", bson);
    }

    public static Bson empty() {
        return new BsonDocument();
    }

    private static Bson createNearFilterDocument(String string, double d, double d2, @Nullable Double d3, @Nullable Double d4, String string2) {
        BsonDocument bsonDocument = new BsonDocument(string2, new BsonArray(Arrays.asList(new BsonDouble(d), new BsonDouble(d2))));
        if (d3 != null) {
            bsonDocument.append("$maxDistance", new BsonDouble(d3));
        }
        if (d4 != null) {
            bsonDocument.append("$minDistance", new BsonDouble(d4));
        }
        return new BsonDocument(string, bsonDocument);
    }

    private static String operatorFilterToString(String string, String string2, Object object) {
        return "Operator Filter{fieldName='" + string + '\'' + ", operator='" + string2 + '\'' + ", value=" + object + '}';
    }

    private static class SimpleEncodingFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final TItem value;

        SimpleEncodingFilter(String string, @Nullable TItem TItem) {
            this.fieldName = Assertions.notNull("fieldName", string);
            this.value = TItem;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.fieldName);
            BuildersHelper.encodeValue(bsonDocumentWriter, this.value, codecRegistry);
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimpleEncodingFilter simpleEncodingFilter = (SimpleEncodingFilter)object;
            if (!this.fieldName.equals(simpleEncodingFilter.fieldName)) {
                return false;
            }
            return Objects.equals(this.value, simpleEncodingFilter.value);
        }

        public int hashCode() {
            int n = this.fieldName.hashCode();
            n = 31 * n + (this.value != null ? this.value.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Filter{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + '}';
        }
    }

    private static final class OperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem value;

        OperatorFilter(String string, String string2, @Nullable TItem TItem) {
            this.operatorName = Assertions.notNull("operatorName", string);
            this.fieldName = Assertions.notNull("fieldName", string2);
            this.value = TItem;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.fieldName);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.operatorName);
            BuildersHelper.encodeValue(bsonDocumentWriter, this.value, codecRegistry);
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OperatorFilter operatorFilter = (OperatorFilter)object;
            if (!this.operatorName.equals(operatorFilter.operatorName)) {
                return false;
            }
            if (!this.fieldName.equals(operatorFilter.fieldName)) {
                return false;
            }
            return Objects.equals(this.value, operatorFilter.value);
        }

        public int hashCode() {
            int n = this.operatorName.hashCode();
            n = 31 * n + this.fieldName.hashCode();
            n = 31 * n + (this.value != null ? this.value.hashCode() : 0);
            return n;
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, this.operatorName, this.value);
        }
    }

    private static class IterableOperatorFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final String operatorName;
        private final Iterable<TItem> values;

        IterableOperatorFilter(String string, String string2, Iterable<TItem> iterable) {
            this.fieldName = Assertions.notNull("fieldName", string);
            this.operatorName = Assertions.notNull("operatorName", string2);
            this.values = Assertions.notNull("values", iterable);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.fieldName);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.operatorName);
            bsonDocumentWriter.writeStartArray();
            for (TItem TItem : this.values) {
                BuildersHelper.encodeValue(bsonDocumentWriter, TItem, codecRegistry);
            }
            bsonDocumentWriter.writeEndArray();
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IterableOperatorFilter iterableOperatorFilter = (IterableOperatorFilter)object;
            if (!this.fieldName.equals(iterableOperatorFilter.fieldName)) {
                return false;
            }
            if (!this.operatorName.equals(iterableOperatorFilter.operatorName)) {
                return false;
            }
            return this.values.equals(iterableOperatorFilter.values);
        }

        public int hashCode() {
            int n = this.fieldName.hashCode();
            n = 31 * n + this.operatorName.hashCode();
            n = 31 * n + this.values.hashCode();
            return n;
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, this.operatorName, this.values);
        }
    }

    private static class AndFilter
    implements Bson {
        private final Iterable<Bson> filters;

        AndFilter(Iterable<Bson> iterable) {
            this.filters = Assertions.notNull("filters", iterable);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonArray bsonArray = new BsonArray();
            for (Bson bson : this.filters) {
                bsonArray.add(bson.toBsonDocument(clazz, codecRegistry));
            }
            return new BsonDocument("$and", bsonArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AndFilter andFilter = (AndFilter)object;
            return this.filters.equals(andFilter.filters);
        }

        public int hashCode() {
            return this.filters.hashCode();
        }

        public String toString() {
            return "And Filter{filters=" + this.filters + '}';
        }
    }

    private static class OrNorFilter
    implements Bson {
        private final Operator operator;
        private final Iterable<Bson> filters;

        OrNorFilter(Operator operator, Iterable<Bson> iterable) {
            this.operator = Assertions.notNull("operator", operator);
            this.filters = Assertions.notNull("filters", iterable);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocument bsonDocument = new BsonDocument();
            BsonArray bsonArray = new BsonArray();
            for (Bson bson : this.filters) {
                bsonArray.add(bson.toBsonDocument(clazz, codecRegistry));
            }
            bsonDocument.put(this.operator.name, bsonArray);
            return bsonDocument;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OrNorFilter orNorFilter = (OrNorFilter)object;
            if (this.operator != orNorFilter.operator) {
                return false;
            }
            return this.filters.equals(orNorFilter.filters);
        }

        public int hashCode() {
            int n = this.operator.hashCode();
            n = 31 * n + this.filters.hashCode();
            return n;
        }

        public String toString() {
            return this.operator.toStringName + " Filter{filters=" + this.filters + '}';
        }

        private static enum Operator {
            OR("$or", "Or"),
            NOR("$nor", "Nor");

            private final String name;
            private final String toStringName;

            private Operator(String string2, String string3) {
                this.name = string2;
                this.toStringName = string3;
            }
        }
    }

    private static class NotFilter
    implements Bson {
        private static final Set<String> DBREF_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$ref", "$id")));
        private static final Set<String> DBREF_KEYS_WITH_DB = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$ref", "$id", "$db")));
        private final Bson filter;

        NotFilter(Bson bson) {
            this.filter = Assertions.notNull("filter", bson);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocument bsonDocument = this.filter.toBsonDocument(clazz, codecRegistry);
            if (bsonDocument.size() == 1) {
                Map.Entry<String, BsonValue> entry = bsonDocument.entrySet().iterator().next();
                return this.createFilter(entry.getKey(), entry.getValue());
            }
            BsonArray bsonArray = new BsonArray(bsonDocument.size());
            for (Map.Entry<String, BsonValue> entry : bsonDocument.entrySet()) {
                bsonArray.add(new BsonDocument(entry.getKey(), entry.getValue()));
            }
            return this.createFilter("$and", bsonArray);
        }

        private boolean containsOperator(BsonDocument bsonDocument) {
            Set<String> set = bsonDocument.keySet();
            if (set.equals(DBREF_KEYS) || set.equals(DBREF_KEYS_WITH_DB)) {
                return false;
            }
            for (String string : set) {
                if (!string.startsWith("$")) continue;
                return true;
            }
            return false;
        }

        private BsonDocument createFilter(String string, BsonValue bsonValue) {
            if (string.startsWith("$")) {
                return new BsonDocument("$not", new BsonDocument(string, bsonValue));
            }
            if (bsonValue.isDocument() && this.containsOperator(bsonValue.asDocument()) || bsonValue.isRegularExpression()) {
                return new BsonDocument(string, new BsonDocument("$not", bsonValue));
            }
            return new BsonDocument(string, new BsonDocument("$not", new BsonDocument("$eq", bsonValue)));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            NotFilter notFilter = (NotFilter)object;
            return this.filter.equals(notFilter.filter);
        }

        public int hashCode() {
            return this.filter.hashCode();
        }

        public String toString() {
            return "Not Filter{filter=" + this.filter + '}';
        }
    }

    private static final class SimpleFilter
    implements Bson {
        private final String fieldName;
        private final BsonValue value;

        private SimpleFilter(String string, BsonValue bsonValue) {
            this.fieldName = Assertions.notNull("fieldName", string);
            this.value = Assertions.notNull("value", bsonValue);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, this.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimpleFilter simpleFilter = (SimpleFilter)object;
            if (!this.fieldName.equals(simpleFilter.fieldName)) {
                return false;
            }
            return this.value.equals(simpleFilter.value);
        }

        public int hashCode() {
            int n = this.fieldName.hashCode();
            n = 31 * n + this.value.hashCode();
            return n;
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, "$eq", this.value);
        }
    }

    private static class TextFilter
    implements Bson {
        private final String search;
        private final TextSearchOptions textSearchOptions;

        TextFilter(String string, TextSearchOptions textSearchOptions) {
            this.search = string;
            this.textSearchOptions = textSearchOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            Boolean bl;
            Boolean bl2;
            BsonDocument bsonDocument = new BsonDocument("$search", new BsonString(this.search));
            String string = this.textSearchOptions.getLanguage();
            if (string != null) {
                bsonDocument.put("$language", new BsonString(string));
            }
            if ((bl2 = this.textSearchOptions.getCaseSensitive()) != null) {
                bsonDocument.put("$caseSensitive", BsonBoolean.valueOf(bl2));
            }
            if ((bl = this.textSearchOptions.getDiacriticSensitive()) != null) {
                bsonDocument.put("$diacriticSensitive", BsonBoolean.valueOf(bl));
            }
            return new BsonDocument("$text", bsonDocument);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TextFilter textFilter = (TextFilter)object;
            if (!Objects.equals(this.search, textFilter.search)) {
                return false;
            }
            return Objects.equals(this.textSearchOptions, textFilter.textSearchOptions);
        }

        public int hashCode() {
            int n = this.search != null ? this.search.hashCode() : 0;
            n = 31 * n + (this.textSearchOptions != null ? this.textSearchOptions.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Text Filter{search='" + this.search + '\'' + ", textSearchOptions=" + this.textSearchOptions + '}';
        }
    }

    private static class GeometryOperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem geometry;
        private final Double maxDistance;
        private final Double minDistance;

        GeometryOperatorFilter(String string, String string2, TItem TItem) {
            this(string, string2, TItem, null, null);
        }

        GeometryOperatorFilter(String string, String string2, TItem TItem, @Nullable Double d, @Nullable Double d2) {
            this.operatorName = string;
            this.fieldName = Assertions.notNull("fieldName", string2);
            this.geometry = Assertions.notNull("geometry", TItem);
            this.maxDistance = d;
            this.minDistance = d2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.fieldName);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.operatorName);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName("$geometry");
            BuildersHelper.encodeValue(bsonDocumentWriter, this.geometry, codecRegistry);
            if (this.maxDistance != null) {
                bsonDocumentWriter.writeDouble("$maxDistance", this.maxDistance);
            }
            if (this.minDistance != null) {
                bsonDocumentWriter.writeDouble("$minDistance", this.minDistance);
            }
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GeometryOperatorFilter geometryOperatorFilter = (GeometryOperatorFilter)object;
            if (!Objects.equals(this.operatorName, geometryOperatorFilter.operatorName)) {
                return false;
            }
            if (!this.fieldName.equals(geometryOperatorFilter.fieldName)) {
                return false;
            }
            if (!this.geometry.equals(geometryOperatorFilter.geometry)) {
                return false;
            }
            if (!Objects.equals(this.maxDistance, geometryOperatorFilter.maxDistance)) {
                return false;
            }
            return Objects.equals(this.minDistance, geometryOperatorFilter.minDistance);
        }

        public int hashCode() {
            int n = this.operatorName != null ? this.operatorName.hashCode() : 0;
            n = 31 * n + this.fieldName.hashCode();
            n = 31 * n + this.geometry.hashCode();
            n = 31 * n + (this.maxDistance != null ? this.maxDistance.hashCode() : 0);
            n = 31 * n + (this.minDistance != null ? this.minDistance.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Geometry Operator Filter{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operatorName + '\'' + ", geometry=" + this.geometry + ", maxDistance=" + this.maxDistance + ", minDistance=" + this.minDistance + '}';
        }
    }
}

