/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class FindOneAndDeleteOptions {
    private Bson projection;
    private Bson sort;
    private long maxTimeMS;
    private Collation collation;
    private Bson hint;
    private String hintString;
    private BsonValue comment;
    private Bson variables;

    @Nullable
    public Bson getProjection() {
        return this.projection;
    }

    public FindOneAndDeleteOptions projection(@Nullable Bson bson) {
        this.projection = bson;
        return this;
    }

    @Nullable
    public Bson getSort() {
        return this.sort;
    }

    public FindOneAndDeleteOptions sort(@Nullable Bson bson) {
        this.sort = bson;
        return this;
    }

    public FindOneAndDeleteOptions maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public FindOneAndDeleteOptions collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public Bson getHint() {
        return this.hint;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public FindOneAndDeleteOptions hint(@Nullable Bson bson) {
        this.hint = bson;
        return this;
    }

    public FindOneAndDeleteOptions hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public FindOneAndDeleteOptions comment(@Nullable String string) {
        this.comment = string != null ? new BsonString(string) : null;
        return this;
    }

    public FindOneAndDeleteOptions comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Nullable
    public Bson getLet() {
        return this.variables;
    }

    public FindOneAndDeleteOptions let(Bson bson) {
        this.variables = bson;
        return this;
    }

    public String toString() {
        return "FindOneAndDeleteOptions{projection=" + this.projection + ", sort=" + this.sort + ", maxTimeMS=" + this.maxTimeMS + ", collation=" + this.collation + ", hint=" + this.hint + ", hintString='" + this.hintString + '\'' + ", comment=" + this.comment + ", let=" + this.variables + '}';
    }
}

