/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class FindOneAndReplaceOptions {
    private Bson projection;
    private Bson sort;
    private boolean upsert;
    private ReturnDocument returnDocument = ReturnDocument.BEFORE;
    private long maxTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private Bson hint;
    private String hintString;
    private BsonValue comment;
    private Bson variables;

    @Nullable
    public Bson getProjection() {
        return this.projection;
    }

    public FindOneAndReplaceOptions projection(@Nullable Bson bson) {
        this.projection = bson;
        return this;
    }

    @Nullable
    public Bson getSort() {
        return this.sort;
    }

    public FindOneAndReplaceOptions sort(@Nullable Bson bson) {
        this.sort = bson;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindOneAndReplaceOptions upsert(boolean bl) {
        this.upsert = bl;
        return this;
    }

    public ReturnDocument getReturnDocument() {
        return this.returnDocument;
    }

    public FindOneAndReplaceOptions returnDocument(ReturnDocument returnDocument) {
        this.returnDocument = Assertions.notNull("returnDocument", returnDocument);
        return this;
    }

    public FindOneAndReplaceOptions maxTime(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindOneAndReplaceOptions bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public FindOneAndReplaceOptions collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public Bson getHint() {
        return this.hint;
    }

    public FindOneAndReplaceOptions hint(@Nullable Bson bson) {
        this.hint = bson;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public FindOneAndReplaceOptions hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public FindOneAndReplaceOptions comment(@Nullable String string) {
        this.comment = string != null ? new BsonString(string) : null;
        return this;
    }

    public FindOneAndReplaceOptions comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Nullable
    public Bson getLet() {
        return this.variables;
    }

    public FindOneAndReplaceOptions let(Bson bson) {
        this.variables = bson;
        return this;
    }

    public String toString() {
        return "FindOneAndReplaceOptions{projection=" + this.projection + ", sort=" + this.sort + ", upsert=" + this.upsert + ", returnDocument=" + (Object)((Object)this.returnDocument) + ", maxTimeMS=" + this.maxTimeMS + ", bypassDocumentValidation=" + this.bypassDocumentValidation + ", collation=" + this.collation + ", hint=" + this.hint + ", hintString" + this.hintString + ", comment=" + this.comment + ", let=" + this.variables + '}';
    }
}

