/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.conversions.Bson;

public final class GraphLookupOptions {
    private Integer maxDepth;
    private String depthField;
    private Bson restrictSearchWithMatch;

    public GraphLookupOptions depthField(@Nullable String string) {
        this.depthField = string;
        return this;
    }

    @Nullable
    public String getDepthField() {
        return this.depthField;
    }

    public GraphLookupOptions maxDepth(@Nullable Integer n) {
        this.maxDepth = n;
        return this;
    }

    @Nullable
    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public GraphLookupOptions restrictSearchWithMatch(@Nullable Bson bson) {
        this.restrictSearchWithMatch = bson;
        return this;
    }

    @Nullable
    public Bson getRestrictSearchWithMatch() {
        return this.restrictSearchWithMatch;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GraphLookupOptions graphLookupOptions = (GraphLookupOptions)object;
        if (!Objects.equals(this.maxDepth, graphLookupOptions.maxDepth)) {
            return false;
        }
        if (!Objects.equals(this.depthField, graphLookupOptions.depthField)) {
            return false;
        }
        return Objects.equals(this.restrictSearchWithMatch, graphLookupOptions.restrictSearchWithMatch);
    }

    public int hashCode() {
        int n = this.maxDepth != null ? this.maxDepth.hashCode() : 0;
        n = 31 * n + (this.depthField != null ? this.depthField.hashCode() : 0);
        n = 31 * n + (this.restrictSearchWithMatch != null ? this.restrictSearchWithMatch.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("GraphLookupOptions{");
        if (this.depthField != null) {
            stringBuilder.append("depthField='").append(this.depthField).append('\'');
            if (this.maxDepth != null) {
                stringBuilder.append(", ");
            }
        }
        if (this.maxDepth != null) {
            stringBuilder.append("maxDepth=").append(this.maxDepth);
            if (this.restrictSearchWithMatch != null) {
                stringBuilder.append(", ");
            }
        }
        if (this.restrictSearchWithMatch != null) {
            stringBuilder.append("restrictSearchWithMatch=").append(this.restrictSearchWithMatch);
        }
        return stringBuilder.append('}').toString();
    }
}

