/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class IndexOptions {
    private boolean background;
    private boolean unique;
    private String name;
    private boolean sparse;
    private Long expireAfterSeconds;
    private Integer version;
    private Bson weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textVersion;
    private Integer sphereVersion;
    private Integer bits;
    private Double min;
    private Double max;
    private Bson storageEngine;
    private Bson partialFilterExpression;
    private Collation collation;
    private Bson wildcardProjection;
    private boolean hidden;

    public boolean isBackground() {
        return this.background;
    }

    public IndexOptions background(boolean bl) {
        this.background = bl;
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public IndexOptions unique(boolean bl) {
        this.unique = bl;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public IndexOptions name(@Nullable String string) {
        this.name = string;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public IndexOptions sparse(boolean bl) {
        this.sparse = bl;
        return this;
    }

    @Nullable
    public Long getExpireAfter(TimeUnit timeUnit) {
        if (this.expireAfterSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.expireAfterSeconds, TimeUnit.SECONDS);
    }

    public IndexOptions expireAfter(@Nullable Long l, TimeUnit timeUnit) {
        this.expireAfterSeconds = l == null ? null : Long.valueOf(TimeUnit.SECONDS.convert(l, timeUnit));
        return this;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public IndexOptions version(@Nullable Integer n) {
        this.version = n;
        return this;
    }

    @Nullable
    public Bson getWeights() {
        return this.weights;
    }

    public IndexOptions weights(@Nullable Bson bson) {
        this.weights = bson;
        return this;
    }

    @Nullable
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public IndexOptions defaultLanguage(@Nullable String string) {
        this.defaultLanguage = string;
        return this;
    }

    @Nullable
    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public IndexOptions languageOverride(@Nullable String string) {
        this.languageOverride = string;
        return this;
    }

    @Nullable
    public Integer getTextVersion() {
        return this.textVersion;
    }

    public IndexOptions textVersion(@Nullable Integer n) {
        this.textVersion = n;
        return this;
    }

    @Nullable
    public Integer getSphereVersion() {
        return this.sphereVersion;
    }

    public IndexOptions sphereVersion(@Nullable Integer n) {
        this.sphereVersion = n;
        return this;
    }

    @Nullable
    public Integer getBits() {
        return this.bits;
    }

    public IndexOptions bits(@Nullable Integer n) {
        this.bits = n;
        return this;
    }

    @Nullable
    public Double getMin() {
        return this.min;
    }

    public IndexOptions min(@Nullable Double d) {
        this.min = d;
        return this;
    }

    @Nullable
    public Double getMax() {
        return this.max;
    }

    public IndexOptions max(@Nullable Double d) {
        this.max = d;
        return this;
    }

    @Nullable
    public Bson getStorageEngine() {
        return this.storageEngine;
    }

    public IndexOptions storageEngine(@Nullable Bson bson) {
        this.storageEngine = bson;
        return this;
    }

    @Nullable
    public Bson getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public IndexOptions partialFilterExpression(@Nullable Bson bson) {
        this.partialFilterExpression = bson;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public IndexOptions collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public Bson getWildcardProjection() {
        return this.wildcardProjection;
    }

    public IndexOptions wildcardProjection(Bson bson) {
        this.wildcardProjection = bson;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public IndexOptions hidden(boolean bl) {
        this.hidden = bl;
        return this;
    }

    public String toString() {
        return "IndexOptions{background=" + this.background + ", unique=" + this.unique + ", name='" + this.name + '\'' + ", sparse=" + this.sparse + ", expireAfterSeconds=" + this.expireAfterSeconds + ", version=" + this.version + ", weights=" + this.weights + ", defaultLanguage='" + this.defaultLanguage + '\'' + ", languageOverride='" + this.languageOverride + '\'' + ", textVersion=" + this.textVersion + ", sphereVersion=" + this.sphereVersion + ", bits=" + this.bits + ", min=" + this.min + ", max=" + this.max + ", storageEngine=" + this.storageEngine + ", partialFilterExpression=" + this.partialFilterExpression + ", collation=" + this.collation + ", wildcardProjection=" + this.wildcardProjection + ", hidden=" + this.hidden + '}';
    }
}

