/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Indexes {
    private Indexes() {
    }

    public static Bson ascending(String ... stringArray) {
        return Indexes.ascending(Arrays.asList(stringArray));
    }

    public static Bson ascending(List<String> list) {
        Assertions.notNull("fieldNames", list);
        return Indexes.compoundIndex(list, new BsonInt32(1));
    }

    public static Bson descending(String ... stringArray) {
        return Indexes.descending(Arrays.asList(stringArray));
    }

    public static Bson descending(List<String> list) {
        Assertions.notNull("fieldNames", list);
        return Indexes.compoundIndex(list, new BsonInt32(-1));
    }

    public static Bson geo2dsphere(String ... stringArray) {
        return Indexes.geo2dsphere(Arrays.asList(stringArray));
    }

    public static Bson geo2dsphere(List<String> list) {
        Assertions.notNull("fieldNames", list);
        return Indexes.compoundIndex(list, new BsonString("2dsphere"));
    }

    public static Bson geo2d(String string) {
        Assertions.notNull("fieldName", string);
        return new BsonDocument(string, new BsonString("2d"));
    }

    public static Bson text(String string) {
        Assertions.notNull("fieldName", string);
        return new BsonDocument(string, new BsonString("text"));
    }

    public static Bson text() {
        return Indexes.text("$**");
    }

    public static Bson hashed(String string) {
        Assertions.notNull("fieldName", string);
        return new BsonDocument(string, new BsonString("hashed"));
    }

    public static Bson compoundIndex(Bson ... bsonArray) {
        return Indexes.compoundIndex(Arrays.asList(bsonArray));
    }

    public static Bson compoundIndex(List<? extends Bson> list) {
        return new CompoundIndex(list);
    }

    private static Bson compoundIndex(List<String> list, BsonValue bsonValue) {
        BsonDocument bsonDocument = new BsonDocument();
        for (String string : list) {
            bsonDocument.append(string, bsonValue);
        }
        return bsonDocument;
    }

    private static class CompoundIndex
    implements Bson {
        private final List<? extends Bson> indexes;

        CompoundIndex(List<? extends Bson> list) {
            Assertions.notNull("indexes", list);
            this.indexes = list;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocument bsonDocument = new BsonDocument();
            for (Bson bson : this.indexes) {
                BsonDocument bsonDocument2 = bson.toBsonDocument(clazz, codecRegistry);
                for (String string : bsonDocument2.keySet()) {
                    bsonDocument.append(string, bsonDocument2.get(string));
                }
            }
            return bsonDocument;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CompoundIndex compoundIndex = (CompoundIndex)object;
            return this.indexes.equals(compoundIndex.indexes);
        }

        public int hashCode() {
            return this.indexes.hashCode();
        }
    }
}

