/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.Variable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bson.conversions.Bson;

public final class MergeOptions {
    private List<String> uniqueIdentifier;
    private WhenMatched whenMatched;
    private List<Variable<?>> variables;
    private List<Bson> whenMatchedPipeline;
    private WhenNotMatched whenNotMatched;

    public List<String> getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public MergeOptions uniqueIdentifier(String string) {
        this.uniqueIdentifier = Collections.singletonList(string);
        return this;
    }

    public MergeOptions uniqueIdentifier(List<String> list) {
        this.uniqueIdentifier = list;
        return this;
    }

    public WhenMatched getWhenMatched() {
        return this.whenMatched;
    }

    public MergeOptions whenMatched(WhenMatched whenMatched) {
        this.whenMatched = whenMatched;
        return this;
    }

    public List<Variable<?>> getVariables() {
        return this.variables;
    }

    public MergeOptions variables(List<Variable<?>> list) {
        this.variables = list;
        return this;
    }

    public List<Bson> getWhenMatchedPipeline() {
        return this.whenMatchedPipeline;
    }

    public MergeOptions whenMatchedPipeline(List<Bson> list) {
        this.whenMatchedPipeline = list;
        return this;
    }

    public WhenNotMatched getWhenNotMatched() {
        return this.whenNotMatched;
    }

    public MergeOptions whenNotMatched(WhenNotMatched whenNotMatched) {
        this.whenNotMatched = whenNotMatched;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MergeOptions mergeOptions = (MergeOptions)object;
        if (!Objects.equals(this.uniqueIdentifier, mergeOptions.uniqueIdentifier)) {
            return false;
        }
        if (this.whenMatched != mergeOptions.whenMatched) {
            return false;
        }
        if (!Objects.equals(this.variables, mergeOptions.variables)) {
            return false;
        }
        if (!Objects.equals(this.whenMatchedPipeline, mergeOptions.whenMatchedPipeline)) {
            return false;
        }
        return this.whenNotMatched == mergeOptions.whenNotMatched;
    }

    public int hashCode() {
        int n = this.uniqueIdentifier != null ? this.uniqueIdentifier.hashCode() : 0;
        n = 31 * n + (this.whenMatched != null ? this.whenMatched.hashCode() : 0);
        n = 31 * n + (this.variables != null ? this.variables.hashCode() : 0);
        n = 31 * n + (this.whenMatchedPipeline != null ? this.whenMatchedPipeline.hashCode() : 0);
        n = 31 * n + (this.whenNotMatched != null ? this.whenNotMatched.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "MergeOptions{uniqueIdentifier=" + this.uniqueIdentifier + ", whenMatched=" + (Object)((Object)this.whenMatched) + ", variables=" + this.variables + ", whenMatchedPipeline=" + this.whenMatchedPipeline + ", whenNotMatched=" + (Object)((Object)this.whenNotMatched) + '}';
    }

    public static enum WhenMatched {
        REPLACE,
        KEEP_EXISTING,
        MERGE,
        PIPELINE,
        FAIL;

    }

    public static enum WhenNotMatched {
        INSERT,
        DISCARD,
        FAIL;

    }
}

